<?php

namespace App\Http\Controllers\Admin;

use App\Models\Donation as MyModel;
use Illuminate\Http\Request;
use Jenssegers\Agent\Agent;
use DB;


class PaymentController extends AdminController
{
    public function __construct()
    {
        parent::__construct();
    }
    //////////////////////////////////////////////
    public function index(Request $request)
    {
        $data['donation'] = MyModel::orderBy('id', 'desc')
            ->leftJoin('clients as c', function ($join) {
                $join->on('c.id', '=', 'donation.client_id')->whereNull('c.deleted_at');
            })
            ->leftJoin('my_courses as m', function ($join) {
                $join->on('m.id', '=', 'donation.order_id')->whereNull('m.deleted_at');
            })
            ->leftJoin('courses as co', function ($join) {
                $join->on('co.id', '=', 'm.courses_id')->whereNull('co.deleted_at');
            })
            ->leftJoin('trainers as t', function ($join) {
                $join->on('t.id', '=', 'co.trainers')->whereNull('t.deleted_at');
            })
            ->select('donation.*', 'co.title as name_courses', 'c.name as name_clients', 't.title_ar as name_trainers')
            ->paginate(15);
        if ($request->ajax()) {
            return view('admin.donation.table-data', compact('data'))->render();
        }
        return view('admin.donation.index', compact('data'));
    }
}
