<?php



namespace App\Http\Controllers\Admin;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;

use App\Models\Posts as MyModel;

use App\Models\PostsHome;

use App\Models\PostsImage;

use App\Models\System_Constants;

use App\Models\Tag;
use App\Models\User;

use App\Models\NewsTags;

use Illuminate\Support\Facades\DB;

use Illuminate\Database\Eloquent\Builder;

use \App\Repository\CacheRepository;



class PostsController  extends  AdminController

{

    public function __construct()
    {
    }

    public function index(Request $request)
    {
        $page = request()->get('page', 1);
        $p = new MyModel();
        $title = $request->get('title');
        $category = 1;
        $from = $request->get('from');
        $to = $request->get('to');
        $user_id = $request->get('user_id');
        $data['posts'] = $p->getPosts($title, $category, $from, $to, $page, $user_id);

        $s = new System_Constants();
        $data['post_status'] = $s->constants('post_status');
        $data['post_type'] = $s->constants('post_type');
        $data['post_file'] = $s->constants('post_file');
        $data['writers'] = $s->constants('writers');
        $data['lang'] = $s->constants('lang');
        $data['post_category'] = $s->constants('post_category');
        $data['users'] = User::get(['id', 'fullname']);

        if ($request->ajax()) {
            return view('admin.posts.table-data', compact('data'))->render();
        }
        return view('admin.posts.index', compact('data'));
    }



    public function add(Request $request)
    {

        $id = $request->get('id');

        $title = $request->get('title');

        if ($title) {

            $p =  new MyModel();

            if ($id == 0) {

                $saved = $p->add($title);
            } else {

                $obj = $p->getpost($id);

                $saved = $p->update_title($obj, $title);
            }

            return response()->json(['status' => true, 'data' => $saved->id]);
        }
    }



    public function edit(Request $request)
    {

        $id  = $request->get('id');

        $p =  new MyModel();
        $item =  $p->getpost($id);

        if ($item) {

            $builder = '';

            if ($item->tags and count($item->tags)) {

                foreach ($item->tags as $tag) {

                    $builder .= '<li class="' . $tag->name . '"  data-id="' . $tag->id . '" data-name="' . $tag->name . '">';

                    $builder .= '<button type="button"  data-id="' . $tag->id . '" class="btn btn-light btn-sm delet_tag_select">';

                    $builder .= '<i class="fas fa-times text-danger"></i>';

                    $builder .= '</button>&nbsp; ';

                    $builder .= $tag->name;

                    $builder .= '</li>';
                }
            }

            return response()->json(['status' => true, 'data' => $item, 'tags' => $builder]);
        }

        return response()->json(['status' => false, 'data' => 'عذرا حدث خطأ أثناء العميلة']);
    }



    public function add_post(Request $request)
    {

        $decs_photo = $request->get('desc_photo');

        $category = $request->get('category');

        $file = $request->get('file');

        $date = $request->get('date');

        $newstype = $request->get('NewsType');

        $lang = $request->get('lang');

        $status = $request->get('status');

        $main_image = $request->get('main_image');

        $title = $request->get('title');

        $summary = $request->get('summary');

        $details = $request->get('details');

        $writers = $request->get('writers');

        $eshari = $request->get('eshari');



        $socil_images = $request->get('socil_images');

        $socil_images_title = $request->get('socil_images_title');

        $summarysocil_images = $request->get('summarysocil_images');





        if (isset($request['SlideNews'])) {

            $slidenews = 1;
        } else {

            $slidenews = 0;
        }



        $date_published = $request->get('date_published');



        $posts_id = $request->get('posts_id');

        $hidden = $request->get('hidden');





        $p = new MyModel();

        $obj = $p->getpost($posts_id);

        if ($obj == '') {

            return response()->json(['status' => false, 'data' => 'عذرا، لا يوجد عنوان للخبر']);
        }



        if ($hidden == 0) {

            $rules = [

                'title' => 'required',

                'summary' => 'required|max:150',

                'details' => 'required',

                'main_image' => 'required',

                'decs_photo' => 'required',

                'category' => 'required',

                'date' => 'required',

            ];



            $messages = [
                'title.required' => 'العنوان مطلوب',
                'summary.required' => 'الملخص مطلوب',
                'summary.max' => 'الملخص لا يزيد عن 150 حرف',
                'details.required' => 'التفاصيل مطلوبة',
                'main_image.required' => 'الصورة الرئيسية مطلوبة',
                'decs_photo.required' => 'وصف الصورة مطلوب',
                'category.required' => 'التصنيف مطلوب',
                'date.required' => 'التاريخ مطلوب',
            ];



            $validator = \Validator::make(
                [

                    'title' => $title,

                    'summary' => $summary,

                    'details' => $details,

                    'main_image' => $main_image,

                    'decs_photo' => $decs_photo,

                    'category' => $category,

                    'date' => $date,

                ],

                $rules,

                $messages

            );
        } else {

            $rules = [

                'title' => 'required',

                'summary' => 'required|max:150',

                'details' => 'required',

                'main_image' => 'nullable',

                'decs_photo' => 'required',

                'category' => 'required',

                'date' => 'required',
                'lang' => 'required',
            ];



            $messages = [

                'title.required' => 'العنوان مطلوب',

                'summary.required' => 'الملخص مطلوب',
                'summary.max' => 'الملخص لا يزيد عن 150 حرف',
                'details.required' => 'التفاصيل مطلوبة',

                'decs_photo.required' => 'وصف الصورة مطلوب',

                'category.required' => 'التصنيف مطلوب',

                'date.required' => 'التاريخ مطلوب',
                'lang.required' => 'اللغة مطلوبة',
            ];



            $validator = \Validator::make(
                [

                    'title' => $title,

                    'summary' => $summary,

                    'details' => $details,

                    'decs_photo' => $decs_photo,

                    'category' => $category,

                    'date' => $date,
                    'lang' => $lang,

                ],

                $rules,

                $messages

            );
        }





        if ($validator->fails()) {

            return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
        }





        \DB::beginTransaction();

        try {



            if ($hidden == 0) {



                if (!\Auth::user()->hasPermissionTo('status_posts')) {

                    $status = 2;
                }




                $p = new MyModel();

                $max_post = MyModel::withTrashed()->max('posts_id');

                if ($max_post) {

                    $max = $max_post + 1;
                } else {

                    $max = 1;
                }
            } else {

                $max = $obj->posts_id;
            }



            $saved = $p->add_post($obj, $decs_photo, $category, $file, $date,  $lang, $status, $main_image, $title, $summary, $details,$date_published, $max, $eshari, $writers, $socil_images, $socil_images_title, $summarysocil_images);

            if (!$saved) {

                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }


            $ph = new PostsHome();




            $removedImages = $request->input('remove_additional_image');

            if ($removedImages) {

                for ($i = 0; $i < count($removedImages); $i++) {

                    $postsImage = PostsImage::find($removedImages[$i]);

                    $postsImage->delete();
                }
            }

            $titles = $request->input('additional_image_title');
            $array =  array();
            if ($titles) {

                for ($i = 0; $i < count($titles); $i++) {

                    $pic2 = '';

                    $pic2 = \Str::random(8) . $i . $posts_id . '' . strtotime(date("Y-m-d H:i:s")) . '.' . $request->file('additional_image.' . $i)->getClientOriginalExtension();

                    $request->file('additional_image.' . $i)->move(public_path('uploads'), $pic2);

                    $postsImage = new PostsImage();

                    $postsImage->title = $titles[$i];

                    $postsImage->image = $pic2;

                    $postsImage->posts_id = $posts_id;

                    $postsImage->user_id = \Auth::user()->id;

                    $postsImage->save();
                }
            }





            \DB::commit();

            return response()->json(['status' => true, 'data' => 'تمت العملية بنجاح']);
        } catch (\Exception $e) {

            \DB::rollback();
        }



        return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
    }



    public function delete(Request $request)
    {

        $id  = $request->get('id');

        $p =  MyModel::find($id);

        if ($p) {

            $deleted = $p->delete();

            if ($deleted) {

                return response()->json(['status' => true, 'data' => 'تمت الحذف بنجاح']);
            }

            return response()->json(['status' => false, 'data' => 'عذرا حدث خطأ أثناء العميلة']);
        }

        return response()->json(['status' => false, 'data' => 'عذرا حدث خطأ أثناء العميلة']);
    }



    public function add_tag(Request $request)
    {

        $post_id = $request->get('post_id');;

        $tag_id = $request->get('tag_id');;

        $search_tag = $request->get('search_tag'); //اسم الوسم 

        $status = 1; // حالة الوسم 



        $rules = [

            'search_tag' => 'required',



        ];



        $messages = [

            'search_tag.required' => 'اسم الوسم مطلوب',



        ];



        $validator = \Validator::make(
            [

                'search_tag' => $search_tag,

            ],

            $rules,

            $messages

        );



        if ($validator->fails()) {



            return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
        }



        if ($post_id == 0) {



            return response()->json(['status' => false, 'data' => ' يرجى تحديد عنوان الخبر ']);
        }





        $tag = Tag::where('name', $search_tag)->first();



        if ($tag) {

            $p =  new NewsTags();

            $item =  $p->getNewsTags($post_id, $tag_id);



            if ($item) {

                return response()->json(['status' => false, 'data' => 'الوسم مضاف مسبقا']);
            } else {

                $saved = $p->add_newstags($post_id, $tag_id);

                $builder = "";

                $builder .= '<li class="tags"  data-id="' . $tag->id . '" >';

                $builder .= '<button type="button"  data-id="' . $tag->id . '" class="btn btn-light btn-sm delet_tag_select">';

                $builder .= '<i class="fas fa-times text-danger"></i>';

                $builder .= '</button>&nbsp; ';

                $builder .= $tag->name;

                $builder .= '</li>';

                return response()->json(['status' => true, 'data' => 'تمت الاضافة', 'tag' => $builder]);
            }
        } else {

            $tag = new Tag();

            $saved = $tag->add_tagg($search_tag, $status);



            $newstags = new NewsTags;

            $saved = $newstags->add_newstags($post_id, $tag->id);

            $builder = "";

            $builder .= '<li class="' . $tag->name . '"  data-id="' . $tag->id . '" data-name="' . $tag->name . '">';

            $builder .= '<button type="button"  data-id="' . $tag->id . '" class="btn btn-light btn-sm delet_tag_select">';

            $builder .= '<i class="fas fa-times text-danger"></i>';

            $builder .= '</button>&nbsp; ';

            $builder .= $tag->name;

            $builder .= '</li>';

            return response()->json(['status' => true, 'data' => 'تمت العملية بنجاح', 'tag' => $builder]);
        }
    }



    public function search(Request $request)

    {

        $value = $request->get('value');



        $search_str = "%" . str_replace(" ", "%", trim($value)) . "%";

        $tags = Tag::where(function ($query) use ($search_str) {

            $query->where('name', 'LIKE', $search_str);
        })->where('status', '1')->limit(10)->get();

        $builder = "";

        foreach ($tags as $tag) {

            $builder .= '<li class="" data-id="' . $tag->id . '" >';

            $builder .= '<span>' . $tag->name . ' </span>';

            $builder .= '</li>';
        }

        return $builder;
    }



    public function  tag_select(Request $request)

    {

        $id  = $request->get('id');

        $tag =  new Tag();

        $tags =  $tag->gettags($id);





        return response()->json(['status' => true, 'data' => $tags]);
    }



    public function delete_news_tag(Request $request)
    {



        $tag_id  = $request->get('id');

        $tag = Tag::where('id', $tag_id)->first();

        $newstags =  NewsTags::where('tag_id', $tag_id);

        if ($newstags) {

            $deleted = $newstags->delete();

            if ($deleted) {

                return response()->json(['status' => true, 'data' => $tag]);
            }

            return response()->json(['status' => false, 'data' => 'عذرا حدث خطأ أثناء العميلة']);
        }

        return response()->json(['status' => false, 'data' => 'عذرا حدث خطأ أثناء العميلة']);
    }
}
