<?php

namespace App\Http\Controllers\Admin;

use App\Models\Setting as MyModel;
use Illuminate\Http\Request;
use Jenssegers\Agent\Agent;
use DB;


class SettingController extends AdminController
{
    public function __construct()
    {
        parent::__construct();

    }
    //////////////////////////////////////////////
    public function index(Request $request)
    {
        $userhasper = \Auth::user();
        
            $setting = new MyModel();
            $data['setting'] = $setting->getsetting(1);
            return view('admin.setting.index',compact('data'));
        
  
    }
/***********************************************************************************************************************/
    public function update(Request $request){
            $name_ar = $request->get('title_ar');
            $description = $request->get('description');
            $email = $request->get('email');
            $mobile = $request->get('mobile');
            $key_words = $request->get('key_words');
            $name_en = $request->get('title_en');
            $description_en = $request->get('description_en');
            $key_words_en = $request->get('key_words_en');


            $moyasar_key = $request->get('moyasar_key');
            $userName = $request->get('userName');
            $userSender = $request->get('userSender');
            $apiKey = $request->get('apiKey');

            



            $rules = [
                'name_ar' => 'required',
                'description' => 'required',
                'email' => 'required',
                'key_words' => 'required',

                'moyasar_key' => 'required',
                'userName' => 'required',
                'userSender' => 'required',
                'apiKey' => 'required',

            ];
    
            
            $messages = [
                'name_ar.required' => 'عنوان الموقع باللغة العربية مطلوب',
                'description.required' =>'وصف الموقع باللغة العربية مطلوب',
                'email.required' => 'البريد الالكتروني مطلوب',
                'key_words.required' => 'كلمات دلالية باللغة العربية مطلوبة', 
                
                'moyasar_key.required' => 'البريد الالكتروني مطلوب',
                'userName.required' => 'البريد الالكتروني مطلوب',
                'userSender.required' => 'البريد الالكتروني مطلوب',
                'apiKey.required' => 'البريد الالكتروني مطلوب',

            ];
            $validator = \Validator::make([
                'name_ar' => $name_ar,
                'description' => $description,
                'email' => $email,
                'key_words' => $key_words,

                'moyasar_key' => $moyasar_key,
                'userName' => $userName,
                'userSender' => $userSender,
                'apiKey' => $apiKey,

            ],
            $rules
            ,
            $messages
            );     
    
            if ($validator->fails()) {
                return response()->json(['status' => false , 'data_validator' => $validator->messages()]);
            }
            
            $setting = new MyModel();
            $obj = $setting->getsetting(1);
            $saved =  $setting->setting($obj,$name_ar,$email,$mobile,$description,$key_words,$name_en,$description_en,$key_words_en,$moyasar_key,$userName,$userSender,$apiKey);
            if(!$saved){
                return response()->json(['status' => false , 'message' => 'حدث خطأ أثناء العملية']);
            }
        
            return response()->json(['status' => true , 'message' => 'تم تعديل البيانات' , 'data' => $saved]);
            
        }

    public function dateformat($date){
        return date("Y-m-d", strtotime($date));
    }
}