<?php

namespace App\Http\Controllers\Admin;
use App\Models\Statistics as MyModel;
use App\Models\System_Constants;
use Illuminate\Http\Request;


class StatisticsController extends AdminController
{
    public function __construct()
    {
    }
    //////////////////////////////////////////////
    public function index(Request $request)
    {
       
        $data['slider'] = MyModel::orderBy('id','desc')->paginate(15);
        $data['system'] = System_Constants::where('status',1)->where('type','lang')->select("value2","name_ar as name")->get();
        if ($request->ajax()) {
            return view('admin.statistics.table-data', compact('data'))->render();
        }
        return view('admin.statistics.index',compact('data'));
    }
  /***********************************************************************************************************************/
    public function add(Request $request){
        
        $hidden = $request->get('hidden');
        if($hidden == 0){
            $user_id = \Auth::user()->id;
            $title_ar = $request->get('title_ar');
            $title_en = $request->get('title_en');
            $number = $request->get('number');
            if(isset($request['activeValue'])){
                $status = 1;
            }else{
                $status = 0;
            }

            $rules = [
                'title' => 'required',
                'number' => 'required',
            ];
    
            $messages = [
                'title.required' => 'العنوان مطلوب',
                'number.required' => 'الرقم مطلوب',
            ];
    
            $validator = \Validator::make([
                'title' => $title_ar,
                'number' => $number,
            ],
                $rules
                ,
                $messages
            );

            if ($validator->fails()) {
                $all = collect($validator->errors()->getMessages())->map(function($item){
                    return $item[0];
                });
                  $strs = [];
                foreach ($all as $value) {
                    $strs[]=  $value;
                }
                return response()->json(['status' => false , 'data' => implode(',',$strs)]);
            }

            $item = new MyModel();
            $item->user_id = $user_id;
            $item->title_ar = $title_ar;
            $item->title_en = $title_en;
            $item->status = $status;
            $item->number = $number;
            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء عملية الإضافة']);
            }
            return response()->json(['status' => true , 'data' => 'تمت عملية الإضافة']);
        }else{
            return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء عملية الإضافة']);
        }
        

    }
/***********************************************************************************************************************/
    public function edit(Request $request){
      
        $id = $request->get('id');
            $item = MyModel::find($id);
            if($item != ''){
                return response()->json(['status' => true , 'data' => $item]);
            }else{
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }
    }

    /***********************************************************************************************************************/

    public function UpdateStats(Request $request){
      
        $id = $request->get('id');
        $item = MyModel::find($id);
            if($item != ''){
                if($item->status == 0){
                    $item->status = 1;
                }else{
                    $item->status = 0;
                }
                $saved = $item->save();
                if(!$saved){
                    return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
                }
                return response()->json(['status' => true , 'data' => 'تم تعديل الحالة']);
            }else{
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }
    }
/***********************************************************************************************************************/
    public function update(Request $request){
     
        $hidden = $request->get('hidden');

        if($hidden != 0){
            $user_id = \Auth::user()->id;
            $number = $request->get('number');
            $title_ar = $request->get('title_ar');
            $title_en = $request->get('title_en');
            if(isset($request['activeValue'])){
                $status = 1;
            }else{
                $status = 0;
            }

            $rules = [
                'title' => 'required',
                'number' => 'required',
            ];
    
            $messages = [
                'title.required' => 'العنوان  مطلوب',
                'number.required' => 'الرقم مطلوب',
            ];
    
            $validator = \Validator::make([
                'title' => $title_ar,
                'number' => $number,
            ],
                $rules
                ,
                $messages
            );
    
            if ($validator->fails()) {
                $all = collect($validator->errors()->getMessages())->map(function($item){
                    return $item[0];
                });
                  $strs = [];
                foreach ($all as $value) {
                    $strs[]=  $value;
                }
                return response()->json(['status' => false , 'data' => implode(',',$strs)]);
            }

            $item = MyModel::find($hidden); 
        
          
            if($item != ''){
                $item->user_id = $user_id;
                $item->status = $status;
                $item->title_ar = $title_ar;
                $item->title_en = $title_en;
                $item->number = $number;
                $saved = $item->save();
                if(!$saved){
                    return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
                }
                return response()->json(['status' => true , 'data' => 'تم تعديل البيانات']);
            }else{
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }

        }
    }

    public function delete(Request $request){
     
        $id = $request->get('id');
        $item = MyModel::find($id);
        if($item != ''){
            $deleted = $item->delete();
            if(!$deleted){
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true , 'data' => 'تم الحذف بنجاح']);
        }else{
            return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
        }

    }
}