<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MyCourses extends Model
{
    use SoftDeletes;
    protected $table = 'my_courses';
    protected $fillable = ['date', 'courses_id', 'client_id'];

    public function getfavorite($id)
    {
        $favorite = $this;
        return $favorite::select('courses_id')->where('client_id', $id)->paginate(10);
    }

    public function getImageAttribute($img)
    {
        return asset('uploads/' . $img);
    }
}
