@extends('admin.layout.master_layout')

@section('title')
الطلاب
@endsection

@section('style')
	<style>
		@media (min-width: 992px) {
			.modal-lg, .modal-xl {
				max-width: 800px;
			}
		}
		.modal-lg, .modal-xl {
			max-width: 800px;
		}
	</style>
@stop

@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/admin/clients" class="m-nav__link">
                            <span class="m-nav__link-text">  الطلاب</span>
                        </a>
                    </li>
                </ul>

                <div class="m-demo__preview  m-demo__preview--btn">
                    @can('add_clients')
                    <button type="button" class="btn btn-danger m-btn m-btn--custom btnAddCustomer" style="line-height: 15px;padding-bottom: 15px;">
                        <i class="fa fa-plus"></i>إضافة جديد
                    </button>
                    @endcan 
                </div>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">

			<div class="filter row mb-4 mt-2">
               
                <div class="col-md-4">
                    <input type="text" name="name_search"  class="form-control name_search" placeholder=" الاسم / البريد الالكتروني ">
                </div>
				<div class="col-md-4">
                    <input type="text" name="mobile_search"  class="form-control mobile_search" placeholder=" رقم الجوال    ">
                </div>
                {{-- <div class="col-md-2">
                    <div class="form-valid">
                        <select name="governorate_search" class="form-control governorate_search" id="governorate_search">
                            <option value="">اختر المنطقة</option>
                            @foreach($data['governorate'] as $constant)
                                <option value="{{$constant->id}}">{{$constant->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
				<div class="col-md-2">
                    <div class="form-valid">
                        <select name="city_search" class="form-control city_search" id="city_search">
                            <option value="">اختر المدينه</option>
                            @foreach($data['city'] as $constant)
                                <option value="{{$constant->id}}">{{$constant->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div> --}}
				<div class="col-md-4">
                    <div class="form-valid">
                        <select name="Degree_search" class="form-control Degree_search" id="Degree_search">
                            <option value="">اختر الدرجة العلمية</option>
                            @foreach($data['Degree'] as $constant)
                                <option value="{{$constant->id}}">{{$constant->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

            </div>

            <div class="">

                <div id="table-container">

                    @include('admin.clients.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>


@include('admin.clients.sub.add')

@stop




@section('js')
	<script type="text/javascript">
		/************************************************************************************************************* */
		$('.name_search').on('input',function(e){
			name =  $('.name_search').val();
			if(name.length >= 3 || name == ''){
				var url = $(this).attr('href');
				getData(url);
			}
		});
		/************************************************************************************************************* */
		$('.mobile_search').on('input',function(e){
			name =  $('.mobile_search').val();
			if(name.length >= 3 || name == ''){
				var url = $(this).attr('href');
				getData(url);
			}
		});


		/************************************************************************************************************* */
		$('.governorate_search').on('change',function(e){
			governorate =  $('.governorate_search').val();
			var url = $(this).attr('href');
			getData(url);
		});
		/************************************************************************************************************* */
		$('.city_search').on('change',function(e){
			city =  $('.city_search').val();
			var url = $(this).attr('href');
			getData(url);
		});
		/************************************************************************************************************* */
		$('.Degree_search').on('change',function(e){
			Degree =  $('.Degree_search').val();
			var type = $('.type').val();
			var url = $(this).attr('href');
			getData(url);
		});


		/***********************************************************************************************************************/
		$('body').on('click','.UpdateStats',function(){
			$('#load').show();
			$(this).addClass('disabled');
			$('.loadImg').removeClass('hidden');
			$('.loadMSG').html('{{ __('app.update_status') }}');
			var thisTag = $(this);
			var id = $(this).data('id');
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}
			});
			$.ajax({
				url: "/admin/clients/UpdateStats",
				type: "POST",
				dataType: "JSON",
				data:{id:id},
				success: function(data) {
					$('#load').hide();
					if(data["status"] == true){
						var url = $(this).attr('href');
						getData(url);
					}else{
						swal({
								title: "",
								text: data["data"],
								type: "error",
								showCancelButton: false,
								confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسناً",
                            cancelButtonText: "إلغاء",
								closeOnConfirm: true,
								closeOnCancel: true
							});
					}
				}
			});
			$(thisTag).removeClass('disabled');
			$('.loadImg').addClass('hidden');
		});

		$(document).on('click', '.pagination a',function(event) {
			event.preventDefault();
			$('li').removeClass('active');
			$(this).parent('li').addClass('active');
			var url = $(this).attr('href');
			getData(url);
		});

		function getData(url) {
			$('#load').show();
			var name =  $('.name_search').val();
			var mobile =  $('.mobile_search').val();
			var governorate =  $('.governorate_search').val(); 
			var city =  $('.city_search').val();
			var Degree =  $('.Degree_search').val();
	

			$.ajax({
				url : url,
				data:{
					name:name,
					mobile:mobile,
					governorate:governorate,
					city:city,
					Degree:Degree

				}
			}).done(function (data) {
				$("#table-container").empty().html(data);
				$('#load').hide();
			});
		}


	</script>
<script type="text/javascript">
	$(document).ready(function () {


		


		function reset_form() {
			$('#activeValue').bootstrapSwitch('state', false, true);
			$('#must_delete').bootstrapSwitch('state', false, true);
			$('#addNewpageForm')[0].reset();
			$('#addNewpageForm').find('.rowIdUpdate').val(0);
		}
		/*************************************************/
		$(document).on('click', '.btnAddCustomer', function () {
			reset_form();
			$('#add_page .modal-title').html('اضافة مستخدم جديد');
			$('#add_page').modal('show');

		});


		$(document).on('click','.password-modal',function(e){
			$('#changepassword #loading').show();
			id = $(this).data('id');
			$.ajax({
				url: "/admin/clients/edit",
				type: "get",
				dataType: "JSON",
				data: {
					id: id
				},
				success: function(data){
					$('#changepassword #loading').hide();
					if(data['status'] == true){
						$('.password').val('');
						$(".confirm_password").val('');
						$('.name').val(data['data']['name']);

						$('.clientIdUpdate').val(data['data']['id']);

					}else{
						swal({
								title: "",
								text: data["data"],
								type: "error",
								showCancelButton: false,
								confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسناً",
                            cancelButtonText: "إلغاء",
								closeOnConfirm: true,
								closeOnCancel: true
							});
					}
				},
				complete: function () {
					$('#changepassword').modal('show');
				}
			});

		});

		/*************************************************/
		$(document).on('click', '.updateDetails', function () {
			$('#addNewpageForm #loading').show();
			$('#addNewpageForm').find('.rowIdUpdate').val(0);
			var id = $(this).data('id');
			$('.rowIdUpdate').val(id);
			$.ajax({
				url: "/admin/clients/edit",
				type: "get",
				dataType: "JSON",
				data: {
					id: id
				},
				success: function(data){
					$('#addNewpageForm #loading').hide();
					if(data['status'] == true){
						$('#addNewpageForm').find(".name").val(data['data']['name']);
						$('#addNewpageForm').find(".email").val(data['data']['email']);
						$('#addNewpageForm').find(".mobile").val(data['data']['mobile']);
                        $('#addNewpageForm').find(".state_key").val(data['data']['state_key']);
                        $('#addNewpageForm').find(".password").val('');

						if(data['data']['status'] == 1){
							$('#activeValue').bootstrapSwitch('state', true, true);
						}else{
							$('#activeValue').bootstrapSwitch('state', false, true);
						}

					}
				},
				complete: function () {
					$('#add_page').modal('show');
				},
				error: function (jqXHR, textStatus, errorThrown) {
					swal({title: 'خطأ', type: "error"});
				}
			});

			$('#add_page .modal-title').html('تعديل البيانات');
			$('.btn_save_client').html('تعديل');

		});
		/*************************************************/
		$('.addNewpageForm').on('submit', function(e){
			$('#addNewpageForm #loading').show();
			e.preventDefault();
			var formData = new FormData(this);
			$('.loader_add_client').css('display', 'initial');
			setTimeout(function () {
				$('.btn_save_customer').removeClass('disabled');
				$('.loader_add_client').css('display', 'none');
			}, 30000);
			var id = $(".rowIdUpdate").val();
			var action_url =  (id == 0) ? "/admin/clients/add" : "/admin/clients/update"
			$.ajax({
				url: action_url,
				type: "post",
				cache:false,
				contentType: false,
				processData: false,
				data: formData,
				success: function (data) {
					$('#addNewpageForm #loading').hide();
					if (data["status"] == true) {
					    console.log(data);
						swal({
							title: "",
							text: "تمت العملية بنجاح",
							type: "success",
							showCancelButton: false,
							confirmButtonColor: "#DD6B55",
							confirmButtonText: "تم",
							cancelButtonText: "إلغاء",
							closeOnConfirm: true,
							closeOnCancel: true
						});
						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
						var pathname = $(location).attr("pathname");
						var page = $('.pagination .active span').text();
						url = origin+pathname+'?page='+page;
						getData(url);
						reset_form();
						$("#add_page").modal("hide");
					} else {
                        var dt = '<ul>';
                        $.each(data["data_validator"], function (key, value) {
                            dt = dt + '<li>' + value + '</li>';
                        })
                        dt =dt+ '</ul>';
                        swal({
                            title: data["data"],
                            text: data["data"],
                            type: "error",
                            html:dt,
                            showCancelButton: false,
                            confirmButtonColor: "#DD6B55",
                            confirmButtonText: "حسناً",
                            cancelButtonText: "إلغاء",
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });
					}
				},
				error: function (jqXHR, textStatus, errorThrown) {
					$('#addNewpageForm #loading').hide();
					swal({title: '{{ __('app.whoops') }}', type: "error"});
				}
			});
		});
	});
	/**************************************************************************************************************************/
	$(document).on('click','.delete',function(e){
		var id = $(this).data('id');
		Swal.fire({
				title: 'هل انت متاكد من حذف هذا العميل ',
				text: "",
				type: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				confirmButtonText: 'نعم ',
				cancelButtonText: "إلغاء",
			}).then((result) => {
				if (result.value) {
				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
				$.ajax({
				url: "/admin/clients/delete",
				type: "post",
				dataType: "JSON",
				data: {
					id: id
				},
				success: function(data){
					if(data['status'] == true){
                        Swal.fire({
                            title: "",
                            text: data["data"],
                            type: "success",
                            showCancelButton: false,
                            confirmButtonColor: "#DD6B55",
                            confirmButtonText: 'حسنا ',
                            cancelButtonText: " الغاء",
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });
						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
						getData(url);
						window.history.pushState("", "", url);
					}else{
						swal({
								title: "",
								text: data["data"],
								type: "error",
								showCancelButton: false,
								confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسناً",
                            cancelButtonText: "إلغاء",
								closeOnConfirm: true,
								closeOnCancel: true
							});
					}
				},
			});
				}
			})
	});
	/*************************************************************************************************************************/

	$('#changepasswordform').on('submit', function(e){
		e.preventDefault();
		$('#changepasswordform #loading').show();
		var formData = new FormData(this);
		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			}
		});
		$.ajax({
			url: "/admin/clients/changepassword",
			type: "post",
			cache:false,
			contentType: false,
			processData: false,
			data: formData,
			success: function (data) {
				$('#changepasswordform #loading').hide();
				if (data["status"] == true) {
					swal({
						title: "",
						text: data["data"],
						type: "success",
						showCancelButton: false,
						confirmButtonColor: "#DD6B55",
                        confirmButtonText: "حسناً",
                            cancelButtonText: "إلغاء",
						closeOnConfirm: true,
						closeOnCancel: true
					});
					var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
					getData(url);
					$('#changepasswordform').find(".password").val('');
					$('#changepasswordform').find(".confirm_password").val('');
					$('#changepasswordform').find(".clientIdUpdate").val('');
					$("#changepassword").modal("hide");
				} else {
					swal({
						title: "",
						text: data["data"],
						type: "error",
						showCancelButton: false,
						confirmButtonColor: "#DD6B55",
                        confirmButtonText: "حسناً",
                            cancelButtonText: "إلغاء",
						closeOnConfirm: true,
						closeOnCancel: true
					});

				}
			}
		});
	});
</script>
<script>
            $(document).on('click','.show_fav',function(e){
            id = $(this).data('id');
            $.ajax({
                    url: "/admin/clients/showfavorite",
                    type: "get",
                    dataType: "JSON",
                    data: {
                        id: id,
                    },
                    success: function(data){
                        $('#favorite #table-container').html(data['data']);
                    },
                    complete: function () {
                        $('#favorite #table-container .name').html(name);
                        // $('#favorite #table-container .fv').html(fa);
                        $('#favorite').modal('show');
                    }
                })
            });
</script>
@stop
