@extends('admin.layout.master_layout')
@section('title')
   {{__('text.control_panel')}}
@stop
@section('css')
    <style>
        .search_result_order {
            position: absolute;
            left: 12px;
            top: 38px;
            width: 90%;
            display: none;
            background: white;
            border-radius: 4px;
            z-index: 9;
            padding: 0;
            margin: 0;
            border: 1px solid #ccc;
        }
        .search_result_order li {
            list-style: none;
            color: #9a9a9a;
            padding: 12px 10px;
            border-bottom: 1px solid #e8e8e8;
            cursor: hand;
            cursor: pointer;
        }
        .search_result_order li.selected {
            background: #dedbdb96;
        }
        #loading{
            display:none;
        }
        .modal{
            overflow-y: auto;
        }

        @media (min-width: 992px){
            .modal-lg {
                max-width: 1300px;
            }
        }

        .form-control{
            padding: 0.5rem 1.15rem !important;
        }
        .main_label ,.additoin_label{
            overflow: hidden;
        }

        .removable{
        position: relative;
        display: inline-block ;
        }
        .removable .btn-remove {
            position: absolute;
            top: 2px;
            left: 2px;
            z-index: 100;
            border-radius: 50%;
            cursor: pointer;
            display: none;
        }
    </style>
    
@endsection
@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.posts.index') }}" class="m-nav__link">
                            <span class="m-nav__link-text"> الأخبار</span>
                        </a>
                    </li>
                </ul>

                <div class="m-demo__preview  m-demo__preview--btn">
                    @can('add_posts')
                    <button type="button"   class="btn btn-danger m-btn m-btn--custom btn_add_post" style="line-height: 15px;"><i class="fa fa-plus"></i> إضافة خبر</button>
                    @endcan
                </div>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">

            <div class="filter row mb-4 mt-2">
                <div class="col">
                    <input type="text" class="form-control title-filter" placeholder="العنوان">
                </div>
                <div class="col">
                    <input type="text" class="form-control date-picker from" placeholder="من">
                </div>
                <div class="col">
                    <input type="text" class="form-control date-picker to"  placeholder="إلى">
                </div>
                <div class="col">
                    <select name="" class="form-control user_id" id="">
                        <option value="">المستخدم</option>
                        @foreach($data['users'] as $users)
                            <option value="{{$users->id}}">{{$users->fullname}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="">

                <div id="table-container">

                    @include('admin.posts.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>





@include('admin.posts.sub.add')
@include('admin.uploads.upload')
@endsection


@section('js')

<script>
    $('.title-filter').on('input',function(e){
        var title = $('.title-filter').val();
        if(title.length > 3 || title.length <= 0){
            var url = $(this).attr('href');
            getData(url);
        }
    });
    $('.category-filter').on('change',function(e){
        var url = $(this).attr('href');
        getData(url);
    });
    $('.user_id').on('change',function(e){
        var url = $(this).attr('href');
        getData(url);
    });

</script>
<script>

</script>
<script>

$(".summary").on("input", function() {
    var count = this.value.length;
    $(".num_char").text(count);
});


$(document).on('click', '#table-container .pagination a',function(event){
    event.preventDefault();
    $('li').removeClass('active');
    $(this).parent('li').addClass('active');
    var url = $(this).attr('href');
    getData(url);
});

    function getData(url) {
        $('#load').show();
        var title = $('.title-filter').val();
        var user_id = $('.user_id').val();
        var category = $('.category-filter').val();
        var from = $('.from').val();
        var to = $('.to').val();
        $.ajax({
            url : url,
            data:{title:title,category:category,from:from,to:to,user_id:user_id},
        }).done(function (data) {
            $("#table-container").empty().html(data);
            $('#load').hide();
        });
    }
</script>

        <script>

            //  function readURL(input) {
            //     if (input.files && input.files[0]) {
            //         var reader = new FileReader();
            //         reader.onload = function (e) {
            //             $('.img_review img').attr('src', e.target.result);
            //         };
            //         reader.readAsDataURL(input.files[0]);
            //     }
            // }


            function readADDURL(input,target) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                    $(target).attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                    return true;
                }
                else{
                    $(target).attr('src', '');
                    $(input).next('label').text('اختر الصورة الإضافية');
                    return false;
                }
            }

            // $('#search_tag').focusout(function(){
            //     $('.tag_search_dropdown').html('');
            //     $('.tag_search_dropdown').css('display','none');
            // });

             function clearNews(){
                $('.title_error').html('');
                $('.eshari_error').html('');
                $('.summary_error').html('');
                $('.num_char').text(0);
                $('.details_error').html('');
                $('.title').val('');
                $('.summary').val('');
                $('.main_image').val('');
                $('.desc-photo').val('');
                $('.category').val(1);
                $('.file').val('');
                $('.eshari').val('');
                $('.NewsType').val('');
                $('.lang').val('1');
                $('.status').val('1');
                $('.hidden').val('0');
                $('.posts_id').val(0);
                $('.date_published').datetimepicker("setDate", new Date());
                $('.date').datepicker("setDate", new Date());
                $('.writers').val('');
                $('#search_tag').val('');
                $('.tag_select_dropdown').html('');
                $('#additionalImagesPreview').html('');
                $('#newAdditionalImagesPreview').html('');
                $('.additoin_label').html('اختر الصورة الإضافية');
                $('.main_label').html('الصورة الرئيسية');
                $('.modal-title').html('إضافة خبر');
                $('.img_review img').attr('src','/admin/assets/app/media/no_image.jpg');
                $('.socil_images_title').val('');
                $('.summarysocil_images').val('');
                $('.img_review_social img').attr('src','/admin/assets/app/media/no_image.jpg');
                $('#SlideNews').bootstrapSwitch('state', false, true);
                $('#importantNews').bootstrapSwitch('state', true, true);
                CKEDITOR.instances['details'].setData('');
                $('.tag_search_dropdown').html('');
                $('#socil_images').val('');
                $('.search_tag').val('');
                $('.tag_search_dropdown').css('display','none');
            }
        </script>
        <script>
            $('#SlideNews').bootstrapSwitch('state', false, true);
            $('#importantNews').bootstrapSwitch('state', false, true);

                $(document).ready(function () {
                    CKEDITOR.replace('details');
                    $('.to,.from').datepicker({
                        format: 'yyyy-mm-dd',
                        calendarWeeks: true,
                        todayHighlight: true,
                        autoclose: true,
                        language:"ar",
                        rtl:true
                    }).on("change", function() {
                    var url = $(this).attr('href');
                        getData(url);
                    });
                 
                 
                })
        </script>
        <script>
            $('.btn_add_post').on('click',function(e){
                clearNews();
            $('.date-picker').datepicker({
                weekStart: 1,
                autoclose: true,
                format: "yyyy-mm-dd",
                todayHighlight: true,
                 language:"ar",
                 rtl:true
            });
                $('#modal_post').modal('show');
            });
        </script>
        <script>
                function CKupdate(){
                    for ( instance in CKEDITOR.instances )
                        CKEDITOR.instances[instance].updateElement();
                    }
        </script>


        <script>


            $('.title').focusout(function(e){
                var title = $(this).val();
                var id = $('.posts_id').val();
                var hidden = $('.hidden').val();
                $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
                });
                if(hidden == 0){
                    $.ajax({
                        url: "/admin/posts/add",
                        type: "post",
                        data: {id:id,title:title},
                        success: function (data) {
                            if (data["status"] == true) {
                                $('.posts_id').val(data['data']);
                            }
                        }
                    });
                }else{
                    return false;
                }

            });
        </script>

        <script>
            $('#form-post,#form-post input').keydown(function(e) {
                if (e.keyCode == 13) {
                    e.preventDefault();
                    return false;
                }
            });

       $('#form-post').on('submit', function(e){
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                })
            $('#form-post #loading').show();
			var formData = new FormData(this);
                $.ajax({
                    url: "/admin/posts/add_post",
                    type: "post",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        $('#form-post #loading').hide();
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                            $("#modal_post").modal("hide");
                            var url = $(location).attr("href");

                            var url = $(this).attr('href');
                            getData(url);
                        } else {
                            if(data['data_validator']!=null){
                                   var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                swal({
                                    title: "",
                                    text: data["data"],
                                    type: "error",
                                    html:dt,
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "{{__('text.ok')}}",
                                    cancelButtonText: "{{__('text.cancel')}}",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });



                        }else{

                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "{{__('text.ok')}}",
                                cancelButtonText: "{{__('text.cancel')}}",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });


                        }

                        }
                    }
                });

    });
</script>
<script>

    $(document).on('click', '.updateDetails',function(e){
        id = $(this).data('id');
            $.ajax({
                url: "/admin/posts/edit",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
                        $('.modal-title').html('تعديل الخبر');

                        $('.form-post .title').val(data['data']['title']);
                        $('.form-post .summary').val(data['data']['summary']);
                        $('.num_char').text(data['data']['summary'].length);
                        CKEDITOR.instances['details'].setData(data['data']['details']);
                        $('.date_published').val(data['data']['date_published']);
                        $('.form-post .img_review img').attr('src','/uploads/'+data['data']['main_image']);
                        $('.writers').val(data['data']['writers']);
                        if(data['data']['SlideNews'] == 1){
                            $('#SlideNews').bootstrapSwitch('state', true, true);
                        }else{
                            $('#SlideNews').bootstrapSwitch('state', false, true);
                        }
                        if(data['data']['importantNews'] == 1){
                            $('#importantNews').bootstrapSwitch('state', true, true);
                        }else{
                            $('#importantNews').bootstrapSwitch('state', false, true);
                        }
                        $('.eshari').val(data['data']['eshari']);
                        $('.form-post .file').val(data['data']['file']);
                        $('.form-post .category').val(data['data']['category']);
                        $('.form-post .lang').val(data['data']['lang']);
                        $('.form-post .date').datepicker("setDate", data['data']['date']);
                        $('.form-post .NewsType').val(data['data']['NewsType']);
                        $('.form-post .status').val(data['data']['status']);
                        $('.form-post .desc-photo').val(data['data']['description_image']);
                        $('.hidden').val(data['data']['id']);
                        $('.posts_id').val(data['data']['id']);

                        $('.form-post .socil_images_title').val(data['data']['socil_images_title']);
                        $('.form-post .summarysocil_images').val(data['data']['summarysocil_images']);
                        $('.form-post .img_review_social img').attr('src','/uploads/'+data['data']['socil_images']);
                        $('.form-post #socil_images').val(data['data']['socil_images']);
                        

                        var pictureStr = '<div style="text-align:center" class="row">';
                        const images = data['data']['images'];
                        for (let i = 0; i < images.length; i++) {
                            const image = images[i];
                            pictureStr += '<div class="removable">';
                            pictureStr += createRemoveButton('update',image['id'])+createFancyBoxImageWithTitle(image['image'],image['title']);
                            pictureStr += '</div>';
                        }
                        pictureStr += '</div>';
                        $('#additionalImagesPreview').html(pictureStr);
                        $('.tag_select_dropdown').html(data['tags']);
                        $('.tag_search_dropdown').html('');
                        $('.search_tag').val('');
                        $('.tag_search_dropdown').css('display','none');
					}else{
                        swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                    }
                },
                complete: function () {
                    $('#modal_post').modal('show');
                }
            });

    });

    $(document).on('click','.delete',function(e){
		var id = $(this).data('id');
		Swal.fire({
				title: 'هل تريد حذف هذا العنصر ؟',
				text: "",
				type: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				confirmButtonText: 'حسنا',
				cancelButtonText: "الغاء",
			}).then((result) => {
				if (result.value) {
				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
				$.ajax({
                url: "/admin/posts/delete",
                type: "post",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
						Swal.fire(
                        data["data"],
						'',
						'success'
						)
						var url = $(this).attr('href');
                        var url = $(location).attr("href");

						getData(url);
						window.history.pushState("", "", url);
					}else{
						swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
					}
                },
            });
				}
			})
	});
</script>

<!-- /******************************* */ -->
<script>

    $(".btnAddAdditionalImage").on('click',function(e){
        e.preventDefault();

        const imageInput = $("#modal_post .additional_images");
        const titleInput = $("#modal_post .additional_images_title");
        const title = titleInput.val();
        if(!(title && imageInput.val())) return;
        const additionalImagePreviewCount= $('.additionalImageAdd').length+1;
        // var element = '<img width="200" class="img-fluid img-thumbnail" id="additionalImagePreview'+additionalImagePreviewCount+'" src="">';
        // element += '<p style="text-align:center">'+title+'</p>';
        var element = createFancyBoxImageWithTitle("",title,'additionalImagePreview'+additionalImagePreviewCount,['additionalImageAdd']);
        const imageInputClone  = imageInput.clone();
        const titleInputClone  = titleInput.clone();
        imageInputClone.css('display','none');
        imageInputClone.attr('name','additional_image[]');
        imageInputClone.removeClass('additional_images');
        titleInputClone.css('display','none');
        titleInputClone.attr('name','additional_image_title[]');
        titleInputClone.removeClass('additional_images_title');
        var removable = '<div class="removable">';
        removable += createRemoveButton('')+element;
        removable+= "</div>"
        $("#newAdditionalImagesPreview").append(removable);
        $("#newAdditionalImagesPreview .removable").last().append(imageInputClone);
        $("#newAdditionalImagesPreview .removable").last().append(titleInputClone);

        readADDURL(imageInput[0],"#additionalImagePreview"+additionalImagePreviewCount);
        imageInput.val('');
        titleInput.val('');
        $("#modal_post .additional_images").val('');
        $("#modal_post .additional_images_title").val('');
        $('.additoin_label').html('اختر الصورة الإضافية');
        return false;
    });

    $('body').on("click",".btn-remove",function(e){
            Swal.fire({
                title: "هل تريد حذف العنصر ؟",
                text: "",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "نعم",
                cancelButtonText: "لا"
            }).then(result => {
                if (result.value) {
                    e.preventDefault();
                    console.log("any");
                    if($(this).attr('data-action')=='update'){
                        const dataId = $(this).attr('data-id');
                        $(this).parent().replaceWith('<input type="hidden" name="remove_additional_image[]" value="'+dataId+'"/>');
                    }
                    else{
                        $(this).parent().remove();
                    }
                }
            });
        });



        function createFancyBoxImage(path,imageId='',imageClasses=[]){
        const classes = imageClasses.join(' ');
        return '<a style="width:120px;margin:5px;"  data-fancybox="gallery" href ="/uploads/'+path+'"  ><img id="'+imageId+'" width="200px" class="img-thumbnail detailsImageClick '+classes+'" src="/uploads/'+path+'" /></a>'
        }

        function createFancyBoxImageWithTitle(path,title,imageId='',imageClasses=[]){
            return createFancyBoxImage(path,imageId,imageClasses)+'<p style="text-align:center">'+title+'</p>'
        }

        function createRemoveButton(dataAction,dataId=0){
            return '<span style="font-family: monospace" class="badge badge-danger btn-remove" data-id="'+dataId+'" data-action="'+dataAction+'">&times;</span>'
        }


        $('body').on('mouseenter','.removable',function(){
            $(this).find('.btn-remove').css('display','initial');
        });

        $('body').on('mouseleave','.removable',function(){
            $(this).find('.btn-remove').css('display','none');
        });

</script>

    <!-- /******************************* */ -->

<script>

$('#search_tag').keydown(function(event){

    if(event.keyCode == 13){

        const id = $('.tag_search_dropdown li.selected').attr('data-id');
        $('.tag_search_dropdown').css('display','none');

        var post_id =$('#posts_id').val();
        const tag_id =$('#tags_id').val();
        var search_tag =$('#search_tag').val();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        })

        if(id){
            $('.search_tag').val($('.tag_search_dropdown li.selected').text());
            AddTag(id);
        }else{
            add_tag(tag_id,post_id,search_tag);
        }
    }
});

function add_tag(tag_id,post_id,search_tag){
    $.ajax({
        url: "/admin/posts/add_tag",
        type: "post",
        dataType: "JSON",
        data: {
            tag_id:tag_id,
            post_id:post_id,
            search_tag:search_tag,
            },success: function(data){
					if(data['status'] == true){
                        $('.tag_select_dropdown').append(data.tag);
                        $('#search_tag').val('');
					}else{
                        if(data['data_validator']!=null){
                                   var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                swal({
                                    title: "",
                                    text: data["data"],
                                    type: "error",
                                    html:dt,
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "{{__('text.ok')}}",
                                    cancelButtonText: "{{__('text.cancel')}}",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                        }else{

                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "{{__('text.ok')}}",
                                cancelButtonText: "{{__('text.cancel')}}",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                        }

                            }
                },
})
}

$(document).on('click','.add_tag',function(e){

    var post_id =$('#posts_id').val();
        const tag_id =$('#tags_id').val();
        var search_tag =$('#search_tag').val();
        $.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
 					         }

                   })
                   $.ajax({
        url: "/admin/posts/add_tag",
        type: "post",
        dataType: "JSON",
        data: {
            post_id:post_id,
            tag_id:tag_id,
            search_tag:search_tag,
            },success: function(data){
					if(data['status'] == true){

                        // swal({
                        //         title: "",
                        //         text: data["data"],
                        //         type: "success",
                        //         showCancelButton: false,
                        //         confirmButtonColor: "#DD6B55",
                        //         confirmButtonText: "حسنا",
                        //         cancelButtonText: "الغاء",
                        //         closeOnConfirm: true,
                        //         closeOnCancel: true
                        //     });
                        $('.tag_select_dropdown').append(data.tag);
                        $('#search_tag').val('');

					}else{

                        if(data['data_validator']!=null){
                                   var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                swal({
                                    title: "",
                                    text: data["data"],
                                    type: "error",
                                    html:dt,
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "{{__('text.ok')}}",
                                    cancelButtonText: "{{__('text.cancel')}}",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                        }else{

                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "{{__('text.ok')}}",
                                cancelButtonText: "{{__('text.cancel')}}",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                        }

                            }
                },
})

})


<!-- /******************************* */ -->

    $('.search_tag').on('input',function (e) {

        e.preventDefault();
        if(e.keyCode == 13) {
            return false;
        }
            const value = $(this).val();
            $('#form-post .tag_id').val('');

            if(value.length==0){
                $('.tag_search_dropdown').html('');
                $('.tag_search_dropdown').css('display','none');
            }
            else{

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "post",
                    url: "/admin/posts/search",
                    data: {
                        value:value
                    },

                    success: function (response) {

                        $('.tag_search_dropdown').html(response);
                        $('.tag_search_dropdown').css('display','block');

                    }
                });
        }
    });



    

    $(document).on('click','.tag_search_dropdown li',function(){
		var post_id =$('#posts_id').val();
        const id = $(this).attr('data-id');
        $('.tag_search_dropdown').css('display','none');
        $('#form-post #loading').show();
        $('.search_tag').val($(this).text());
        AddTag(id);
    });

    function AddTag(id){
        $.ajax({
            type: "get",
            url: "/admin/posts/tag_select",
            data:{
                id:id,
                },
            success: function (data) {
                $('#tags_id').val(data.data.id);
                $('#search_tag').val(data.data.name);
                $('.search_result_order').html('');
                gitfocus();
            },
            complete:function(){
                $('#form-post #loading').hide();

            }
        });
    }


    $(document).on('click','.delet_tag_select',function(e){
        const id = $(this).attr('data-id');
        const classname = $(this).attr('data-name');
        $(this).parent().remove();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: "/admin/posts/delete_news_tag",
            type: "post",
            dataType: "JSON",
            data: {
                id:id,
            },
            success: function(data){
                if(data['status'] == true){
                    
                }else{
                    swal({
                        title: "",
                        text: data["data"],
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "{{__('text.ok')}}",
                        cancelButtonText: "{{__('text.cancel')}}",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                }
            },
        })
    });

    function gitfocus(){
        document.getElementById("search_tag").focus();
    }

//delete_news_tag


</script>
<script>
    $('.social_modal_center').on('click',function(e){
    $('#modal_center').modal('show');
    $('#modal_center').addClass('social_center');
  });

</script>

<script>
    

    $(document).on('click', '.copyLinkPost', function () {
        $('.copyLinkPost').removeClass('btn-success');
        $('.copyLinkPost').addClass('btn-info');
          thisTag = $(this);
          var $temp = $("<input>");
          $("body").append($temp);
          $temp.val($(this).data('link')).select();
          document.execCommand("copy");
          $temp.remove();
          thisTag.removeClass('btn-info');
          thisTag.addClass('btn-success');
      });
    </script>
    <script>
        var liSelected;
        var search_tag = $('#search_tag');
        var search_result_order = $('.search_result_order');
        search_tag.keyup(function (event) {
            if (event.keyCode == 40) {
                if(liSelected){
                    liSelected.removeClass('selected');
                    next = liSelected.next();
                    if(next.length > 0){
                        liSelected = next.addClass('selected');
                    }else{
                        liSelected = $('.search_result_order li').eq(0).addClass('selected');
                    }
                }else{
                    liSelected = $('.search_result_order li').last().addClass('selected');
                }
            }

            if(event.keyCode == 38){
                if(liSelected){
                    liSelected.removeClass('selected');
                    next = liSelected.prev();
                    if(next.length > 0){
                        liSelected = next.addClass('selected');
                    }else{
                        liSelected = $('.search_result_order li').eq(0).addClass('selected');
                    }
                }else{
                    liSelected = $('.search_result_order li').first().addClass('selected');
                }
            }
           
        });

        search_result_order.on('mouseenter', 'li', function(){
            $(this).addClass('selected');
        }).on('mouseleave', 'li', function(){
            $(this).removeClass('selected');
        });

        
     
    </script>
  
@stop
