@extends('admin.layout.master_layout')
@section('title')
   {{__('text.control_panel')}}
@stop
@section('css')
    <style>
        #loading{
            display:none;
        }
        .modal{
            overflow-y: auto;
        }

        @media (min-width: 992px){
            .modal-lg {
                max-width: 1300px;
            }
        }

        .form-control{
            padding: 0.5rem 1.15rem !important; 
        }
        .main_label ,.additoin_label{
            overflow: hidden;
        }

        .removable{
        position: relative;
        display: inline-block ;
        }
        .removable .btn-remove {
            position: absolute;
            top: 2px;
            left: 2px;
            z-index: 100;
            border-radius: 50%;
            cursor: pointer;
            display: none;
        }
    </style>
@endsection

@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/admin/tags" class="m-nav__link">
                            <span class="m-nav__link-text">الوسوم</span>
                        </a>
                    </li>
                </ul>

                <div class="m-demo__preview  m-demo__preview--btn">
                    @can('add_tags')
                    <button type="button"   class="btn btn-danger m-btn m-btn--custom btn_add_tags" ><i class="fa fa-plus"></i> إضافة وسم</button>
                    @endcan
                </div>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">

            <div class="filter row mb-4 mt-2">
                <div class="col-md-3">
                    <input type="text" name="user_name_seach"  class="form-control user_name_seach" placeholder="اسم المستخدم">
                </div>  
            </div>

            <div class="">

                <div id="table-container">

                    @include('admin.tags.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>


@include('admin.tags.sub.add')
@stop




@section('js')

<script>

    $('.user_name_seach').on('input',function(e){
        name =  $('.user_name_seach').val();
        if(name.length >= 3 || name == ''){
            var url = $(this).attr('href');
            getData(url);
        }
    });

      $('#status').bootstrapSwitch('state', true, true);

      $(document).on('click', '.pagination a',function(event)
        {
            event.preventDefault();
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
            var url = $(this).attr('href');
            getData(url);
        });
        
      function getData(url) {
        $('#load').show();
        $.ajax({
            url : url,
            data:{name:name},
        }).done(function (data) {
            $("#table-container").empty().html(data);
            $('#load').hide();
        });
    }

function clearTags(){
    $('#hidden').val('0');
    $('#name').val('');
    $('#status').val('');
    $('#status').bootstrapSwitch('state', true, true);


}

</script>

<script>
    $('.btn_add_tags').on('click',function(e){
         clearTags();
        $('#modal_tag').modal('show');
        $('#exampleModalCenterTitle').html('إضافة وسم');
    });

    $('body').on('click','.UpdateStats',function(){
            $(this).addClass('disabled');
            $('.loadImg').removeClass('hidden');
            $('.loadMSG').html('جاري تحديث الحالة');
            var thisTag = $(this);
            var id = $(this).data('id');
			$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
            	url: "/admin/tags/UpdateStats",
                type: "POST",
                dataType: "JSON",
                data:{id:id},
                success: function(data) {
                    if(data["status"] == true){
						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
						getData(url);
                    }else{
                        swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                    }
                }
            });
            $(thisTag).removeClass('disabled');
            $('.loadImg').addClass('hidden');
        });
</script>


<script>
       $('#form-tag').on('submit', function(e){
        var hidden =$('#hidden').val();
        e.preventDefault();
        var formData = new FormData(this);;
         $.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});

if(hidden == 0){

    $.ajax({
                    url: "/admin/tags/add_tag",
                    type: "post",
                    cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data)
                     {
                       $('#form-tag #loading').hide();
                       if (data["status"] == true) {
                        swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                            $("#modal_tag").modal("hide");
                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                            var pathname = $(location).attr("pathname");
                            var page = $('.pagination .active span').text();
                            url = origin+pathname+'?page='+page;
                            getData(url); 
                            
                       }else{

                        if(data['data_validator']!=null){
                                   var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                swal({
                                    title: "",
                                    text: data["data"],
                                    type: "error",
                                    html:dt,
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "{{__('text.ok')}}",
                                    cancelButtonText: "{{__('text.cancel')}}",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });



                        }else{

                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "{{__('text.ok')}}",
                                cancelButtonText: "{{__('text.cancel')}}",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                        }
                       }                         
                        }                       
                })

}else{
// **************************update
    $.ajax({
                    url: "/admin/tags/update",
                    type: "post",
                    cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data)
                     {
                       $('#form-tag #loading').hide();
                       if (data["status"] == true) {
                        swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                            $("#modal_tag").modal("hide");
                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
                            getData(url); 
                            
                       }else{

                        if(data['data_validator']!=null){
                                   var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                swal({
                                    title: "",
                                    text: data["data"],
                                    type: "error",
                                    html:dt,
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "{{__('text.ok')}}",
                                    cancelButtonText: "{{__('text.cancel')}}",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                        }else{

                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "{{__('text.ok')}}",
                                cancelButtonText: "{{__('text.cancel')}}",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                        }
                       }                         
                        }                       
                })
}
       
       })        


       $(document).on('click','.delete',function(e){
		var id = $(this).data('id');
		Swal.fire({
				title: 'هل تريد حذف هذا العنصر ؟',
				text: "",
				type: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				confirmButtonText: 'حسنا',
				cancelButtonText: "الغاء",
			}).then((result) => {
				if (result.value) {
				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
				$.ajax({
                url: "/admin/tags/delete",
                type: "post",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
						Swal.fire(
                        data["data"],
						'',
						'success'
						)
						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
						getData(url);
						window.history.pushState("", "", url); 
					}else{
						swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
					}
                },
            });
				}
			})
	});
       


    $(document).on('click', '.updateDetails',function(e){
        
        id = $(this).data('id');

            $.ajax({
                url: "/admin/tags/edit",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
                        
                        
                        $('#hidden').val('1');
                        $('#tags_id').val(data['data']['id']);
                        $('#name').val(data['data']['name']);

                        if(data['data']['status'] == 1){
                            $('#status').bootstrapSwitch('state', true, true);
                        }else{
                            $('#status').bootstrapSwitch('state', false, true);
                        }
   
                    }else{
                        swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                    }


                },
                complete: function () {
                    $('#exampleModalCenterTitle').html('تعديل وسم ');
                    $('#modal_tag').modal('show');
                   
                }
            })
        })

</script>

@endsection