@extends('admin.layout.master_layout')
@section('title')
   لوحة التحكم
@stop

@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/admin/users" class="m-nav__link">
                            <span class="m-nav__link-text">المستخدمين</span>
                        </a>
                    </li>
                </ul>

                <div class="m-demo__preview  m-demo__preview--btn">
                    @can('add_users')
                        <button type="button"  data-toggle="modal" data-target="#add_page" class="btn btn-danger m-btn m-btn--custom btnAddCustomer" style="line-height: 15px;"><i class="fa fa-plus"></i> إضافة مستخدم</button>
                    @endcan  
                </div>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">

            <div class="filter row mb-4 mt-2">
               
                    <div class="col-md-3">
                        <input type="text" name="user_name_seach"  class="form-control user_name_seach" placeholder="اسم المستخدم">
                </div>
        
                
            </div>


            <div class="">

                <div id="table-container">

                    @include('admin.users.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>


@include('admin.users.sub.add')

@stop


@section('js')
<script type="text/javascript">
$(document).ready(function(e){
    getpermission();
});

$(document).on('click','.permission',function(e){
    var id = $(this).data('id');
    $('.user_id').val(id);
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
    });
    $.ajax({
        url: "/admin/users/userpermission",
        type: "post",
        dataType: "JSON",
        data:{id:id},
        success: function(data) {
            $('#permission-body').html(data['data']);
        },
        complete:function(data){
            $('#permission_users').modal('show');
        }
    });

})
/****************************************************************************** */
function getpermission(){
    $.ajax({
        url: "/admin/users/getpermission",
        type: "get",
        dataType: "JSON",
        data:{},
        success: function(data) {
            if(data['status'] == true){
                console.log(1);
            }
        }
    });
}
/******************************************************************************************************* */
$('#activeValue').bootstrapSwitch('state', true, true);

function CKupdate(){
	for ( instance in CKEDITOR.instances )
		CKEDITOR.instances[instance].updateElement();
}
/************************************************************************************************************* */
$('.user_name_seach').on('input',function(e){
    name =  $('.user_name_seach').val();
    if(name.length >= 3 || name == ''){
        var url = $(this).attr('href');
        getData(url,name);
    }
});

/***********************************************************************************************************************/
        $('body').on('click','.UpdateStats',function(){
            $('#load').show();
            $(this).addClass('disabled');
            $('.loadImg').removeClass('hidden');
            $('.loadMSG').html('جاري تحديث الحالة');
            var thisTag = $(this);
            var id = $(this).data('id');
			$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
            	url: "/admin/users/UpdateStats",
                type: "POST",
                dataType: "JSON",
                data:{id:id},
                success: function(data) {
                    $('#load').hide();
                    if(data["status"] == true){
						var url = $(this).attr('href');
						getData(url);
                        var origin = $(location).attr("origin");
                        var pathname = $(location).attr("pathname");
                        var page = $('.pagination .active span').text();
                        url = origin+pathname+'?page='+page;
                    }else{
                        swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                    }
                }
            });
            $(thisTag).removeClass('disabled');
            $('.loadImg').addClass('hidden');
        });
</script>

<script>
$(document).on('click', '.pagination a',function(event)
        {
            event.preventDefault();
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
            var url = $(this).attr('href');
            getData(url);
        });
  
    function getData(url,name) {
        $('#load').show();
        $.ajax({
            url : url,
            data:{name:name}
        }).done(function (data) {
            $("#table-container").empty().html(data);
            $('#load').hide();
        });
    }
</script>
<script type="text/javascript">
    $(document).ready(function () {
        /*************************************************/
        $(document).on('click', '.btnAddCustomer', function () {
			$('#addNewpageForm').find(".status").val('');
			$('#addNewpageForm').find(".name").val('');
			$('#addNewpageForm').find(".email").val('');
            $('#addNewpageForm').find(".password").val('');
            $('#addNewpageForm').find(".mobile").val('');
            $('#addNewpageForm').find(".fullname").val('');
            $('#addNewpageForm').find('.rowIdUpdate').val(0);
            $('#add_page .modal-title').html('إضافة مستخدم جديد');
            $('#activeValue').bootstrapSwitch('state', true, true);

        });

        // 
        $(document).on('click', '.group_per', function () {
            var check = $(this).is(':checked');
            // var uncheck = $(this).is(':unchecked');
            var id = $(this).data('id');
            $('.' + id).each(function () {
                $(this).prop('checked', check);
            });
        });

        $(document).on('click','.password-modal',function(e){
            $('#changepassword #loading').show();
            id = $(this).data('id');
            $.ajax({
                url: "/admin/users/edit",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
                    $('#changepassword #loading').hide();
					if(data['status'] == true){
                        $('.password').val('');
						$(".confirm_password").val('');
                        $('.name').val(data['data']['username']);
                        $('.userIdUpdate').val(data['data']['id']);
                       
					}else{
                        swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                    }
                },
                complete: function () {
                    $('#changepassword').modal('show');
                }
            });
            
        });
        
        /*************************************************/
        $(document).on('click', '.updateDetails', function () {
            $('#addNewpageForm #loading').show();
			$('#addNewpageForm').find('.rowIdUpdate').val(0);
            var id = $(this).data('id');
            $('.rowIdUpdate').val(id);
            $.ajax({
                url: "/admin/users/edit",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
                    $('#addNewpageForm #loading').hide();
					if(data['status'] == true){
						$(".name").val(data['data']['username']);
                        $(".email").val(data['data']['email']);
                        $(".mobile").val(data['data']['mobile']);
                        $('#addNewpageForm').find(".fullname").val(data['data']['fullname']);
						if(data['data']['status'] == 1){
							$('#activeValue').bootstrapSwitch('state', true, true);
						}else{
							$('#activeValue').bootstrapSwitch('state', false, true);
						}
					}
                },
                complete: function () {
                    $('#add_page').modal('show');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    swal({title: 'حدث خطأ غير معروف، الرجاء المحاولة فيما بعد', type: "error"});
                }
            });

            $('#add_page .modal-title').html('تعديل بيانات');
            $('.btn_save_user').html('تعديل');

        });
        /*************************************************/
        $('.addNewpageForm').on('submit', function(e){
            $('#addNewpageForm #loading').show();
            e.preventDefault();
			var formData = new FormData(this);
            $('.loader_add_user').css('display', 'initial');
            setTimeout(function () {
                $('.btn_save_customer').removeClass('disabled');
                $('.loader_add_user').css('display', 'none');
            }, 30000);
            var id = $(".rowIdUpdate").val();
            if (id == 0) {
                $.ajax({
                    url: "/admin/users/add",
                    type: "post",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        $('#addNewpageForm #loading').hide();
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                        var pathname = $(location).attr("pathname");
                        var page = $('.pagination .active span').text();
                        url = origin+pathname+'?page='+page;
                            getData(url);
                            $('#addNewpageForm').find(".status").val('');
                            $('#addNewpageForm').find(".name").val('');
                            $('#addNewpageForm').find(".email").val('');
                            $('#addNewpageForm').find(".mobile").val('');
                            $('#addNewpageForm').find(".password").val('');
                            $('#addNewpageForm').find(".fullname").val('');
                            $("#add_page").modal("hide");
                        } else {

                            if(data["data_validator"]){
                                var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                    swal({
                                        title: data["data"],
                                        text: data["data"],
                                        type: "error",
                                        html:dt,
                                        showCancelButton: false,
                                        confirmButtonColor: "#DD6B55",
                                        confirmButtonText: "حسناً",
                                        cancelButtonText: "إلغاء",
                                        closeOnConfirm: true,
                                        closeOnCancel: true
                                    });
                            }else{

                                swal({
                                    title: "",
                                    text: data["data"],
                                    type: "error",
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "حسنا",
                                    cancelButtonText: "الغاء",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                            }
                            
                        }
                    }
                });
            } else {
				$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
                $.ajax({
                    url: "/admin/users/update",
                    type: "POST",
                    dataType: "JSON",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        $('#addNewpageForm #loading').hide();
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
							var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                        var pathname = $(location).attr("pathname");
                        var page = $('.pagination .active span').text();
                        url = origin+pathname+'?page='+page;
                            getData(url);
                            $('#addNewpageForm').find(".status").val('');
                            $('#addNewpageForm').find(".name").val('');
                            $('#addNewpageForm').find(".email").val('');
                            $('#addNewpageForm').find(".password").val('');
                            $('#addNewpageForm').find(".fullname").val('');
							$('#addNewpageForm').find('.rowIdUpdate').val(0);
                            $("#add_page").modal("hide");
                        } else {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                        }
                    }
                });
            }
//	}
        });
        /****************************************************/
    });
/**************************************************************************************************************************/
	$(document).on('click','.delete',function(e){
		var id = $(this).data('id');
		Swal.fire({
				title: 'هل تريد حذف هذا العنصر ؟',
				text: "",
				type: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				confirmButtonText: 'حسنا',
				cancelButtonText: "الغاء",
			}).then((result) => {
				if (result.value) {
				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
				$.ajax({
                url: "/admin/users/delete",
                type: "post",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
						Swal.fire(
						'تم الحذف بنجاح',
						'',
						'success'
						)
						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                        var pathname = $(location).attr("pathname");
                        var page = $('.pagination .active span').text();
                        url = origin+pathname+'?page='+page;
						getData(url);
						window.history.pushState("", "", url); 
					}else{
						swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
					}
                },
            });
				}
			})
	});
    /*************************************************************************************************************************/

    $('#changepasswordform').on('submit', function(e){
            e.preventDefault();
            $('#changepasswordform #loading').show();
			var formData = new FormData(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
                $.ajax({
                    url: "/admin/users/changepassword",
                    type: "post",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        $('#changepasswordform #loading').hide();
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                        var pathname = $(location).attr("pathname");
                        var page = $('.pagination .active span').text();
                        url = origin+pathname+'?page='+page;
                            getData(url);
                            $('#changepasswordform').find(".password").val('');
                            $('#changepasswordform').find(".confirm_password").val('');
                            $('#changepasswordform').find(".userIdUpdate").val('');
                            $("#changepassword").modal("hide");
                        } else {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                        }
                    }
                });
            
    });

    $('#permission_users_form').on('submit', function(e){
            e.preventDefault();
            $('#permission_users_form #loading').show();
			var formData = new FormData(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
                $.ajax({
                    url: "/admin/users/permission",
                    type: "post",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        $('#permission_users_form #loading').hide();
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                            $('#permission_users').modal('hide');
                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                        var pathname = $(location).attr("pathname");
                        var page = $('.pagination .active span').text();
                        url = origin+pathname+'?page='+page;
                            getData(url);
                            $('#permission_users_form').find(".permissions").val('');
                            $("#changepassword").modal("hide");
                        } else {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                        }
                    }
                });
            
    });
</script>
@stop