

@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/checkout/{{$data['courses']->id }} @stop
@section('title') {{$data['courses']->title}}@stop
@section('image'){{URL::to('/')}}/img/750x500/{{$data['courses']->image}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['courses']->details)}} @stop

@section('css')
<style>
.shop_table {
    text-align: right;
}

</style>
@endsection
@section('content')
<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title"> التسجيل و الدفع</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>


<div class="site-main">

    <section class="ttm-row checkout-section clearfix">
        <div class="container">
            <!-- row -->
            <div class="row">
                <div class="col-lg-12">
                    
                    {{-- <form name="checkout" method="post" class="checkout row" action="#"> --}}
                    <form class="form checkout row"  id="form" action="https://api.moyasar.com/v1/payments.html" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="payment_method" id="payment_method">
                        <input type="hidden" name="source[type]" id="type_donate" value="creditcard" >
                        <input type="hidden" name="callback_url" value="{{URL::to('/')}}/complete_payment">
                        @php
                            $amount=$data['courses']->price*100;
                        @endphp
                        <input type="hidden" name="amount" class="amount" value="{{$amount}}">
                        <input type="hidden" name="amount_no" class="amount_no" value="{{$data['courses']->price}}">
                        <input type="hidden" name="publishable_api_key" value="{{$setting->moyasar_key}}">
                        <input type="hidden" name="currency" value="SAR">
                        <input type="hidden" name="order_id" id="order_id" value="{{$data['courses']->id}}">
                        <input type="hidden" name="description" class="form-control sdescription" id="sdescription" value="">

                        <div class="col-lg-12">
                            <div class="billing-fields row">
                                <h3 class="col-lg-12"> تفاصيل الدفع  </h3>
                                <div class="col-lg-4">
                                    <p class="form-row">
                                        <label>  الاسم المدون على البطاقة &nbsp;<abbr class="required" title="required">*</abbr></label>
                                        <input type="text" id="sname" class="input-tex sname" name="source[name]" placeholder="" value="">
                                    </p>
                                </div>
                                <div class="col-lg-4">
                                    <p class="form-row">
                                        <label> رقم البطاقة &nbsp;<abbr class="required" title="required">*</abbr></label>
                                        <input type="text" id="snumber" class="input-text snumber" name="source[number]" placeholder="" value="">
                                    </p>
                                </div>
                                <div class="col-lg-4">
                                    <p class="form-row">
                                        <label> الشهر &nbsp;<abbr class="required" title="required">*</abbr></label>
                                        <input type="number" id="smonth" class="input-text smonth" name="source[month]" placeholder="" value="">
                                    </p>
                                </div>

                                <div class="col-lg-4">
                                    <p class="form-row">
                                        <label> السنة &nbsp;<abbr class="required" title="required">*</abbr></label>
                                        <input type="number" id="syear" class="input-text syear" name="source[year]" placeholder="" value="">
                                    </p>
                                </div>
                                <div class="col-lg-4">
                                    <p class="form-row">
                                        <label> CVC &nbsp;<abbr class="required" title="required">*</abbr></label>
                                        <input type="text" id="scvc" class="input-text scvc" name="source[cvc]" placeholder="" value="">
                                    </p>
                                </div>


                            </div>
                        </div>
                        <div class="col-lg-12">
                            <h3 id="order_review_heading"> تفاصيل الدفع </h3>
                            <div id="order_review" class="checkout-review-order">
                                <table class="shop_table checkout-review-order-table">
                                    <thead>
                                        <tr>
                                            <th class="product-name"> الصنف </th>
                                            <th class="product-total">المبلغ </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="cart_item">
                                            <td class="product-name"> {{$data['courses']->title}}
                                                
                                            </td>
                                            <td class="product-total">
                                                <span class="Price-amount">
                                                     {{$data['courses']->price}}  ر.س 
                                                </span>
                                            </td>
                                        </tr>
                                    </tbody>
                                    <tfoot>

                                        <tr class="order-total">
                                            <th> الإجمالي </th>
                                            <td><strong><span class="woocommerce-Price-amount amount"> {{$data['courses']->price}}  ر.س   </span></strong> </td>
                                        </tr>
                                    </tfoot>
                                </table>
                                <div id="payment" class="checkout-payment">
                                    {{-- <ul class="payment_methods">
                                        <li class="payment_method_ppec_paypal">
                                            <div class="payment_box">
                                                <p>Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our privacy policy.</p>
                                            </div>
                                        </li>
                                    </ul> --}}
                                    <div class="form-row place-order">
                                        {{-- <p>Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our <a href="" class="privacy-policy-link" target="_blank">privacy policy</a>.</p> --}}
                                        <button id="MyBtn"
                                        class="button submit ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-fill ttm-btn-color-dark" 
                                        > تسجيل و دفع </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

</div>






  
</div><!--site-main end-->
@endsection
@section('js')


<script>
    $(document).ready(function () {

        $(document).on('click','#MyBtn', function (e) {

            e.preventDefault();
                var month = $('#form #smonth').val();
                var sname = $('#form #sname').val();
                var snumber = $('#form #snumber').val();
                var yaer = $('#form #syear').val();
                var mobile = $('#form #mobile').val();
                var cvc = $('#form #scvc').val();
                var price = $('#form .amount_no').val();
                var amount_no =price *100;


                var payment_method = $('#form #payment_method').val();
                var type_donate = $('#form #type_donate').val();
                var user_id =0;
                var order_id = $('#form #order_id').val();
                if(type_donate == 'creditcard'){

                // if(type_donate.length == ''){
                //   Swal.fire({
                //     title: "",
                //     text: "Payment method is required",
                //     type: "error",
                //     showCancelButton: false,
                //     confirmButtonColor: "#ff5722",
                //     confirmButtonText: "OK",
                //     cancelButtonText: "Cancel",
                //     closeOnConfirm: true,
                //     closeOnCancel: true
                // });
                //   return false;
                // }
                // if(payment_method == ''){
                //      toastr["error"]('طريقة الدفع مطلوبة')
                //      return false;
                // }

                if(sname == ''){
                Swal.fire({
                    title: "",
                    text: "الاسم المدون على البطاقة مطلوب",
                    type: "error",
                    showCancelButton: false,
                    confirmButtonColor: "#ff5722",
                    confirmButtonText: "OK",
                    cancelButtonText: "Cancel",
                    closeOnConfirm: true,
                    closeOnCancel: true
                });
                  return false;
                }
                if(snumber == ''){
                Swal.fire({
                    title: "",
                    text: " رقم البطاقة مطلوب ",
                    type: "error",
                    showCancelButton: false,
                    confirmButtonColor: "#ff5722",
                    confirmButtonText: "OK",
                    cancelButtonText: "Cancel",
                    closeOnConfirm: true,
                    closeOnCancel: true
                });
                  return false;
                }
                if(month.length != 2){

                    Swal.fire({
                        title: "",
                        text: "الشهر يجب ان يكون عبارة عن رقمين ",
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#ff5722",
                        confirmButtonText: "OK",
                        cancelButtonText: "Cancel",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });

                  return false;

                }

                if(yaer.length != 4){

                    Swal.fire({
                        title: "",
                        text: "السنة يجب ان تكون 4 ارقام ",
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#ff5722",
                        confirmButtonText: "OK",
                        cancelButtonText: "Cancel",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                  return false;

                }

                if(cvc.length > 4 & cvc.length < 3){
                    Swal.fire({
                        title: "",
                        text: "رقم CVC  يجب ان يكون 3 أو 4 أرقام ",
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#ff5722",
                        confirmButtonText: "OK",
                        cancelButtonText: "Cancel",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                  return false;

                }
             }

              var form_data = $("#form").serialize();
              $.ajax({
              url: "https://api.moyasar.com/v1/payments",
              type: "POST",
              data: form_data,
              dataType: "json",
            })


            .done(function(data) {
                    var user_id =user_id;
                    var price = amount_no;
                    var type = 1;
                    var status = 3;  // تم التحويل
                    var date = '';
                    var file = '';
                    var name = sname;
                    var id_country ='';
                    var bank_id = '';
                    var number_ref = data.id;
                    var url = data.source.transaction_url;
                    storePayment(user_id,price,type,status,date,file,name,bank_id,order_id,id_country,payment_method,url,number_ref);

            })

            .error(function(data) {

                Swal.fire({
                    title: "",
                    text: data.responseJSON.message,
                    type: "error",
                    showCancelButton: false,
                    confirmButtonColor: "#ff5722",
                    confirmButtonText: "OK",
                    cancelButtonText: "Cancel",
                    closeOnConfirm: true,
                    closeOnCancel: true
                });




            })

            });

    });

</script>
<script>
     function storePayment(user_id,price,type,status,date,file,name,bank_id,order_id,id_country,payment_method,url,number_ref){
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({

        	url: "{{URL::to('/')}}/donation",

            type: "POST",

            dataType: "JSON",

            data:{user_id:user_id,price:price,type:type,status:status,date:date,file:file,name:name,bank_id:bank_id,order_id:order_id,id_country:id_country,payment_method:payment_method,number_ref:number_ref},

            success: function(data) {

                $('#load').hide();

                if(data["status"] == true){

                  Swal.fire({
                      title: "",
                      html:data.data,
                      type: "success",
                      showCancelButton: false,
                      confirmButtonColor: "#DD6B55",
                      confirmButtonText: '{{__('lang.ok')}}',
                      cancelButtonText: '{{__('lang.cancel')}}',
                      closeOnConfirm: true,
                      closeOnCancel: true
                  });
                  $('#form').find(".name").val('');
                  $('#form').find(".mobile").val('');
                  $('#form').find(".date").val('');
                  $('#form').find(".price").val('');
                  $('#form').find(".file").val('');
                  $('#form').find(".bank").val('');
                  $('#donation .modal-body').find(".v1").val('');
                  $('#donation .modal-body').find(".v2").val('');
                  $('#donation .modal-body').find(".v3").val('');
                  $('#form').find(".month").val('');
                  $('#form').find("#sname").val('');
                  $('#form').find("#syear").val('');
                  $('#form').find("#mobile").val('');
                  $('#form').find(".cvc").val('');
                  $('#form').find(".amount_no").val('');
                  $('#form').find(".order_id").val('');
                  $('#form').find(".quantity").val('');
                //   $('#donation').modal('hide');

                   window.location.href=url;



                }

            }

        });
    }
</script>
@endsection
