@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/{{App::getLocale()}}/contact_us @stop
@section('title'){{$data['static']->title}} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['static']->details,3)}} @stop

@section('css')
<style>
    .contact-pg-section .contact-form1 {
        margin-top: 0px;
    }
    .contact-pg-section .contact-form1 .submit-btn button {
        width: 33%;
    }
    </style>
@endsection
@section('content')
<section class="page-title">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <h2>{{$data['static']->title}}</h2>
                <ol class="breadcrumb">
                    <li class="">{{$data['static']->title}}</li>
                    <li class="float-right"><a href="{{URL::to('/')}}/{{App::getLocale()}}}">{{ __('app.home') }}</a></li>
                </ol>
            </div>
        </div> 
    </div> 
</section>   
<section class="contact-pg-section section-padding">
    <div class="container">
        <div class="row">
            <div class="col col-xs-2">
            </div>
            <div class="col col-md-8">
                <div class="section-title-s4">
                    <h2> {{$data['static']->title}} </h2>
                    <p>{!! $data['static']->details !!}</p>
                </div>                        
            </div>
        </div>
        <div class="row">
            <div class="col col-xs-2">
            </div>

            <div class="col col-xs-8">
                <form action="" method="post" class="contact-form1 row contact_us "  id="contact_us">
                    {{ csrf_field() }}
                    <div class="col col-sm-12">
                        <label for="">{{ __('app.fullname') }}</label>
                        <input type="text" class="form-control" id="name" name="name">
                    </div>
                    <div class="col col-sm-6">
                        <label for="">{{ __('app.email') }}</label>
                        <input type="email" class="form-control" id="email" name="email">
                    </div>
                    <div class="col col-sm-6">
                        <label for="">{{ __('app.phone') }}</label>
                        <input type="text" class="form-control" id="mobile" name="mobile">
                    </div>
                    <div class="col col-sm-12">
                        <label for="">{{ __('app.message') }}</label>
                        <textarea class="form-control" id="text" name="text"></textarea>
                    </div>
                    <div class="col col-sm-12 submit-btn">
                        <button type="submit" id="add_contact_us" class="theme-btn">{{ __('app.submit') }}</button>
                        {{-- <div id="loader">
                            <i class="fa fa-refresh fa-spin fa-3x fa-fw"></i>
                        </div> --}}
                    </div>
                    
                </form>
            </div>
        </div>
    </div> <!-- end container -->
</section>



@endsection
@section('js')
<script>
 $(document).on('submit', '#contact_us', function (e) {
                e.preventDefault();
                // 

                $('.preloader').css('display', '');
                $('.preloader').css('background-color','unset');

                
              
                var formData = new FormData(this);
                    $.ajax({
                        url: "{{URL::to('/')}}/{{App::getLocale()}}/contact_us",
                        type: "post",
                        cache:false,
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (data) {
                            $('#loading').hide();
                            if (data["status"] == true) {
                                Swal.fire({
                                    title: "",
                                    text: data.data,
                                    type: "success",
                                    timer: 2000,
                                });
                                $('#contact_us #name').val('');
                                $('#contact_us #email').val('');
                                $('#contact_us #mobile').val('');
                                $('#contact_us #text').val('');

                            } else {
                                if(data["data"]){
    
                                    Swal.fire({
                                    title: "",
                                    html: data.data,
                                    type: "error",
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: '{{__('lang.ok')}}',
                                    cancelButtonText: '{{__('lang.cancel')}}',
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
    
                                }else{
    
                                var errorMessage = "";
                                for (const error in data["data_validator"]) {
                                    if (data["data_validator"].hasOwnProperty(error)) {
                                        errorMessage += '<p>'+data["data_validator"][error]+'</p>';
                                    }
                                }
                                Swal.fire({
                                    title: "",
                                    html: errorMessage,
                                    type: "error",
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: '{{__('lang.ok')}}',
                                    cancelButtonText: '{{__('lang.cancel')}}',
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                                }
    
                            }
                            $('.preloader').css('display', 'none');
                            $('.preloader').css('background-color','#fff');
                        }
                    });
      
    });

</script>
@endsection