@extends('site.layout.layout')
@section('url'){{Request::fullUrl()}}@stop
@section('title'){{\App\Http\Helpers\Helpers::stringReplace($data['setting']->name,3)}}@stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['setting']->description,3)}}@stop

@section('css')
<style>

</style>

@endsection

@section('content')

<section class="ttm-row cta2-section bg-img8 clearfix" style="background-image: url({{URL::to('/')}}/uploads/{{ $data['slider']->photo }});">
    <div class="container">
        
        <div class="row align-items-center justify-content-center">

            <div class="col-lg-7">
                <div class="text-center ttm-textcolor-white res-991-pt-50 res-991-mt-15">
                    {{-- <div class="ttm-play-icon-btn mb-35">
                        <div class="ttm-play-icon-animation">
                            <a href="https://youtu.be/7e90gBu4pas" target="_self" class="ttm_prettyphoto">
                                <div class="ttm-icon ttm-icon_element-fill ttm-icon_element-color-skincolor ttm-icon_element-size-md ttm-icon_element-style-round">
                                    <i class="fa fa-play"></i>
                                </div>
                            </a>
                        </div>
                    </div> --}}
                    <!-- section title -->
                    <div class="section-title mb-10">
                        <div class="title-header pb-0">
                            <h2 class="title" style="color: #202125;">{{ $data['slider']->title }}</h2>
                        </div>
                    </div>
                    <div class="col-lg-7 m-auto" style="color: #202125;">
                        <p>
                            {{ $data['slider']->details }}
                        </p>
                    </div>
                    <!-- <a class="ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-fill ttm-btn-color-dark" href="#">Click Here</a> -->
                </div>
            </div>  

            {{-- <div class="col-lg-5">
                <div class="ttm-col-bgcolor-yes ttm-bgcolor-skincolor ttm-col-bgimage-yes col-bg-img-two ttm-bg spacing-9">
                    <div class="ttm-col-wrapper-bg-layer ttm-bg-layer">
                        <div class="ttm-col-wrapper-bg-layer-inner"></div>
                    </div>
                    <div class="layer-content">
                        <!-- section-title -->
                        <div class="section-title mb-10">
                            <div class="title-header pb-0">
                                <h2 class="title">نبدأ الآن</h2>
                            </div>
                        </div><!-- section-title end -->
                        <p>خلافاً للاعتقاد السائد، فإن لوريم إيبسوم ليس مجرد نص عشوائي. الأدب اللاتيني من كونتراري</p>
                        <form action="#" class="ttm-contactform_transparent wrap-form clearfix" method="post">
                            <label>
                                <span class="text-input"><input name="name" type="text" value="" placeholder="الاسم بالكامل" required="required"></span>
                            </label>
                            <label>
                                <span class="text-input"><input name="address" type="text" value="" placeholder="البريد الالكتروني" required="required"></span>
                            </label>
                            <label>
                                <span class="text-input"><input name="phone" type="text" value="" placeholder="رقم الهاتف" required="required"></span>
                            </label>
                            <button class="submit ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-fill ttm-btn-color-white mt-15" type="submit"> الإنضمام الآن</button>
                        </form>
                    </div>
                </div>
            </div> --}}
                              
        </div>
    </div>
</section>




<div class="site-main">

    <section class="ttm-row team-section ttm-bgcolor-grey clearfix" style="    background-color: unset;">
        <div class="container">
            <!-- section title -->
            <div class="section-title title-style-center_text">
                <div class="title-header">
                    <!-- <h5>Find The Right Instructor</h5> -->
                    <h2 class="title">  الجامعات </h2>
                </div>
                <div class="heading-seperator"><span></span></div>
            </div>
            
            <!-- data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "arrows":false, "autoplay":false, "rtl":true, "infinite":true, "responsive": [{"breakpoint":991,"settings":{"slidesToShow": 3}}, {"breakpoint":678,"settings":{"slidesToShow": 2}}, {"breakpoint":460,"settings":{"slidesToShow": 1}}]}' -->
            
            <div class="row justify-content-center">
                @foreach ($data['universities'] as $item)
                    <div class="ttm-box-col-wrapper col-md-2 col-sm-4">
                        <div class="featured-imagebox featured-imagebox-team style2" >
                            <a href="{{URL::to('/')}}/university/{{$item->id}}">
                                <div class="featured-thumbnail">
                                    <img class="img-fluid lazyload" data-src="{{URL::to('/')}}/uploads/{{$item->photo}}" style="object-fit: contain;" alt="{{$item->title_ar}}"> 
                                </div>
                            </a>
                            <h5><a href="{{URL::to('/')}}/university/{{$item->id}}">{{$item->title_ar}} </a></h5>
                        </div>
                    </div>
                @endforeach
                {{-- <div class="ttm-box-col-wrapper  col-md-2 col-sm-4 ">
                    <div class="featured-imagebox featured-imagebox-team style2" >
                        <div class="featured-thumbnail">
                            <img class="img-fluid lazyload" data-src="{{URL::to('/')}}/site/assets/images/a2.png" style="object-fit: contain;" alt="image">
                        </div>
                        <h5><a href=""> جامعة جدة </a></h5>
                    </div>
                </div> --}}
                
            </div>
        </div>
    </section>


    <!--about-section_3-->
    <section class="ttm-row about-section_3 clearfix">
        <div class="container">
            
            <div class="row">
                <div class="col-lg-12">
                    <div class="ttm-bgcolor-grey pt-60 res-991-pt-40 pb-60 res-991-pb-15 ml-100 res-991-ml-0">
                        <div class="row">
                            <div class="col-lg-6">
                                <!-- ttm_single_image-wrapper -->
                                <div class="ttm_single_image-wrapper ml_180 res-1199-ml_50 res-991-ml-0 mt_110 res-991-mt-0 mr-40 res-991-mr-0">
                                    <img class="img-fluid" src="{{URL::to('/')}}/uploads/{{ $data['aboutus']->photo }}" alt="{{ $data['aboutus']->title }}">
                                </div>
                            </div>
                            <div class="col-lg-6 div_about" >
                                 <div class="spacing-18">
                                    <!-- section title -->
                                    <div class="section-title">
                                        <div class="title-header">
                                            <h5> عن منصة خصوصي </h5>
                                            <h2 class="title"> {{ $data['aboutus']->title }}</h2>
                                        </div>
                                        <div class="heading-seperator"><span></span></div>
                                    </div>
                                    <p>{!!\App\Http\Helpers\Helpers::cutText($data['aboutus']->details,450,true)!!}</p>
                                    <a class="ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-border ttm-btn-color-dark mt-30" href="{{URL::to('/')}}/page/aboutus"> عرض المزيد  </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pt-45 pb-50 res-991-pb-40 res-991-pl-15 res-991-pr-15">
                
                <div class="row jusify-content-center">
                    @foreach ($data['statistics'] as $item)
                        
                        <div class="col-lg-3 col-md-3 col-sm-6">
                            <div class="ttm-fid inside ttm-fid-with-icon text-center style3">
                                <div class="ttm-fid-contents">
                                    <h4 class="ttm-fid-inner">
                                        <span   data-appear-animation="animateDigits" 
                                                data-from="0" 
                                                data-to="{{ $item->number }}" 
                                                data-interval="1" 
                                                data-before="" 
                                                data-before-style="sup" 
                                                data-after="" 
                                                data-after-style="sub" 
                                                class="numinate">{{ $item->number }}
                                        </span>
                                        <sub>+</sub>
                                    </h4>
                                    <h3 class="ttm-fid-title">  {{ $item->title }}</h3>
                                </div>
                            </div><!-- ttm-fid end -->
                        </div>
                    @endforeach
                    
                </div>
            </div>
        </div>
    </section>
   

</div>

@endsection
@section('js')
<script>
</script>
@stop