@extends('site.layout.layout')
@section('url'){{Request::fullUrl()}}@stop
@section('title'){{\App\Http\Helpers\Helpers::stringReplace($setting->name,3)}}@stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($setting->description,3)}}@stop
@section('css')
@endsection
@section('content')



<section class="hero hero-slider-wrapper hero-slider-style-2" dir="rtl">
    <div class="hero-slider">
        @php 
            $i=1;
        @endphp
        @foreach ($data['slider'] as $item)
            <div class="slide">
                <img src="{{URL::to('/')}}/uploads/{{$item->photo}}" alt="" class="slider-bg">
                <div class="container">
                    <div class="row">
                        <div class="col col-lg-8 col-sm-9 slide-caption float-right pr-50">
                            <h3 class="text-right" style="color: #fff;"> {{ $data['count_slider'] }} / <span
                                    style="color: #009D57;font-size: 40px;"> {{ $i }} </span> </h3>
                            <br>
                            <h2 class="text-right"> {{$item->title}}</h2>
                            <p class="text-right" style="direction: rtl;text-align: justify !important;font-size: 17px !important;"> {{$item->details}}
                            </p>
                            <br>
                            {{-- <div class="btns float-right">
                                <a href="" class="theme-btn" tabindex="0"> عرض المزيد </a>
                            </div> --}}
                        </div>
                    </div>
                </div>
            </div>
            @php 
                $i++;
            @endphp
        @endforeach
    </div>
</section>


<section class="section-padding offer-section" dir="rtl" style="padding-top: 70px; padding-bottom: 60px;">
    <div class="container">
        <div class="row">

            <div class="col col-md-5" style="float: right;">
                <div class="section-title-s3">
                    <h2>  {{$data['aboutus']->title}} </h2>
                </div>
                <div class="offer-text">
                    <p>{!!\App\Http\Helpers\Helpers::cutText($data['aboutus']->details,750,true)!!}</p>
                    
                    <a href="{{URL::to('/')}}/page/aboutus" class="theme-btn-s7 read-more"> {{ __('app.See_More') }} </a>
                </div>
            </div>
            <div class="col col-md-7" style="margin-top: 30px;">
                <div class="offer-pic">
                    <!-- style="width:498px!important; height:340px !important;" -->
                    <img src="assets/images/min.png" alt="">
                </div>
            </div>
        </div> <!-- end row -->
    </div> <!-- end container -->
</section>


    <!-- About Start -->
    <div class="section about-section section-padding">
        <div class="container">
            <!-- About Wrap Start -->
            <div class="about-wrap">
                <div class="row">
                    <div class="col-lg-6">
                        <!-- About Thumb Wrap Start -->
                        <div class="about-thumb-wrap">
                            <div class="about-thumb-small" style="width: 100%;">
                                <img src="{{URL::to('/')}}/img/546x450/{{$data['aboutus']->photo}}" style="width: 100%;" alt="{{$data['aboutus']->title}}">
                            </div>
                            {{-- <div class="about-thumb-big">
                                <img src="{{URL::to('/')}}/new_site/images/about-2.jpg" alt="">
                            </div> --}}
                            <div class="about-thumb-shape">
                                <img src="{{URL::to('/')}}/new_site/images/ab-shape.png" alt="">
                            </div>
                            {{-- <div class="play-btn">
                                <a class="popup-video" href="https://www.youtube.com/watch?time_continue=3&v=_X0eYtY8T_U"><i class="fas fa-play"></i></a>
                            </div> --}}
                        </div>
                        <!-- About Thumb Wrap End -->
                    </div>
                    <div class="col-lg-6">
                        <!-- About Content Start -->
                        <div class="about-content">
                            <div class="section-title">
                                <h3 class="sub-title">  من نحن   </h3>
                                <h2 class="title">{{$data['aboutus']->title}}</h2>
                            </div>
                            <p>{!!\App\Http\Helpers\Helpers::cutText($data['aboutus']->details,750,true)!!}</p>
                            <div class="about-author-list mt-5">
                                <div class="hero-btn" data-aos="fade-up" data-aos-delay="900">
                                    <a class="btn" href="{{URL::to('/')}}/aboutus">مزيد من التفاصيل</a>
                                </div>
                            </div>
                        </div>
                        <!-- About Content End -->
                    </div>
                </div>
            </div>
            <!-- About Wrap End -->
        </div>
    </div>
    <!-- About End -->


        <div class="section  weather d-none" id="weather">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="jeg_weather_head">
                            <div class="location">
                                <h4 id="name_weather"> </h4>
                            </div>
                            <div class="jeg_weather_date">
                                <span>{{\App\Http\Helpers\Helpers::dateFormat(date('Y-m-d'),false)}} 
                                    {{-- , <p style="display: inline-block;" id="time"></p> </span> --}}
                            </div>
                        </div>
                        
                        <div class="jeg_weather_desc">
                            <div class="jeg_weather_today clearfix">
                                <div class="jeg_weather_temp">
                                    <span class="jeg_weather_value" id="tmp_weather"  data-temp-c="26" ></span>
                                    <span class="jeg_weather_degrees">°</span>
                                    <span class="jeg_weather_unit" data-unit="c">c</span>
                                </div>
                                <div class="jeg_weather_icon">
                                    <span class="jeg_weather_cloudy partly">
                                        {{-- <i class="fa fa-cloud"></i> --}}
                                        <img id="icon" src="" alt="">
                                    </span>
                                    <span class="jeg_weather_condition" id="weather_condition"> </span>
                                </div>
                                
                            </div>
                            <div class="jeg_weather_detail clearfix">
                                <div class="jeg_weather_humidity">
                                    <span class="jeg_weather_value" id="humidity"></span>
                                    <i class="fa fa-tint"></i>
                                </div>
                                <div class="jeg_weather_wind">
                                    <span class="jeg_weather_value" id="wind_speed"></span>
                                    <i class="fa fa-wind"></i>
                                </div>
                                <div class="jeg_weather_cloud">
                                    <span class="jeg_weather_value" id="clouds"></span>
                                    <i class="fa fa-cloud"></i>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

         <!-- Case Study Start -->
         <div class="section case-study-section section-padding" >
            <div class="container">
                <div class="case-study-wrap">
                    <div class="section-title text-center">
                        <h3 class="sub-title">  {{$data['images']->title}}
                            </h3>
                        <h4 class="">{!!$data['images']->details!!}</h4>
                    </div>
                </div>
            </div>

            <!-- Case Study Slider Wrap Start -->
            <div class="case-study-slider-wrap">
                <div class="swiper-container case-study-active">
                    <div class="swiper-wrapper" >
                        @foreach ($data['media'] as $item)
                        
                        <div class="swiper-slide">

                            @if($item->type == 1) 
                                @php
                                        $video_id = \App\Http\Helpers\Helpers::get_youtube_video_ID($item->url);
                                        $thumbnail="http://img.youtube.com/vi/".$video_id."/maxresdefault.jpg";
                                @endphp
                            @else 
                                @php
                                $thumbnail=URL::to('/')."/img/641x550/".$item->image;
                                @endphp
        
                            @endif
                            <!-- Single Case Study Start -->
                            <div class="single-case-study text-center" style="background-image: url({{$thumbnail}});">
                                <div class="case-study-content">
                                    <div class="case-study-title">
                                        <h3 class="title">{{$item->title}}</h3>
                                        @if($item->type == 1) 
                                            <span> فيديو </span>
                                        @else 
                                            <span> البوم صور  </span>
                                        @endif
                                    </div>
                                    {{-- <div class="case-study-text">
                                        <p>Accelerate innovation with world-class tech teams We’ll match you to an entire remote team of incredible freelance talent for all your software development needs.</p>
                                    </div> --}}
                                    <div class="case-study-link">
                                        <a @if($item->type == 1) data-fancybox="gallery{{$item->id}}{{$item->type}}"  href="{{$item->url}}" @else href="{{URL::to('/')}}/albums/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}" @endif ><i class="fas fa-long-arrow-alt-left"></i></a>
                                    </div>
                                </div>
                            </div>
                            <!-- Single Case Study End -->
                        </div>
                     @endforeach


                     
                    </div>

                    <!-- Add Pagination -->
                    <div class="case-study-arrow swiper-button-next"></div>
                    <div class="case-study-arrow swiper-button-prev"></div>

                    <div class="swiper-pagination"></div>
                </div>
            </div>
            <!-- Case Study Slider Wrap End -->

            <!-- Case Study Button Start -->
            {{-- <div class="row jusify-content-center">
                <div class="case-study-btn text-center">
                    <a class="btn" href="#">See More Projects</a>
                </div>
            </div> --}}
            <!-- Case Study Button End -->

        </div>
        <!-- Case Study End -->



    <div class="section section-padding blog-section " style="padding-top: 0px">
        <div class="container">
            <!-- Blog Wrap Start -->
            <div class="blog-wrap">
                <div class="section-title text-center">
                    <h3 class="sub-title"> {{$data['post']->title}} </h3>
                    <h4 class="">  {!!$data['post']->details!!} </h4>
                </div>
                <!-- Blog Content Wrap Start -->
                <div class="blog-content-wrap">
                    <div class="row">
                        @foreach ($data['news'] as $item)
                            <div class="col-lg-4 col-md-6">
                                <!-- Single Blog Start -->
                                <div class="single-blog">
                                    <div class="blog-img">
                                        <a href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                            <img src="{{URL::to('/')}}/img/356x300/{{$item->main_image}}" alt=""></a>
                                        <div class="top-meta">
                                            <span class="date"><span> {{date('d',strtotime($item->date))}}</span> {{\App\Http\Helpers\Helpers::get_month_name(date('M',strtotime($item->date)))}} </span>
                                        </div>
                                    </div>
                                   

                                    <div class="blog-content">
                                        <div class="blog-meta" style="padding-top: 10px;">
                                            <span><i class="fas fa-folder"></i> <a href="#">{{$item->category_name}}</a></span>
                                            {{-- <span><i class="far fa-comments"></i> </span> --}}
                                        </div>
                                        <h3 class="title" style="min-height: 60px;">
                                            <a href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                                {{\App\Http\Helpers\Helpers::cutText($item->title,80,true)}}
                                            </a>
                                        </h3>

                                        
                                        <p>
                                             {{\App\Http\Helpers\Helpers::cutText($item->summary,80,true)}}
                                        </p>
                                    </div>
                                    <div class="blog-btn">
                                        <a class="blog-btn-link" href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}"> قراءة المزيد    <i class="fas fa-long-arrow-alt-left"></i></a>
                                    </div>
                                </div>
                                <!-- Single Blog End -->
                            </div>

                        @endforeach
                        @foreach ($data['publications'] as $item)
                        <div class="col-lg-4 col-md-6">
                            <!-- Single Blog Start -->
                            <div class="single-blog">
                                <div class="blog-img">
                                    <a href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                        <img src="{{URL::to('/')}}/img/356x300/{{$item->main_image}}" alt=""></a>
                                    <div class="top-meta">
                                        <span class="date"><span> {{date('d',strtotime($item->date))}}</span> {{\App\Http\Helpers\Helpers::get_month_name(date('M',strtotime($item->date)))}} </span>
                                    </div>
                                </div>
                               

                                <div class="blog-content">
                                    <div class="blog-meta" style="padding-top: 10px;">
                                        <span><i class="fas fa-folder"></i> <a href="#">{{$item->category_name}}</a></span>
                                        {{-- <span><i class="far fa-comments"></i> </span> --}}
                                    </div>
                                    <h3 class="title" style="min-height: 60px;">
                                        <a href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                            {{\App\Http\Helpers\Helpers::cutText($item->title,80,true)}}
                                        </a>
                                    </h3>
                                    <p>
                                        {{\App\Http\Helpers\Helpers::cutText($item->summary,80,true)}}
                                   </p>
                                </div>
                                <div class="blog-btn">
                                    <a class="blog-btn-link" href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}"> قراءة المزيد    <i class="fas fa-long-arrow-alt-left"></i></a>
                                </div>
                            </div>
                            <!-- Single Blog End -->
                        </div>

                    @endforeach
            
                   
                       
                    </div>
                </div>
                <!-- Blog Content Wrap End -->
            </div>
            <!-- Blog Wrap End -->
        </div>
    </div>
  
        @if(isset($data['section']) && $data['section']->status == 1 )
        <div class="section cta-section-3 section-padding-03" style="background-image: url(new_site/images/bg/counter-bg.jpg);">
            <div class="container">
                <div class="cta-wrap-3">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="cta-content text-center">
                                <h2 class="title"> {{$data['section']->title}} </h2>
                                <p> {!!$data['section']->details!!}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
          

        @endif
    {{--  --}}
          <!-- Team Start -->
          <div class="section team-section section-padding"  @if(isset($data['section']) && $data['section']->status == 0 ) style="padding-top: 0px"   @endif>
            <div class="container">
                <!-- Team Wrap Start -->
                <div class="team-wrap">
                    <div class="section-title text-center">
                     
                        <h3 class="sub-title"> {{$data['engineers']->title}} </h3>
                        <h4 class="">  {!!$data['engineers']->details!!} </h4>
                    </div>
                    <!-- Team Content Wrap Start -->
                    <div class="team-content-wrap">
                        <div class="swiper-container team-active">
                            <div class="swiper-wrapper">
                                @foreach ($data['data_engineers'] as $item)
                                    
                                <div class="swiper-slide">
                                    <!-- Single Team Start -->
                                    <div class="single-team">
                                        <div class="team-img">
                                            <a href="{{URL::to('/')}}/engineers/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                                @if($item->image == '')
                                                    @if($item->gender == 1)
                                                        <img  src="{{URL::to('/')}}/new_site/images/profileM.png"alt="{{\App\Http\Helpers\Helpers::stringReplace($item->title,3)}}">

                                                    @elseif($item->gender == 2) 
                                                        <img src="{{URL::to('/')}}/new_site/images/profileF.png"  alt="{{\App\Http\Helpers\Helpers::stringReplace($item->title,3)}}">

                                                    @endif
                                                @else 
                                                    <img  src="{{URL::to('/')}}/img/352x400/{{$item->image}}"  alt="{{\App\Http\Helpers\Helpers::stringReplace($item->title,3)}}">
                                                @endif
                                                {{-- <img src="{{URL::to('/')}}/new_site/images/team/team-1.jpg" alt=""> --}}
                                            </a>
                                        </div>
                                        <div class="team-content">
                                            <div class="team-social">
                                                
                                            </div>
                                            <h3 class="name"><a href="{{URL::to('/')}}/engineers/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}"> {{$item->title}} </a></h3>
                                            <span class="designation" s><i class="fa fa-university"> </i> {{$item->name_specialization}} </span>

                                            {{-- <span style="direction: rtl"><i class="fa fa-university"> </i> {{$item->name_specialization}} </span> --}}
                                            {{-- <span style="direction: rtl"><i class="fa fa-graduation-cap"> </i> {{$item->graduation_year}} </span> --}}
                                        </div>
                                    </div>
                                    <!-- Single Team End -->
                                </div>
                                @endforeach
                                
                            </div>

                            <!-- Add Pagination -->
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                    <!-- Team Content Wrap End -->
                </div>
                <!-- Team Wrap End -->
            </div>
        </div>
        <!-- Team End -->


    <div class="section cta-section">
        <div class="container">
            <div class="cta-wrap" style="background: linear-gradient( 148deg, #54d6eb  0%, #3bb367 100%);">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <!-- Cta Left Start -->
                        <div class="cta-left">
                            <h2 class="title">  {{$data['connect_with_us']->title}} </h2>
                        </div>
                        <!-- Cta Left End -->
                        
                    </div>
                    <div class="col-lg-6">
                        <!-- Cta Right Start -->
                        <div class="cta-right" style="float: left">
                            <a class="btn" href="{{URL::to('/')}}/contactus"> تواصل معنا   </a>
                        </div>
                        <!-- Cta Right End -->
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')

<script>
    $(document).ready(function() {
        getLocation();
        // showTime();

        function getLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(
                    // Success function
                    showPosition, 
                    // Error function
                    null, 
                    // Options. See MDN for details.
                    {
                    enableHighAccuracy: true,
                    timeout: 5000,
                    maximumAge: 0
                    });
            } else { 
                var e = "Geolocation is not supported by this browser.";
            }
        }
        
        function showPosition(position) {
            console.log(position.coords.latitude);
            console.log(position.coords.longitude);
            $.ajax({
                url: "/tmp",
                type: "get",
                dataType: "JSON",
                data: {
                    lat: position.coords.latitude,
                    lon: position.coords.longitude
                },
                success: function(data){
                    if(data['status'] == true){
                        $('#weather').removeClass('d-none');
                        console.log(data);
                        $('#weather').find('#name_weather').html(' شارع '+data.data['name']);
                        $('#weather').find('#tmp_weather').html(data.data['tmp']);
                        $('#weather').find('#weather_condition').html(data.data['weather_condition']);
                        $('#weather').find('#wind_speed').html(data.data['wind_speed'] + ' كم / ساعة ');
                        $('#weather').find('#icon').attr('src','/new_site/images/'+data['data']['icon']+'.png');
                        $('#weather').find('#humidity').html(data.data['humidity'] + '%');
                        $('#weather').find('#clouds').html(data.data['clouds'] + '%');

                        
                        
                    }
                }
            });

        }
        function showTime() {
            var date = new Date();
            var h = date.getHours(); // 0 - 23
            var m = date.getMinutes(); // 0 - 59
            var s = date.getSeconds(); // 0 - 59
            var session = "AM";
    
            if (h == 0) {
                h = 12;
            }
    
            if (h > 12) {
                h = h - 12;
                session = "PM";
            }
    
            h = (h < 10) ? "0" + h : h;
            m = (m < 10) ? "0" + m : m;
            s = (s < 10) ? "0" + s : s;
    
            var time = h + ":" + m + ":" + s + " " + session;
            document.getElementById("time").innerText = time;
            document.getElementById("time").textContent = time;
            setTimeout(showTime, 1000);
        }

    });
</script>

@stop