<!doctype html>
<html class="no-js" lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <meta charset="utf-8">
      <title>@yield('title')</title>
      <meta name="robots" content="ALL, INDEX, FOLLOW" />
      <meta property="og:url" content="@yield('url')" />
      <meta property="og:type" content="article" />
      <meta property="og:title" content="@yield('title')" />
      <meta property="og:description" content="@yield('description')" />
      <meta property="og:image" content="@yield('image')">
      @yield('posts')
      
      <meta property="og:site_name" content="@yield('title')" />
      <meta name="twitter:card" content="summary_large_image" />
      <meta name="twitter:title" content="@yield('title')" />
      <meta name="twitter:site" content="@palaif" />
      <meta name="twitter:creator" content="@palaif" />
      <meta name="twitter:description" content="@yield('description')" />
      <meta name="twitter:image" content="@yield('image')" />
      <meta name="twitter:domain" content="{{URL::to('/')}}" />
      <meta name="twitter:url" content="@yield('url')" />
      <meta name="description" content="@yield('description')" />
      <meta name="keywords" content="{{\App\Http\Helpers\Helpers::stringReplace($setting->key_words,3)}}" /> 
      <meta name="author" content="pal-aif" />
      <meta name="rating" content="General" />
      <link rel="sitemap" type="application/xml" title="Sitemap" href="{{URL::to('/')}}/sitemap.xml" />
      
      <link rel="apple-touch-icon" sizes="180x180" href="{{URL::to('/')}}/new_site/images/apple-touch-icon.png">
      <link rel="icon" type="image/png" sizes="32x32" href="{{URL::to('/')}}/new_site/images/favicon-32x32.png">
      <link rel="icon" type="image/png" sizes="16x16" href="{{URL::to('/')}}/new_site/images/favicon-16x16.png">
    <!-- CSS
	============================================ -->

    <!-- Icon Font CSS -->
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/plugins/all.min.css">
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/plugins/flaticon.css">

    <!-- Plugins CSS -->
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/plugins/bootstrap.min.css">
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/plugins/swiper-bundle.min.css">
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/plugins/aos.css">
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/plugins/magnific-popup.css">
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/jquery.fancybox.min.css">
    <link href="{{URL::to('/')}}/new_site/css/slick.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/new_site/css/slick-theme.css" rel="stylesheet">
    <!-- Main Style CSS -->
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/style.css?v=1.0.2">
    <link rel="stylesheet" href="{{URL::to('/')}}/new_site/css/style-rtl.css">

 <style>
        .single-blog .blog-content {
            padding: 0px 40px 25px 40px;
            /* min-height: 122px; */

        }
        .service-item .service-content h4.title{
            min-height: 60px;
        }
        .copyright-social .social li a:hover {
            color: #f5ef07;
        }
        #loading {
            display: none;
         }
         #loading {
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            position: fixed;
            display: none;
            opacity: 0.8;
            z-index: 99900000 !important;
            background-color: #fff;
            z-index: 199;
            text-align: center;
         }
         .social_a {
            width: 200px;
            position: fixed;
            height: 100vh;
            flex-direction: column;
            transform: translate(-147px,0);
            top: 23%;
            left: 6px;
            z-index: 9999999999;
        }
        .social_a a {
            position: relative;
            color: #fff;
            background: rgba(0,0,0,0.3);
            /* background-image: linear-gradient(120deg, #54d6eb 0%, #3bb367 100%); */
            font-size: 18px;
            font-weight: 600;
            text-decoration: none;
            display: block;
            margin: 5px;
            padding-bottom: 10px;
            padding-top: 0px;
            width: 300px;
            text-align: right;
            border-radius: 50px;
            transition: 1s;
            transition-property: transform;
        }
        .social_a img {
            margin-top: 5px;
            padding-right: 15px;
            margin-left: 15px;
            font-size: 30px;
            width: 50px;
            height: 34px;
            z-index: 9999999999999999999;
            float: right;
        }
        .social_a a:hover {
            transform: translate(110px,0);
        }
        .sidebar-widget {
            margin-top: 0;
        }
        .techmax-pagination ul{
            justify-content: center;
        }
 </style>
    
    @yield('css')


    <!--====== Use the minified version files listed below for better performance and remove the files listed above ======-->
    <!-- <link rel="stylesheet" href="assets/css/vendor/plugins.min.css">
    <link rel="stylesheet" href="assets/css/style.min.css"> -->

</head>

<body>
    @php
        $url = \URL::to('/');
    @endphp
    <div class="main-wrapper">
        <content class="social_a">
            @foreach ($quick_links as $item)
                <a href="{{$item->url}}" target="_blank">{{$item->name}}  <img src="{{URL::to('/')}}/uploads/{{$item->icon}}" alt="">  </a>
            @endforeach
        </content>


        <!-- Preloader start -->
        <div id="preloader">
            <div class="preloader">
                <span></span>
                <span></span>
            </div>
        </div>
        <!-- Preloader End -->

        <!-- Header Start  -->
        <div id="header" class="section header-section transparent-header">
            <div class="container">

                <!-- Header Wrap Start  -->
                <div class="header-wrap">

                    <div class="header-logo">
                        <a href="{{URL::to('/')}}"><img src="{{URL::to('/')}}/new_site/images/logo.png" alt=""></a>
                    </div>

                     <div class="header-menu d-none d-lg-block">
                        <ul class="main-menu">
                            <li class="@if(Request::url() == $url )active-menu @endif ">
                                <a href="{{URL::to('/')}}">الرئيسية</a>
                            </li>
                            <li class="@if(Request::url() == $url.'/aboutus' ) active-menu @endif">
                                <a href="{{URL::to('/')}}/aboutus">  من نحن </a>
                            </li>
                            <li class="@if(request()->is('category*') || request()->is('posts*')) active-menu @endif">
                                <a href="#"> الزراعة</a>
                                <ul class="sub-menu">
                                    @foreach($post_category as $p)
                                        <li class="@if(request()->is('category/'.$p->id))active-menu @endif "><a href="{{URL::to('/')}}/category/{{$p->id}}">{{$p->name}}</a></li>
                                    @endforeach
                                
                                </ul>
                            </li>
                            <li class="@if(request()->is('research*') || request()->is('external_research*') ) active-menu @endif"><a href="#">الأبحاث</a>
                                <ul class="sub-menu">
                                    @foreach($research_category as $re)
                                        <li class="@if(request()->is('research/'.$re->id) )active-menu @endif "><a href="{{URL::to('/')}}/research/{{$re->id}}">{{$re->name}}</a></li>
                                    @endforeach
                                    <li class="@if(request()->is('external_research*') )active-menu @endif "><a href="{{URL::to('/')}}/external_research"> دراسات واوراق بحثية خارجية </a></li>

                                
                                </ul>
                            </li>
                            <li class="@if(request()->is('samples*')) active-menu @endif"><a href="#" >النماذج</a>
                                <ul class="sub-menu">
                                    @foreach($sample_category as $sa)
                                        <li class="@if(request()->is('samples/'.$sa->id) )active-menu @endif "><a href="{{URL::to('/')}}/samples/{{$sa->id}}">{{$sa->name}}</a></li>
                                    @endforeach
                                
                                </ul>
                            </li>
                            <li class="@if(request()->is('trainings*')|| request()->is('workshops_panel_discussions*')) active-menu @endif"><a href="#">التدريبات</a>
                                <ul class="sub-menu">
                                    @foreach($trainings_category as $t)
                                        <li class="@if(request()->is('trainings/'.$t->id) )active-menu @endif "><a href="{{URL::to('/')}}/trainings/{{$t->id}}">{{$t->name}}</a></li>
                                    @endforeach
                                    <li class="@if(request()->is('workshops_panel_discussions*') )active-menu @endif "><a href="{{URL::to('/')}}/workshops_panel_discussions">ورش عمل او  حلقة نقاش </a></li>
            
                                
                                </ul>
                            </li>
                            <li class="@if(request()->is('library*')) active-menu @endif"><a href="#">المكتبة الزراعية</a>
                                <ul class="sub-menu">
                                    @foreach($library_category as $l)
                                        <li class="@if(request()->is('library/'.$l->id) )active-menu @endif "><a href="{{URL::to('/')}}/library/{{$l->id}}">{{$l->name}}</a></li>
                                    @endforeach
                                
                                </ul>
                            </li>
                            <li class="@if(Request::url() == $url.'/category/1' ) active-menu @endif">
                                <a href="{{URL::to('/')}}/category/1">  إصدارات توعوية  </a>
                            </li>
                            <li class="@if(request()->is('albums*') || request()->is('videos*')) active-menu @endif"><a href="#">الميديا</a>
                                <ul class="sub-menu">
                                    <li class="@if(request()->is('albums*') )active-menu @endif "><a href="{{URL::to('/')}}/albums"> معرض الصور</a></li>
                                    <li class="@if(request()->is('videos*') )active-menu @endif "><a href="{{URL::to('/')}}/videos">  فيديوهات </a></li>

                                </ul>
                            </li>
                          
                            <li class="@if(request()->is('engineers*') || request()->is('crops*') || request()->is('animals*') || request()->is('birds*') || request()->is('food_industrial*')) active-menu @endif"><a href="#"><i class="fa fa-bars "></i> </a>
                                <ul class="sub-menu">
                                    <li class="@if(request()->is('engineers*') )active-menu @endif "><a href="{{URL::to('/')}}/engineers"> المهندسين </a></li>
                                    <li class="@if(request()->is('crops*') )active-menu @endif "><a href="{{URL::to('/')}}/crops"> المحاصيل </a></li>
                                    <li class="@if(request()->is('animals*') )active-menu @endif "><a href="{{URL::to('/')}}/animals"> حيوانات المزرعة </a></li>
                                    <li class="@if(request()->is('birds*') )active-menu @endif "><a href="{{URL::to('/')}}/birds"> الدواجن </a></li>
                                    <li class="@if(request()->is('food_industrial*') )active-menu @endif "><a href="{{URL::to('/')}}/food_industrial"> الصناعات الغذائية </a></li>

                                </ul>
                            </li>
                        </ul>
                    </div>

                    <!-- Header Meta Start -->
                    <div class="header-meta">
                        <!-- Header Info Start -->
                        {{-- <div class="header-info d-none d-md-flex">
                            <div class="info-icon">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                            <div class="info-text">
                                <span>Free Consultant</span>
                                <span class="number"><a href="#">+36 55 540 069</a></span>
                            </div>
                        </div> --}}
                        <!-- Header Info End -->
                        <!-- Header Search Start -->
                        <div class="header-search">
                            <a class="search-btn" href="#"><i class="flaticon-loupe"></i></a>
                            <div class="search-wrap">
                                <div class="search-inner">
                                    <i id="search-close" class="flaticon-close search-close"></i>
                                    <div class="search-cell">
                                        <form action="{{URL::to('/')}}/search" method="POST" class=""  id="search">
                                            @csrf
                                            <div class="search-field-holder">
                                                <input class="main-search-input search" name="search" type="search" placeholder=" ابحث عن احدث الأخبار و النشرات ... ">
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Header Search End -->

                       
                       
                        <!-- Header Toggle Start -->
                        <div class="header-toggle d-lg-none">
                            <button data-bs-toggle="offcanvas" data-bs-target="#offcanvasExample">
                                <span></span>
                                <span></span>
                                <span></span>
                            </button>
                        </div>
                        <!-- Header Toggle End -->
                    </div>
                    <!-- Header Meta End  -->

                </div>
                <!-- Header Wrap End  -->

            </div>
        </div>
        <!-- Header End -->

        <!-- Offcanvas Start-->
        <div class="offcanvas offcanvas-start" id="offcanvasExample">
            <div class="offcanvas-header">
                <!-- Offcanvas Logo Start -->
                <div class="offcanvas-logo">
                    <a href="index.html"><img src="{{URL::to('/')}}/new_site/images/logo-white.png" alt=""></a>
                </div>
                <!-- Offcanvas Logo End -->
                <button type="button" class="close-btn" data-bs-dismiss="offcanvas"><i class="flaticon-close"></i></button>
            </div>

            <!-- Offcanvas Body Start -->
            <div class="offcanvas-body">
                <div class="offcanvas-menu">
                    <ul class="main-menu">
                        <li class="active-menu">
                            <a href="{{URL::to('/')}}">الرئيسية</a>
                        </li>
                        <li>
                            <a href="{{URL::to('/')}}/aboutus">  من نحن </a>
                        </li>
                        <li><a href="#">الزراعة </a>
                            <ul class="sub-menu">
                                  @foreach($post_category as $p)
                                        <li ><a href="{{URL::to('/')}}/category/{{$p->id}}">{{$p->name}}</a></li>
                                    @endforeach
                            
                            </ul>
                        </li>
                        <li><a href="#">الأبحاث</a>
                            <ul class="sub-menu">
                                  @foreach($research_category as $re)
                                                     <li ><a href="{{URL::to('/')}}/research/{{$re->id}}">{{$re->name}}</a></li>
                                                  @endforeach
                            <li ><a href="{{URL::to('/')}}/external_research">دراسات واوراق بحثية خارجية</a></li>
        
                            
                            </ul>
                        </li>
                        <li><a href="#">النماذج</a>
                            <ul class="sub-menu">
                                 @foreach($sample_category as $sa)
                                                     <li ><a href="{{URL::to('/')}}/samples/{{$sa->id}}">{{$sa->name}}</a></li>
                                                  @endforeach
                            
                            </ul>
                        </li>
                        <li><a href="#">التدريبات</a>
                            <ul class="sub-menu">
                                   @foreach($trainings_category as $t)
                                                     <li ><a href="{{URL::to('/')}}/trainings/{{$t->id}}">{{$t->name}}</a></li>
                                                  @endforeach
                                                     <li ><a href="{{URL::to('/')}}/workshops_panel_discussions">ورش عمل او  حلقة نقاش </a></li>
        
                            
                            </ul>
                        </li>
                        <li><a href="#">المكتبة الزراعية</a>
                            <ul class="sub-menu">
                                  @foreach($library_category as $l)
                                                     <li ><a href="{{URL::to('/')}}/library/{{$l->id}}">{{$l->name}}</a></li>
                                                  @endforeach
                            
                            </ul>
                        </li>
                        <li>
                            <a href="{{URL::to('/')}}/category/1">  إصدارات توعوية   </a>
                        </li>
                        <li><a href="#">الميديا</a>
                            <ul class="sub-menu">
                                <li><a href="{{URL::to('/')}}/albums"> معرض الصور</a></li>
                                <li><a href="{{URL::to('/')}}/videos">  فيديوهات </a></li>

                            </ul>
                        </li>
                      
                        <li><a href="#"><i class="fa fa-bars "></i> </a>
                            <ul class="sub-menu">
                                <li><a href="{{URL::to('/')}}/engineers"> المهندسين </a></li>
                                <li><a href="{{URL::to('/')}}/crops"> المحاصيل </a></li>
                                <li><a href="{{URL::to('/')}}/animals"> حيوانات المزرعة </a></li>
                                <li><a href="{{URL::to('/')}}/birds"> الدواجن </a></li>
                                <li><a href="{{URL::to('/')}}/food_industrial"> الصناعات الغذائية </a></li>

                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- Offcanvas Body End -->
        </div>
        <!-- Offcanvas End -->

        @yield('content')


        <!-- Footer Section Start -->
        <div class="section footer-section" >

            <div class="container">
                <!-- Footer Widget Wrap Start -->
                <div class="footer-widget-wrap">
                    <div class="row">
                        <div class="col-lg-12 col-sm-12">
                            <div class="footer-widget-about text-center">
                                <a class="footer-logo text-center" href="{{URL::to('/')}}" >
                                    <img src="{{URL::to('/')}}/new_site/images/logo-white.png" alt="Logo">
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <!-- Footer Widget Start -->
                            <div class="footer-widget">
                                {{-- <a class="footer-logo text-center" href="{{URL::to('/')}}" >
                                    <img src="{{URL::to('/')}}/new_site/images/logo-white.png" alt="Logo">
                                </a> --}}
                              
                                <h3 class="footer-widget-title" style="font-size: 18px;"> {{$setting->name}}  </h3>
                                <br>
                                <h6 style="text-align:justify !important;    font-weight: 400;color: #c4c5c7;">
                                    {{$setting->description}}
                                </h6>
                            </div>
                            <!-- Footer Widget End -->
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <!-- Footer Widget Start -->
                            <div class="footer-widget">
                                <h4 class="footer-widget-title"> معلومات هامة </h4>

                                <div class="widget-link">
                                    <ul class="link">
                                        <li><a href="{{URL::to('/')}}/aboutus"> من نحن </a></li>
                                        <li><a href="{{URL::to('/')}}/goals_and_vision"> اهداف ورؤية</a></li>
                                        <li><a href="{{URL::to('/')}}/terms_and_conditions"> شروط واحكام </a></li>
                                        <li><a href="{{URL::to('/')}}/work_policy">  سياسة العمل </a></li>
                                        <li><a href="{{URL::to('/')}}/privacy">  سياسة الاستخدام </a></li>

                                    </ul>
                                </div>
                            </div>
                            <!-- Footer Widget End -->
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <!-- Footer Widget Start -->
                            <div class="footer-widget">
                                <h4 class="footer-widget-title"> اخرى  </h4>

                                <div class="widget-link">
                                    <ul class="link">
                                        <li><a href="{{URL::to('/')}}/contactus">  اتصل بنا  </a></li>

                                        <li><a href="{{URL::to('/')}}/suggestions_and_ideas"> اقتراحات و أفكار </a></li>
                                        <li><a href="{{URL::to('/')}}/research_letters_and_papers">دراسات و اوراق بحثية  </a></li>
                                       
                                    </ul>
                                </div>
                            </div>
                            <!-- Footer Widget End -->
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <!-- Footer Widget Start -->
                            <div class="footer-widget">
                                <h4 class="footer-widget-title">تواصل معنا</h4>
                                <div class="widget-info">
                                    <ul>
                                        <li>
                                            <div class="info-icon">
                                                <i class="flaticon-phone-call"></i>
                                            </div>
                                            <div class="info-text">
                                                <span><a href="tel:{{$setting->mobile}}">{{$setting->mobile}}</a></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="info-icon">
                                                <i class="far fa-envelope-open"></i>
                                            </div>
                                            <div class="info-text">
                                                <span><a href="{{$setting->email}}">{{$setting->email}}</a></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="info-icon">
                                                <i class="flaticon-pin"></i>
                                            </div>
                                            <div class="info-text">
                                                <span>{{$setting->title}}</span>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <!-- Footer Widget End -->
                        </div>
                    </div>
                </div>
                <!-- Footer Widget Wrap End -->
            </div>

            <!-- Footer Copyright Start -->
            <div class="footer-copyright-area">
                <div class="container">
                    <div class="footer-copyright-wrap">
                        <div class="row align-items-center">
                            <div class="col-lg-4 col-md-6  text-center">
                                <!-- Footer Copyright Text Start -->
                                <div class="copyright-text">
                                    <p>  جميع الحقوق محفوظة ل<span>   {{$setting->name}} 	</span> </p>
                                </div>
                                <!-- Footer Copyright Text End -->
                            </div>
                            <div class="col-lg-5 col-md-6  text-center">
                                <!-- Footer Copyright Social Start -->
                                <div class="copyright-social">
                                    <ul class="social text-center">
                                        @foreach($socials as $social)
                                            <li>
                                                <a href="{{$social->url}}"  target="_blank" ><i class="fab {{$social->social}}" ></i></a>
                                            </li>
                                         @endforeach
             
                                        {{-- <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                        <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                                        <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li> --}}
                                    </ul>
                                </div>
                                <!-- Footer Copyright Social End -->
                            </div>
                            <div class="col-lg-3 col-md-6 text-center">
                                <!-- Footer Copyright Text Start -->
                                <div class="copyright-text">
                                    <p>  <a href="https://high-five.co/" style="color: #9f9e9e;" target="_blank" rel="noopener noreferrer"> برمجة و تطوير  <img alt="" src="{{URL::to('/')}}/site/images/highfive.png" style="width: 20px;"><span> هاي فايف </span> </a> </p>
                                </div>
                                <!-- Footer Copyright Text End -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Footer Copyright End -->
        </div>
        <!-- Footer Section End -->

        <!-- back to top start -->
        <div class="progress-wrap">
            <svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
                <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"></path>
            </svg>
        </div>
        <!-- back to top end -->

      
    </div>

    <!-- JS
    ============================================ -->
    <script src="{{URL::to('/')}}/new_site/js/vendor/jquery-1.12.4.min.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/vendor/modernizr-3.11.2.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="{{URL::to('/')}}/new_site/js/plugins/popper.min.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/plugins/bootstrap.min.js"></script>

    <!-- Plugins JS -->
    <script src="{{URL::to('/')}}/new_site/js/plugins/swiper-bundle.min.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/plugins/aos.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/plugins/waypoints.min.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/plugins/back-to-top.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/plugins/jquery.counterup.min.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/plugins/appear.min.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/plugins/jquery.magnific-popup.min.js"></script>
    <script src="{{URL::to('/')}}/new_site/js/jquery.fancybox.min.js"></script>
    <script src='{{URL::to('/')}}/new_site/js/sweetalert.js'></script>


    <!--====== Use the minified version files listed below for better performance and remove the files listed above ======-->


    <!-- Main JS -->
    <script src="{{URL::to('/')}}/new_site/js/main.js"></script>

    <script>

           $('#search').on('submit', function(e){
                var search = $('#search .search').val();
                if(search == ''){
                e.preventDefault();
                return false;
                }
            })


            
    </script>

    @yield('js')


</body>

</html>