@extends('site.layout.layout')
@section('url'){{URL::to('/')}}/{{App::getLocale()}}/posts/{{$data['posts']->id}}@stop
@section('title')
@if($data['posts']->socil_images_title){{\App\Http\Helpers\Helpers::stringReplace($data['posts']->socil_images_title,3)}}@else{{\App\Http\Helpers\Helpers::stringReplace($data['posts']->title,3)}}@endif
@stop
@section('posts')<meta property="og:image:width" content="507" />
<meta property="og:image:height" content="330" />@stop
@section('image')@if($data['posts']->socil_images){{URL::to('/')}}/img/808x550/{{$data['posts']->socil_images}}@else{{URL::to('/')}}/img/808x550/{{$data['posts']->main_image}}@endif @stop
@section('description')@if($data['posts']->summarysocil_images){{\App\Http\Helpers\Helpers::stringReplace($data['posts']->summarysocil_images,3)}}@else{{\App\Http\Helpers\Helpers::stringReplace($data['posts']->summary,3)}}@endif @stop

@section('css')

@endsection
@section('content')

<section class="page-title">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <h2>{{$data['posts']->category_name}} </h2>
                <ol class="breadcrumb">
                    <li class="">{{$data['posts']->title}} </li>
                    <li class="float-right"><a href="{{URL::to('/')}}/{{App::getLocale()}}}">{{ __('app.home') }}</a></li>
                </ol>
            </div>
        </div> 
    </div> 
</section>   

<section class="blog-single section-padding"  style="padding: 30px 0;
"> 
    <div class="container">
        <div class="row">
            <div class="col col-lg-8 col-md-9 blog-single-content">
                <div class="post" style="padding-bottom: 5px">
                    <div class="media">
                        {{-- <img src="{{URL::to('/')}}/img/750x400/{{$data['posts']->main_image}}" alt="{{\App\Http\Helpers\Helpers::stringReplace($data['posts']->description_image,3)}}" class="img img-responsive"> --}}
                        <img src="{{URL::to('/')}}/uploads/{{$data['posts']->main_image}}" style="width: 100%;height: 400px;" alt="{{\App\Http\Helpers\Helpers::stringReplace($data['posts']->description_image,3)}}" class="img img-responsive">
                    </div>
                    <div class="post-title-meta">
                        {{-- <button class="btn">Construction</button> --}}
                        <h2>{{$data['posts']->title}}</h2>
                        <ul>
                            <li><span class="date"><span>{{date('d',strtotime($data['posts']->date))}}</span>{{\App\Http\Helpers\Helpers::get_month_name(date('M',strtotime($data['posts']->date)))}} </span></li>
                        </ul>
                    </div>
                    <div class="post-body">

                        {!! $data['posts']->details !!}
                    </div>
                    <div class="gallery-post">
                        <div class="gallery">
                            
                            @foreach ($data['posts']['images'] as $item)
                                <div>
                                    <a data-caption="{{$item->title}}" data-fancybox="gallery{{$item->id}}" href="{{URL::to('/')}}/uploads/{{$item->image}}">

                                        <img src="{{URL::to('/')}}/uploads/{{$item->image}}"  alt="{{ $item->title }}" class="img img-responsive">
                                    </a>
                                </div>
                            @endforeach
                            
                        
                        </div>
                    </div>
                    <div class="tag-share">
                        <div class="float-left">
                            <span>{{ __('app.share') }} : </span>
                            <ul class="share">
                                <li>
                                    <a class="share-facebook" href="https://www.facebook.com/sharer?app_id=3168417600050631&amp;u={{URL::to('/')}}/{{App::getLocale()}}/posts/{{$data['posts']->id}}&amp;picture={{URL::to('/')}}/uploads/{{$data['posts']->main_image}}&amp;redirect_uri={{URL::to('/')}}/{{App::getLocale()}}&amp;display=popup"  onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=500,width=500');return false;">
                                        <i class="fa fa-facebook-f"></i>
                                    </a>
                                </li>
                                <li>
                                    <a class="share-twitter" href="https://twitter.com/share?url={{URL::to('/')}}/{{App::getLocale()}}/posts/{{$data['posts']->id}}&amp;hashtags=GazaCDG" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=500,width=500');return false;">
                                        <i class="fa fa-twitter"></i>
                                    </a>
                                </li>
                                <li>
                                    <a class="share-twitter" href="https://t.me/share/url?url={{URL::to('/')}}/{{App::getLocale()}}/posts/{{$data['posts']->id}}&text={{$data['posts']->title}}" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=500,width=500');return false;">
                                        <i class="fa fa-location-arrow"></i>
                                    </a>
                                </li>
                                <li>
                                    <a class="share-twitter" href="whatsapp://send?text={{$data['posts']->title}}:: {{URL::to('/')}}/{{App::getLocale()}}/posts/{{$data['posts']->id}}" data-action="share/whatsapp/share"  style="background-color: #3bb367" >
                                        <i class="fa fa-whatsapp"></i> 
                                    </a>
                                </li>
                                
                            </ul>
                        </div>
                    </div>
                </div> <!-- end post -->

                <div class="tag-share" style="padding: 20px 0;">
                    <div>
                        
                        <span>{{ __('app.tag') }} : </span>
                        <ul class="tag">
                            @foreach ($data['posts']['tags'] as $item)
                                <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/tags/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->name,2)}}">#{{ $item->name }}</a></li>
                            @endforeach
                        </ul>
                    </div>

                </div>

             
            </div> <!-- end blog-content -->

            <div class="blog-sidebar col col-lg-4  col-md-3 col-sm-5">
                <div class="widget recent-post-widget">
                    <h3>{{ __('app.most_read') }}   </h3>
                    <ul>
                        @foreach ($data['reads'] as $item)
                                            
                        {{-- <li>
                            <a class="post-link" href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                <div class="post-thumb">
                                    <img src="{{URL::to('/')}}/uploads/{{$item->main_image}}" alt="{{$item->title}}">
                                </div>
                                <div class="post-text">
                                    <h4 class="title"> {{\App\Http\Helpers\Helpers::cutText($item->title,50,true)}}</h4>
                                    <span class="post-meta"><i class="far fa-calendar-alt"></i> {{\App\Http\Helpers\Helpers::dateFormat($item->date,false)}}</span>
                                </div>
                            </li> --}}
                        <li>
                            <a class="post-link" href="{{URL::to('/')}}/{{App::getLocale()}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                <div class="post-pic">
                                    <img src="{{URL::to('/')}}/uploads/{{$item->main_image}}" style="height: 98px;" alt="{{$item->title}}">
                                </div>
                                <div class="details">
                                    <h4 class="title"> {{\App\Http\Helpers\Helpers::cutText($item->title,50,true)}}</h4>
                                    <span class="post-meta"><i class="far fa-calendar-alt"></i> {{\App\Http\Helpers\Helpers::dateFormat($item->date,false)}}</span>
                                </div>
                            </a>
                        </li>
                    @endforeach
                        {{-- <li>
                            <div class="post-pic">
                                <img src="assets/images/blog/thumb/img-2.jpg" alt>
                            </div>
                            <div class="details">
                                <h4><a href="#">Integer suscipit sit amet</a></h4>
                                <span>Sep 25, 2016</span>
                            </div>
                        </li>
                        <li>
                            <div class="post-pic">
                                <img src="assets/images/blog/thumb/img-3.jpg" alt>
                            </div>
                            <div class="details">
                                <h4><a href="#">Praeent vehicula neget tempus</a></h4>
                                <span>Sep 25, 2016</span>
                            </div>
                        </li> --}}
                    </ul>
                </div>
               
               
            </div>                    
        </div>
    </div> <!-- end container -->
</section>





@endsection

@section('js')
   
@endsection

