@extends('site.layout.layout')
@section('url'){{URL::to('/')}}/search @stop
@section('title')  بحث @stop
@section('image')@stop
@section('css')
@endsection
@section('content')

@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/{{App::getLocale()}}/search @stop
@section('title'){{$search}} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($search,3)}} @stop

@section('css')
<style>

</style>
@endsection
@section('content')
<section class="page-title">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <h2>{{ __('app.search') }}</h2>
                <ol class="breadcrumb">
                    <li class="">{{trans('lang.research_results')}} : {{$search}} </li>
                    <li class="float-right"><a href="{{URL::to('/')}}/{{App::getLocale()}}">{{ __('app.home') }}</a></li>
                </ol>
            </div>
        </div> 
    </div> 
</section>   

<section class="section-padding"  style="padding: 30px 0;">
    <div class="container">
        @if(isset($data['posts']) && count($data['posts']) > 0)
        <div class="row service-s2-box">
            <div class="col col-xs-12">
                <div class="service-s2-box-grids row">
                    @foreach ($data['posts']->where('id','!=',null) as $item)
                        <a  @if($item->post_type == 1) 
                                href="{{URL::to('/')}}/{{App::getLocale()}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}"
                            @elseif($item->post_type == 2) 
                                href="{{URL::to('/')}}/{{App::getLocale()}}/cours/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}"

                            @endif
                            >
                            <div class="grid col-md-4 col-xs-12 float-right">
                                <div class="inner" style="min-height: 261px;">
                                    <h3>
                                        <span class="num"> 
                                            @if($item->post_type == 1)
                                            {{ __('app.posts') }}
                                            @elseif($item->post_type == 2) 
                                            {{ __('app.courses') }}  
                                            @endif
                                        </span>
                                    </h3>
                                    <p style="text-align: right; direction: rtl;">
                                        تحميل برنامج (TubeMate) عملاق التحميل من اليوتيوب لنظام التشغيل ويندوز
                                    </p>
                                </div>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
        @else 
            <div class="row">
                <div class="col-lg-12 col-md-12 text-center">
                    <h3 class="title ">
                        
                           لا يوجد نتائج لعرضها 
                       
                    </h3>
                </div>
            </div>
            @endif
    </div>
    <!-- end container -->
</section>








@endsection

@section('js')
  
@endsection