<?php

declare(strict_types=1);

namespace Kreait\Firebase\Messaging;

final class RawMessageFromArray implements Message
{
    /** @var array<mixed> */
    private $data;

    /**
     * @param array<mixed> $data
     */
    public function __construct(array $data)
    {
        $this->data = $data;
    }

    /**
     * @return array<mixed>
     */
    public function jsonSerialize(): array
    {
        return $this->data;
    }
}
