<?php

namespace App\Http\Controllers\Admin;

use App\Models\Client as MyModel;
use App\Models\Client;
use App\Models\Favorites;
use App\Models\MyCourses;
use App\Models\Order;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use App\Models\User_Permission;
use App\Models\System_Constants;
use DB;

class ClientController extends AdminController
{
	public function __construct()
	{
		parent::__construct();
	}
	public function index(Request $request)
	{
		$name  = $request->get('name');
		$mobile  = $request->get('mobile');
		$governorate  = $request->get('governorate');
		$city  = $request->get('city');
		$Degree  = $request->get('Degree');




		$clients = new MyModel();
		$data['clients'] = $clients->get_clients($name, $mobile, $governorate, $city, $Degree);
		$system = new System_Constants();
		$data['governorate'] = $system->constants('governorate');
		$data['Degree'] = $system->constants('Degree');
		$data['city'] = $system->constants('city');

		if ($request->ajax()) {
			return view('admin.clients.table-data', compact('data'))->render();
		}
		return view('admin.clients.index', compact('data'));
	}
	/***********************************************************************************************************************/
	public function add(Request $request)
	{
		$clients = new MyModel();

		$hidden = $request->get('hidden');
		if ($hidden == 0) {
			$name			=	$request->get('name');
			$email			=	$request->get('email');
			$mobile			=	$request->get('mobile');
			$password		=	$request->get('password');
			$state_key		=	$request->get('state_key');




			if (isset($request['activeValue'])) {
				$status = 1;
			} else {
				$status = 0;
			}

			$rules = [
				'name'			=>	'required',
				'email'			=>	'required|email',
				'mobile'			=>	'required|numeric',
				'password'		=>	'required',
			];
			$messages = [
				'name.required' => 'الإسم مطلوب',
				'email.required' => 'البريد الإلكتروني مطلوب',
				'email.email' => ' يرجى التاكد من صيغة البريد الالكتروني ',
				'password.required' => ' كلمة المرور مطلوبه',
				'mobile.required' => ' رقم الجوال مطلوب',

			];

			$validator = \Validator::make(
				[
					'name'		=>	$name,
					'email'		=>	$email,
					'mobile'		=>	$mobile,
					'password'	=>	$password,
				],
				$rules,
				$messages
			);

			if ($validator->fails()) {
				return response()->json(['status' => false, 'message' => $validator->errors(), 'data' => $validator->errors()->first()]);
			}
			if ($mobile != '') {
				$users_count = Client::where('mobile', $mobile)->count();
				if ($users_count > 0) {
					return response()->json(['status' => false, 'data' => '  رقم الجوال مستخدم من قبل']);
				}
			}
			if ($email != '') {
				$users_count = Client::where('email', $email)->count();
				if ($users_count > 0) {
					return response()->json(['status' => false, 'data' => ' البريد الإلكتروني مستخدم من قبل']);
				}
			}

			$saved = $clients->add_client($name, $email, $password, $status, $mobile, $state_key);
			if (!$saved) {
				return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
			}
			return response()->json(['status' => true, 'data' => 'تمت عملية الإضافة']);
		} else {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}
	}
	/***********************************************************************************************************************/
	public function edit(Request $request)
	{
		$id = $request->get('id');
		$clients = new MyModel();
		$item =  $clients->get_client($id);
		if ($item != '') {
			return response()->json(['status' => true, 'data' => $item]);
		} else {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}
	}

	/***********************************************************************************************************************/

	public function UpdateStats(Request $request)
	{
		$id = $request->get('id');
		// if($id == 1){
		// 	return response()->json(['status' => false , 'data' => 'لا يمكن تعديل حالة الأدمن']);
		// }
		$clients = new MyModel();
		$item =  $clients->get_client($id);
		if ($item != '') {
			$saved = $clients->update_status($item);
			if (!$saved) {
				return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
			}
			return response()->json(['status' => true, 'data' => 'تمت عملية التعديل']);
		} else {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}
	}

	/***********************************************************************************************************************/

	public function update(Request $request)
	{
		$hidden = $request->get('hidden');
		if (!MyModel::where('id', $hidden)->count()) {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}

		$name			=	$request->get('name');
		$email			=	$request->get('email');
		$mobile		=	$request->get('mobile');

		$state_key		=	$request->get('state_key');
		$password		=	$request->get('password');

		if (isset($request['activeValue'])) {
			$status = 1;
		} else {
			$status = 0;
		}

		$rules = [
			'name'			=>	'required',
			'email'			=>	'required|email',
			'mobile'			=>	'required|numeric',
			// 'password'		=>	'required',
		];
		$messages = [
			'name.required' => 'الإسم مطلوب',
			'email.required' => 'البريد الإلكتروني مطلوب',
			'email.email' => ' يرجى التاكد من صيغة البريد الالكتروني ',
			'mobile.required' => ' رقم الجوال مطلوب',

		];

		$validator = \Validator::make(
			[
				'name'		=>	$name,
				'email'		=>	$email,
				'mobile'		=>	$mobile,
				// 'password'	=>	$password,
			],
			$rules,
			$messages
		);
		if ($validator->fails()) {
			return response()->json(['status' => false, 'message' => $validator->errors(), 'data' => $validator->errors()->first()]);
		}

		if ($email != '') {
			$users_count = Client::where('email', $email)->where('id', '!=', $hidden)->count();
			if ($users_count > 0) {
				return response()->json(['status' => false, 'data' => ' البريد الإلكتروني مستخدم من قبل']);
			}
		}

		if ($mobile != '') {
			$users_count = Client::where('mobile', $mobile)->where('id', '!=', $hidden)->count();
			if ($users_count > 0) {
				return response()->json(['status' => false, 'data' => 'رقم الجوال مستخدم من قبل']);
			}
		}

		$clients = new MyModel();
		$item =  $clients->get_client($hidden);
		$saved = $clients->update_client($item, $name, $email, $password, $status, $mobile, $state_key);
		if (!$saved) {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}
		return response()->json(['status' => true, 'data' => 'تمت عملية التعديل']);
	}
	/****************************************************************************************************************************************** */
	public function delete(Request $request)
	{
		$id = $request->get('id');
		$clients = new MyModel();
		$item =  $clients->get_client($id);
		if ($item != '') {

			$order = Order::where('client_id', $id)->get();
			if (count($order) > 0) {
				return response()->json(['status' => false, 'data' => ' لا يمكن حذف العميل لوجود له طلبيات ']);
			}

			$deleted = $clients->delete_client($item);
			if (!$deleted) {
				return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
			}
			return response()->json(['status' => true, 'data' => 'تمت عملية الحذف']);
		} else {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}
	}
	/****************************************************************************************************************************************** */
	public function changepassword(Request $request)
	{
		$hidden = $request->get('hidden');
		$password = $request->get('password');
		$confirmation_password = $request->get('confirmation_password');

		if ($password == '' or $confirmation_password == '') {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}

		$clients = new MyModel();
		$item =  $clients->get_client($hidden);
		if ($item != '') {
			if ($password === $confirmation_password) {
				$saved = $clients->change_password($item, $password);
				$saved = $item->save();
				if (!$saved) {
					return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
				}
				return response()->json(['status' => true, 'data' => 'تمت عملية تعديل كلمة المرور']);
			} else {
				return response()->json(['status' => false, 'data' => 'نأكيد كلمة المرور غير متطابقة مع كلمة المرور']);
			}
		} else {
			return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
		}
	}

	public function showfavorite(Request $request)
	{
		$id  = $request->get('id');
		$clint = new MyModel;
		// $data['clints']=$clint->getname($id);
		$data['favorites'] = MyCourses::leftJoin('courses as t', 'my_courses.courses_id', '=', 't.id')->where('my_courses.client_id', $id)->where('my_courses.deleted_at', null)
			->select("t.title as name_car")->get();

		$view = view('admin.clients.table-favorite', compact('data'))->render();

		return response()->json(['status' => true, 'data' => $view]);
	}
}
