<?php



namespace App\Providers;



use Illuminate\Support\ServiceProvider;

use Illuminate\Support\Facades\Schema;

use Illuminate\Support\Facades\View;



class AppServiceProvider extends ServiceProvider

{

    /**

     * Register any application services.

     *

     * @return void

     */

    public function register()

    {

        //

    }



    /**

     * Bootstrap any application services.

     *

     * @return void

     */

    public function boot()

    {
        Schema::defaultStringLength(191);
        \View::composer('site.layout.layout', function ($view) {
            $view->with('social_links', \App\Models\Social::where('status', 1)->get(['url', 'social']));
        });
        View::composer('site.layout.layout', function ($view) {
            $lang = \App::getLocale();
            $view->with('settings', \App\Models\Setting::where('id', 1)->first(["name_$lang as name", 'email', 'mobile', "description_$lang as description", "key_words_$lang as key_words"]));
        });
    }
}
