@extends('admin.layout.master_layout')
@section('title')
   لوحة التحكم
@stop

@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/admin/contact" class="m-nav__link">
                            <span class="m-nav__link-text">اتصل بنا</span>
                        </a>
                    </li>
                </ul>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">


            <div class="">
                
                <div class="form-group m-form__group row">
                    <div class="col-md-3">
                        <input type="text" name="user_name_seach"  class="form-control user_name_seach" placeholder="اسم المرسل">
                    </div>
                </div>

                <div id="table-container">

                    @include('admin.contact.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>


<div class="modal  fade in" role="dialog" id="message_modal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">رسائل اتصل بنا</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>

      <!-- Modal body -->
      <div class="modal-body message">
            <div class="form-group">
                <input type="text" disabled value="" class="form-control name" id="name">
            </div>
            <div class="form-group">
                <input type="text" disabled value="" class="form-control email">
            </div>
            <div class="form-group">
                <input type="text" disabled value="" class="form-control mobile">
            </div>
            <div class="form-group">
                <textarea disabled   rows="5" class="form-control details"></textarea>
            </div>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button"  class="btn btn-danger" data-dismiss="modal">إخفاء</button>
      </div>

    </div>
  </div>
</div>

<div class="modal fade in" role="dialog" id="reply_modal">
  <div class="modal-dialog">
     <form action="" method="post" id="reply_form">
            <div class="modal-content">
            @csrf
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">إرسال رد ل <b><span class="sender_name"></span></b></h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="modal-body reply">
                    <div class="form-group">
                        <label for="">الرد</label>
                        <textarea type="text"  value="" name="response" rows="5" class="form-control response"></textarea>
                    </div>
            </div>
            <!-- Modal footer -->
            <div class="modal-footer">
                 <button type="submit"  class="btn btn-primary">إرسال</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">إخفاء</button>
            </div>
            <input type="hidden" class="sender_id" name="sender_id">
            <div id="loading">
                <img id="loading-image" src="/admin/assets/ajax-loader.gif" alt="Loading..."/>
            </div>
            </div>
    </form>
  </div>
</div>



@stop

@section('js')
<script type="text/javascript">
/****************************************************************************** */

$('.user_name_seach').on('input',function(e){
    name =  $('.user_name_seach').val();
    var url = $(this).attr('href');
    getData(url,name);
});

/***********************************************************************************************************************/
        $('body').on('click','.UpdateStats',function(){
            $(this).addClass('disabled');
            $('.loadImg').removeClass('hidden');
            $('.loadMSG').html('جاري تحديث الحالة');
            var thisTag = $(this);
            var id = $(this).data('id');
			$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
            	url: "/admin/events/UpdateStats",
                type: "POST",
                dataType: "JSON",
                data:{id:id},
                success: function(data) {
                    if(data["status"] == true){
						var url = $(this).attr('href');
						getData(url);
                    }
                }
            });
            $(thisTag).removeClass('disabled');
            $('.loadImg').addClass('hidden');
        });
</script>

<script>
$(document).on('click', '.pagination a',function(event)
        {
            event.preventDefault();
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
            var url = $(this).attr('href');
            getData(url);
        });
  
    function getData(url,name) {
        $.ajax({
            url : url,
            data:{name:name}
        }).done(function (data) {
            $("#table-container").empty().html(data);
        });
    }
</script>
<script>
    $(document).on('click','.show_message',function(e){
        e.preventDefault();
        var id = $(this).data('id');
        $.ajax({
            	url: "/admin/contact/view",
                type: "get",
                dataType: "JSON",
                data:{id:id},
                success: function(data) {
                    if(data["status"] == true){
                        $('.name').val(data['data']['name']);
                        $('.email').val(data['data']['email']);
                        $('.mobile').val(data['data']['mobile']);
                        $('.details').val(data['data']['details']);
                        name =  $('.user_name_seach').val();
                        var url = $(this).attr('href');
                        getData(url,name);
                    }
                },
                complete:function(){
                    $('#message_modal').modal('show');
                }
            });
    });

    $(document).on('click','.send_message',function(e){
        $('.sender_id').val(0);
        e.preventDefault();
        var id = $(this).data('id');
        $('.sender_id').val(id);
        $.ajax({
            	url: "/admin/contact/view",
                type: "get",
                dataType: "JSON",
                data:{id:id},
                success: function(data) {
                    if(data["status"] == true){
                        $('.sender_name').html(data['data']['name']);
                    }
                },
                complete:function(){
                    $('#reply_modal').modal('show');
                }
            });
    });

    $('#reply_form').on('submit', function(e){
            $('#loading').show();
            e.preventDefault();
			var formData = new FormData(this);
                $.ajax({
                    url: "/admin/contact/reply_view",
                    type: "post",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        $('#loading').hide();
                        if (data["status"] == true) {
                                Swal.fire(
                                data['message'],
                                '',
                                'success'
                                )
                                $('#reply_form').find('textarea').val('');
                                $('.sender_id').val(0);
                                var url = $(this).attr('href');
                                getData(url,name);
                                $('#reply_modal').modal('hide');
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: 'عذرا',
                                text: data['message']
                            })
                        }
                    }
                   
                });
            });
</script>
@stop