@extends('site.layout.layout')
@section('url'){{URL::to('/')}}/{{App::getLocale()}}/courses @stop
@section('title'){{$data['static']->title}} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['static']->details,3)}} @stop

@section('css')
<style>

</style>
@endsection
@section('content')
<section class="page-title">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <h2>{{$data['static']->title}}</h2>
                <ol class="breadcrumb">
                    <li class="">{{$data['static']->title}}</li>
                    <li class="float-right"><a href="{{URL::to('/')}}/{{App::getLocale()}}}">{{ __('app.home') }}</a></li>
                </ol>
            </div>
        </div> 
    </div> 
</section>   
<section class="section-padding academy_courses" style="background-color: #fff;padding: 30px 0;" >
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <div class="row service-s2-top">
                    @foreach ($data['courses'] as $item)
                        <div class="col col-md-6 col-xs-12 service-s2-tab">
                            <div class="tab-pane " id="tab-1" style="background-color: #f5f5f5;">
                                <div class="img-holder">
                                    <img src="{{URL::to('/')}}/uploads/{{$item->image}}" alt="">
                                    {{-- <img src="{{URL::to('/')}}/img/546x450/{{$item->image}}" alt=""> --}}
                                </div>
                                <div class="details">
                                    {{-- <span id="cart-rating">4.8 <i class="fa fa-star"></i></span> --}}
                                    @if($item->category)
                                        @if (\App::getLocale() == 'ar')
                                        <h4> {{$item->category->name_ar}}</h4>
                                        @else
                                        <h4> {{$item->category->name_en}}</h4>
                                        @endif
                                    @endif
                                    <h3 style="  font-weight: 400;"> {{$item->title}}</h3>
                                    <p style="margin-bottom: 40px; color: #9c9c9c;min-height: 81px;">
                                    {!!\App\Http\Helpers\Helpers::cutText($item->details,200,true)!!}
                                    </p>
                                    <div class="entry-meta">
                                        <ul>
                                            {{-- <li><i class="fa fa-clock-o"></i> 22 {{ __('app.hour') }} و 30 {{ __('app.minute') }} </li> --}}
                                            <li><i class="fa fa-download"></i> {{$item->sales}} {{ __('app.sales') }}</li>
                                        </ul>
                                        
                                        <ul>
                                            <li><i class="fa fa-video-camera"></i> {{$item->videos_count}} {{ __('app.video') }} </li>
                                        </ul>
                                        
                                    </div>
                                    <div class="entry-meta">
                                        <a href="javaScript:;" style="color: #009D57;font-weight: 600;font-size: 13px;">
                                            {{-- <span style="text-decoration: line-through; color: #9c9c9c;">150$</span> --}} {{$item->price}}$
                                        </a>
                                        <a href="{{URL::to('/')}}/{{App::getLocale()}}/cours/{{$item->id}}" class="theme-btn-s7 float-left" style="padding: 3px 7px;font-size: 12px;font-weight: 300;">
                                            {{ __('app.See_More') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div style="text-align: center;">
                    {!! $data['courses']->render() !!}
                </div>
            </div>
        </div>
    </div>
</section>






@endsection
@section('js')
<script>


</script>
@endsection