<!DOCTYPE html>
<html lang="{{ in_array(\App::getLocale(), ['ar', 'en'])? \App::getLocale() : 'ar' }}" @if(\App::getLocale() == 'ar') dir="rtl" @else dir="ltr" @endif >
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        @yield('title')
    </title>
    <meta name="robots" content="ALL, INDEX, FOLLOW" />
    <meta property="og:url" content="@yield('url')" />
    <meta property="og:type" content="article" />
    <meta property="og:title" content="@yield('title')" />
    <meta property="og:description" content="@yield('description')" />
    <meta property="og:image" content="@yield('image')">
    @yield('posts')
    <meta property="og:site_name" content="@yield('title')" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="@yield('title')" />
    <meta name="twitter:site" content="@GazaCDG" />
    <meta name="twitter:creator" content="@GazaCDG" />
    <meta name="twitter:description" content="@yield('description')" />
    <meta name="twitter:image" content="@yield('image')" />
    <meta name="twitter:domain" content="{{URL::to('/')}}/{{App::getLocale()}}" />
    <meta name="twitter:url" content="@yield('url')" />
    <meta name="description" content="@yield('description')" />

    <link rel="sitemap" type="application/xml" title="Sitemap" href="{{URL::to('/')}}/sitemap.xml">
    @if(\App::getLocale() == 'ar')
    <meta name="keywords" content="{{\App\Http\Helpers\Helpers::stringReplace($settings->keywords,3)}}" />
    @else
    <meta name="keywords" content="{{\App\Http\Helpers\Helpers::stringReplace($settings->keywords,3)}}" />
    {{-- <link rel="sitemap" type="application/xml" title="Sitemap" href="{{URL::to('/')}}/sitemapen.xml"> --}}
    @endif

    <meta name="author" content="gcdgroup" />
    <meta name="rating" content="General" />

    {{-- <link rel="apple-touch-icon" sizes="57x57" href="{{URL::to('/')}}/site/images/fav.png">
    <link rel="apple-touch-icon" sizes="72x72"  href="{{URL::to('/')}}/site/images/fav.png">
    <link rel="apple-touch-icon" sizes="114x114"  href="{{URL::to('/')}}/site/images/fav.png">
    <link rel="apple-touch-icon" sizes="144x144" href="{{URL::to('/')}}/site/images/fav.png">
    <link rel="shortcut icon" href="{{URL::to('/')}}/site/images/fav.png">

    <link href="{{URL::to('/')}}/site/css/font-awesome.min.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/flaticon.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/bootstrap.min.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/animate.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/owl.carousel.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/owl.theme.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/slick.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/slick-theme.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/owl.transitions.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/jquery.mCustomScrollbar.min.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/css/style.css?v=1.0.6" rel="stylesheet"> --}}

    <link href="{{URL::to('/')}}/site/assets/images/favicon/apple-touch-icon-57x57.png" rel="apple-touch-icon" sizes="57x57">
    <link href="{{URL::to('/')}}/site/assets/images/favicon/apple-touch-icon-72x72.png" rel="apple-touch-icon" sizes="72x72">
    <link href="{{URL::to('/')}}/site/assets/images/favicon/apple-touch-icon-114x114.png" rel="apple-touch-icon" sizes="114x114">
    <link href="{{URL::to('/')}}/site/assets/images/favicon/apple-touch-icon-144x144.png" rel="apple-touch-icon" sizes="114x114">

    <link href="{{URL::to('/')}}/site/assets/images/favicon/favicon.png" rel="shortcut icon">

    <link href="{{URL::to('/')}}/site/assets/css/font-awesome.min.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/flaticon.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/animate.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/owl.carousel.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/owl.theme.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/slick.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/slick-theme.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/owl.transitions.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/jquery.mCustomScrollbar.min.css" rel="stylesheet">
    <link href="{{URL::to('/')}}/site/assets/css/swiper-bundle.min.css" rel="stylesheet">
    <link rel="stylesheet"href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css"/>
    <link href="{{URL::to('/')}}/site/assets/css/style.css" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @if (\App::getLocale() == 'ar')
    <link href="{{URL::to('/')}}/site/assets/css/style-rtl.css" rel="stylesheet">
    @endif

    @if (\App::getLocale() == 'en')
    <link href="{{URL::to('/')}}/site/assets/css/style-ltr.css" rel="stylesheet">
    @endif


    @yield('css')
</head>
<body>

    <div class="page-wrapper">
        <div class="preloader">
            <div class="preloader-inner">
                <img src="{{URL::to('/')}}/site/assets/images/preloader.png" alt="">
            </div>
        </div>
        <header id="header" class="site-header header-style-4" @if(\App::getLocale() == 'ar') dir="rtl" @else dir="ltr" @endif>
            <div class="topbar topbar-style-2">
                <div class="container">
                    <div class="row">
                    </div>
                </div>
            </div>
            <nav class="navigation navbar navbar-default">
                <div class="container" style=" position: relative;">
                    <div class="navbar-header">
                        <button type="button" class="open-btn">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <div class="site-logo">
                            {{-- <a href="{{URL::to('/')}}/{{App::getLocale()}}" class="img-nav"><img @if(App::getLocale() == 'ar') src="{{URL::to('/')}}/uploads/{{$settings->logo_ar}}" @elseif(App::getLocale() == 'en') src="{{URL::to('/')}}/uploads/{{$settings->logo_en}}"@endif alt=""  style="width:115px;"></a> --}}
                            <a href="{{URL::to('/')}}/{{App::getLocale()}}" class="img-nav"><img src="{{URL::to('/')}}/site/assets/images/logo1.png" alt=""></a>
                            <a href="{{URL::to('/')}}/{{App::getLocale()}}" class="img-nav1"><img src="{{URL::to('/')}}/site/assets/images/logo-nav.png" alt=""></a>
                        </div>
                    </div>
                    <div id="navbar" class="navbar-collapse collapse navbar-right navigation-holder">
                        <button class="close-navbar"><i class="fa fa-close"></i></button>
                        <ul class="nav navbar-nav">
                            @php
                                $url = \URL::to('/')."/".\App::getLocale();
                            @endphp
                    
                            <li>
                                <a href="{{URL::to('/')}}/{{App::getLocale()}}" @if(Request::url() == $url ) class="active" @endif >{{ __('app.home') }}</a>
                            </li>
                            <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/page/aboutus" @if(Request::url() == $url.'/page/aboutus' ) class="active" @endif>{{ __('app.aboutus') }}</a></li>
                            <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/courses" @if(Request::url() == $url.'/courses' ) class="active" @endif>{{ __('app.courses') }}     </a></li>
                            <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/posts" @if(Request::url() == $url.'/posts' ) class="active" @endif>{{ __('app.posts') }}    </a></li>
                            <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/partners" @if(Request::url() == $url.'/partners' ) class="active" @endif>{{ __('app.partners') }}  </a></li>
                            <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/portal" @if(Request::url() == $url.'/portal' or Request::url() == $url.'/profile') class="active" @endif>{{ __('app.portal') }}   </a></li>
                            <li class="my-element" style="padding-left: 15px; margin-left: 15px;">
                                <a href="{{URL::to('/')}}/{{App::getLocale()}}/contact_us" @if(Request::url() == $url.'/contact_us' ) class="active" @endif>  {{ __('app.contact_us') }}</a>
                            </li>
                            <li class="header-search-form-wrapper">
                                {{-- <button class="search-toggle-btn"  style="font-size: 12px;">
                                    <i class="fa fa-search fa-2x" aria-hidden="true"></i>
                                </button> --}}
                                <a class="search-toggle-btn search" href="javaScript:;" style="font-size: 12px;">
                                    <i class="fa fa-search fa-2x" aria-hidden="true"></i>

                                </a>
                                <div class="header-search-form">
                                    <form action="{{URL::to('/')}}/{{App::getLocale()}}/search" method="POST" class=""  id="search">
                                        @csrf
                                        <div>
                                            <input type="text" class="form-control input_search" name="search" placeholder="{{ __('app.search') }}">
                                            <button type="submit"><i class="fa fa-search" style="color: #018f3d;"></i></button>
                                        </div>
                                    </form>
                                </div>
                            </li>
                        </ul>
                    </div>


                </div>
            </nav>
        </header>
  
        <content class="social_a">
           @auth('clients')
            <a href="{{URL::to('/')}}/{{App::getLocale()}}/profile" style="color: #fff;background: #8fc525;">
                <i class="fa fa-user" style="color: #fff" aria-hidden="true"></i> 
            </a>
            @endauth
            @if(App::getLocale() == 'ar')
                <a href="{{URL::to('/')}}/en/language" style="color: #fff;padding-top: 5px;background: #8fc525;">
                    {{trans('lang.en')}} 
                    {{-- <i class="fa fa-globe" aria-hidden="true"></i>  --}}
                </a>
            @elseif(App::getLocale() == 'en')
                <a href="{{URL::to('/')}}/ar/language" style="color: #fff;padding-top: 5px;background: #8fc525;">
                    {{-- <i class="fa fa-globe" aria-hidden="true"></i>  --}}
                    {{trans('lang.ar')}}
                </a>
            @endif
           
            @foreach ($social_links as $item)
                <a href="{{$item->url}}"  target="_blank">
                    @if($item->social == 'fa-telegram') 
                        <img src="{{URL::to('/')}}/site/assets/images/telegram.png" style="width: 30px;margin-right: 9px;margin-left: 5px;" alt=""> 
                    @else 
                        <i class="fa {{$item->social}}" aria-hidden="true"></i> 
                    @endif 
                </a>
            @endforeach
            @auth('clients')
            <a href="{{URL::to('/')}}/{{App::getLocale()}}/logout" style="color: #fff;background: #8fc525;">
                <i class="fa fa-sign-out" style="color: #fff" aria-hidden="true"></i> 
            </a>
            @endauth
            
        </content>
        

        {{-- <form action="{{URL::to('/')}}/{{App::getLocale()}}/search" method="POST" class=""  id="search">
            @csrf
            <div class="search-box float-left">
                <input class="search-txt" name="search" id="" type="text" placeholder="{{ __('app.search') }}">
                <a class="search-btn" href="#" ><i class="fa fa-search" aria-hidden="true"></i></a>
            </div>
        </form> --}}
        {{-- <div class="search-box float-left lang" >
            @if(App::getLocale() == 'ar')
                <a href="{{URL::to('/')}}/en/language" class="search-btn">{{trans('lang.en')}} </a>
            @elseif(App::getLocale() == 'en')
                <a href="{{URL::to('/')}}/ar/language" class="search-btn">{{trans('lang.ar')}}</a>
            @endif
        </div> --}}
        @yield('content')



        <!-- start site-footer -->
        <footer class="site-footer"@if(\App::getLocale() == 'ar') dir="rtl" @else dir="ltr" @endif>
            <div class="upper-footer">
                <div class="container">
                    <div class="row">
                        <div class="col col-md-4 col-sm-6 col-xs-12 float-right" >
                            <div class="widget about-widget">
                                <div class="footer-logo"><img src="{{URL::to('/')}}/site/assets/images/logo1.png" alt=""></div>
                                <p style="color: #9b9b9b;">
                                    {{ $settings->description }}
                                </p>

                            </div>
                        </div>
                        <div class="col col-md-4 col-sm-6 col-xs-12 float-right">
                            <div class="widget quick-links-widget">
                                <h3> {{ __('app.Important_links') }}</h3>
                                <ul style="padding-right: 0px;padding-left: 40px;">
                                    
                                    <li> <a href="{{URL::to('/')}}/{{App::getLocale()}}">{{ __('app.home') }}</a></li>
                                    <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/courses">{{ __('app.courses') }}     </a></li>
                                    <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/partners">{{ __('app.partners') }}  </a></li>
                                    <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/contact_us">  {{ __('app.contact_us') }}</a></li>
                                </ul>
                                <ul style="padding-right: 0px;padding-left: 40px;">
                                    <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/page/aboutus">{{ __('app.aboutus') }}</a></li>
                                    <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/posts">{{ __('app.posts') }}    </a></li>
                                    <li><a href="{{URL::to('/')}}/{{App::getLocale()}}/portal">{{ __('app.portal') }}   </a></li>
                                </ul>
                                {{-- <div class="widget quick-links-widget div_social">
                                    <ul style="width: 100%">
                                        @foreach ($social_links as $item)
                                        <li>
                                            <a href="{{$item->url}}"  target="_blank"> @if($item->social == 'fa-telegram') <img src="{{URL::to('/')}}/site/images/telegram.png" style="width: 30px;margin-right: 9px;margin-left: 5px;" alt=""> @else <i class="fa {{$item->social}}" aria-hidden="true"></i> @endif </a>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div> --}}

                            </div>
                        </div>
                        <div class="col col-md-4 col-sm-6 col-xs-12">
                            <div class="widget service-links-widget">
                                <h3> {{ __('app.Contact_information') }}</h3>
                                <ul class="contact-info">
                                    {{-- <li><i class="fa fa-mobile"></i> 500 500 500 +</li> --}}
                                    @if($settings->mobile)
                                            <li><i class="fa fa-phone"></i> {{$settings->mobile}} +</li>
                                    @endif
                                    @if($settings->email)
                                    <li><i class="fa fa-envelope"></i>{{$settings->email}} </li>
                                    @endif
                                    {{-- <li><i class="fa fa-map-marker"></i>شارع فلسطين - غزة - فلسطين</li> --}}
                                </ul>
                            </div>
                        </div>




                    </div>
                </div>
            </div> <!-- end upper-footer -->
            <div class="copyright-info">
                <div class="container">
                    <p class="float-right">{{ __('app.All_rights_reserved') }}  &copy;<script>document.write(new Date().getFullYear());</script>@if (\App::getLocale() == 'ar')
                        {{$settings->name}}
                        @else
                        {{$settings->name}}
                        @endif </p>
                    <p class="float-left">
                        <a href="https://high-five.co/" target="_blank" rel="noopener noreferrer"> {{ __('app.Programming_development') }}   <img alt="" src="{{URL::to('/')}}/admin/assets/demo/demo6/media/img/logo/favicon.png" style="width: 20px;"> {{ __('app.hft') }} </a>
                    </p>

                </div>
            </div>
        </footer>
        <!-- end site-footer -->
    </div>



    <!-- All JavaScript files ================================================== -->
    <script src="{{URL::to('/')}}/site/assets/js/jquery.min.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/bootstrap.min.js"></script>

    <!-- Plugins for this template -->
    <script src="{{URL::to('/')}}/site/assets/js/jquery-plugin-collection.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/jquery.mCustomScrollbar.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/swiper-bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>

    <script src='{{URL::to('/')}}/site/assets/js/sweetalert.js'></script>

    <!-- Custom script for this template -->
    <script src="{{URL::to('/')}}/site/assets/js/script.js"></script>
    @yield('js')
    <script>
        Fancybox.bind("[data-fancybox]", {
        // Your custom options
        });

        $("#search").submit(function( e ) {
            var search = $('#search .input_search').val();
            if(search == '') {
                return false;
                e.preventDefault();
            }
        });
    </script>

</body>

</html>






