@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/login @stop
@section('title'){{ __('app.login') }} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace(__('app.login'))}} @stop

@section('css')
<style>

ul{
  list-style: none;
  margin: 0;
  padding: 0;
text-align: center;
}

ul.yesno li{
    color: #AAAAAA;
    display: inline-block;
    position: relative;
	margin: 20px 10px;
	box-sizing: border-box;
}

    ul.yesno li input[type=radio]{
		position: absolute;
		visibility: hidden;
	}

    ul.yesno li	input[type=radio]:checked ~ label{
		background-color: #1a2b57;
		color: #FFF;
	}

    ul.yesno li .button {
    display: inline-block;
    position: relative;
    font-weight: bold;
    font-size: 16px;
    z-index: 9;
    cursor: pointer;
    transition: all 0.2s ease;
    background-color: #b6b6ba;
    color: white;
    padding: 10px 40px;
    border-radius: 300px;
    margin: auto;
    border: none;
    text-transform: uppercase;
    letter-spacing: 0.1em;
    font-size: 14px;
}

#recipient .section-head {
	margin-top: 20px;
}
#guest .section-head {
	margin-top: 40px;
}



#recipient, #guest, #submit {
	padding-left: 30px;
	padding-right: 30px;
	overflow: hidden;
	transition: all .2s ease;
	box-sizing: border-box;
}

	.section-head {
		color: lighten(#b6b6ba,8%);
		border-bottom: 1px solid lighten(#b6b6ba,8%);
		margin-bottom: 20px;
		margin-left: -30px;;
		margin-right: -30px;;
		text-transform: uppercase;
		letter-spacing: .1em;
		font-style: normal;
		font-size: 22px;
		font-weight: 900;
	}






</style>
@endsection
@section('content')
<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title">{{ __('app.login') }}</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                        {{-- <span> --}}
                            {{-- <a title="Homepage" href="{{URL::to('/')}}">{{ __('app.home') }}</a> --}}
                        {{-- </span> --}}
                        {{-- <span class="ttm-bread-sep">&nbsp;&gt;&nbsp;</span> --}}
                        {{-- <span class="current">{{$data['static']->title}}</span> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>
<div class="site-main">
    <div class="ttm-row why_choose2-section clearfix">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5">
                    <div class="ttm-tabs tabs-style-01" data-effect="fadeIn">
                        <div>
                            <div class="section-title-white">
                                <h2>{{$data['static']->title}}</h2>
                            </div>   
                            {!! $data['static']->details !!}
                        </div>
                    
                        <!-- content-inner -->
                        <div class="content-inner active">
                            <form  method="post" id="form_login" class="ttm-contactform wrap-form form_login clearfix" method="post" action="">
                                {{ csrf_field() }}
                                <div class="row">
                                    
                                    <div class="col-md-12">
                                        <label>
                                            <span class="text-input with-icon-pos_left">
                                                <i class="fa fa-phone"></i>
                                                <input onkeypress="return isNumberKey(event)" name="mobile" class="mobile" id="mobile" type="number"  maxlength="10" value="" placeholder=" رقم الجوال " required="required">
                                            </span>
                                        </label>
                                    </div>
                                    <div class="col-md-12">
                                        <label>
                                            <span class="text-input with-icon-pos_left" style="margin-bottom: 0px;">
                                                <i class="fa fa-lock"></i>
                                                <input name="password" class="password" id="password" type="password" value="" placeholder=" كلمة المرور " required="required">
                                            </span>
                                        </label>
                                    </div>
                                    
                                    <div class="col-md-12">
                                        <ul class="yesno">
                                            <li>
                                                <input type="radio" id="rsvp-yes" name="type" value="1">
                                                <label for="rsvp-yes" class="button">طالب</label>
                                            </li>
                                            <li>
                                                <input type="radio" id="rsvp-no" name="type" value="2">
                                                <label for="rsvp-no" class="button">مدرب</label>
                                            </li>
                                            <input type="hidden" id="val_type" name="val_type" value="0">
                                        </ul>
                                    </div>
                                    {{--  --}}
                                    <div class="col-md-12 d-none                                                                                                                                                                                                                                                                                                                                                                                                                                                                          " id="dive_code">
                                        <label>
                                            <span class="text-input with-icon-pos_left">
                                                <i class="fa fa-code"></i>
                                                <input name="code" class="code" id="code" type="text" value="" placeholder=" كود التحقق  " >
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <button class="w-100 submit ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-border ttm-btn-color-dark" type="submit"> تسجيل دخول  </button>
                                <div class="submit-btn-wrap text-center" style="padding-top: 10px;">
                                    <a href="{{URL::to('/')}}/registration" style="color: #1a2b57;  font-size: 1.2rem;font-weight: 600;">  {{ __('app.create_new_account') }}</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
        
</div>



@endsection
@section('js')
<script>
        function isNumberKey(evt){
            var charCode = (evt.which) ? evt.which : event.keyCode
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
            return true;
        }
          $(document).on('submit', '#form_login', function (e) {

                e.preventDefault();
                var formData = new FormData(this);
                    $('#preloader').css('display', '');
                    $('#status').css('display', '');
                    $.ajax({
                        url: "{{URL::to('/')}}/login",
                        type: "post",
                        cache:false,
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (data) {
                            $('#preloader').css('display','none');
                            $('#status').css('display','none');
                            if (data["status"] == true) {

                                Swal.fire({
                                    title: "",
                                    text: data.data,
                                    type: "success",
                                    timer: 2000,
                                });

                                if(data["type"] == 1){

                                    setTimeout(function(){
                                        window.location.href = "{{URL::to('/')}}/profile";
                                    }, 1000);
                                }
                                if(data["type"] == 2){
                                    setTimeout(function(){
                                        window.location.href = "{{URL::to('/')}}/profile_trainers";
                                    }, 1000);
                                }
                            } else {

                                if(typeof(data["type"]) != "undefined"  && data["type"] == 2){
                                    Swal.fire({
                                        title: "",
                                        html: data.data,
                                        type: "warning",
                                        showCancelButton: false,
                                        confirmButtonColor: "#DD6B55",
                                        confirmButtonText: '{{__('lang.ok')}}',
                                        cancelButtonText: '{{__('lang.cancel')}}',
                                        closeOnConfirm: true,
                                        closeOnCancel: true
                                    });
                                    // $('#form_login').find('#dive_code').addClass('d-none');
                                    $('#form_login').find('#dive_code').removeClass('d-none');
                                }else{

                                    if(data["data"]){
                                        Swal.fire({
                                            title: "",
                                            html: data.data,
                                            type: "error",
                                            showCancelButton: false,
                                            confirmButtonColor: "#DD6B55",
                                            confirmButtonText: '{{__('lang.ok')}}',
                                            cancelButtonText: '{{__('lang.cancel')}}',
                                            closeOnConfirm: true,
                                            closeOnCancel: true
                                        });
                                        
    
                                    }else{
    
                                        var errorMessage = "";
                                        for (const error in data["data_validator"]) {
                                            if (data["data_validator"].hasOwnProperty(error)) {
                                                errorMessage += '<p>'+data["data_validator"][error]+'</p>';
                                            }
                                        }
                                        Swal.fire({
                                            title: "",
                                            html: errorMessage,
                                            type: "error",
                                            showCancelButton: false,
                                            confirmButtonColor: "#DD6B55",
                                            confirmButtonText: '{{__('lang.ok')}}',
                                            cancelButtonText: '{{__('lang.cancel')}}',
                                            closeOnConfirm: true,
                                            closeOnCancel: true
                                        });
                                    }
                                }

                            }
           
                        }
                    });

    });

        var yes = document.getElementById('rsvp-yes');
        var no = document.getElementById('rsvp-no');

        var rec = document.getElementById('recipient');
        var guest = document.getElementById('guest');
        var submit = document.getElementById('submit');

        var recH = '0px';
        var guestH ='0px';
        var submitH = '0px';

        // rec.style.height = "0px";
        // guest.style.height = "0px";
        // submit.style.height = "0px";

        function isChecked(elem) {
            var checkedElement = elem.id;
            $('#form_login').find('#val_type').val(0);

            if (checkedElement == "rsvp-yes") { 
                // rec.style.height = recH;
                // guest.style.height = guestH;
                // submit.style.height = submitH;
                $('#form_login').find('#val_type').val(1);

                // 
            }
            if (checkedElement == "rsvp-no") { 
                // rec.style.height = recH;
                // guest.style.height = "0";
                // submit.style.height = submitH;
                $('#form_login').find('#val_type').val(2);

            }
        }

        yes.addEventListener("click", function(){
            isChecked(this);
        }, false );
        no.addEventListener("click", function(){
            isChecked(this);
        }, false );
</script>
@endsection