<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Tag as MyModel;
use Illuminate\Http\Request;

class TagController extends Controller
{
    //
    public function __construct()
    {
    }

    public function index(Request $request){

        $name = $request->get('name');

        $tags = New MyModel();
        
        $data['tags'] = $tags->getTag($name);
        
        if ($request->ajax()) {
            return view('admin.tags.table-data', compact('data'))->render();
        }
        return view('admin.tags.index',compact('data'));
    }

    public function UpdateStats(Request $request){
        $id = $request->get('id');
       
        $tag = New MyModel();
        $item =  $tag->gettags($id);
        if($item != ''){
            $saved = $tag->UpdateStatus($item);
            if(!$saved){
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true , 'data' => 'تم تعديل الحالة']);
        }else{
            return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
        }
    }

    public function add_tag(Request $request){
       
        $name = $request->get('name');
        if(isset($request['status'])){
            $status = 1;
        }else{
            $status = 0;
        }

       
            $rules = [
                'name' => 'required',
                              
            ];
    
            $messages = [
                'name.required' => 'اسم الوسم مطلوب',

            ];
    
            $validator = \Validator::make([
                'name' => $name,            
            ],
                $rules
                ,
                $messages
            );
        
        if ($validator->fails()) {
            return response()->json(['status' => false , 'data_validator' => $validator->messages() ]);
        }       

            $tag=MyModel::where('name',$name)->first();

            if($tag){

                return response()->json(['status' => false , 'data' => ' هذا الوسم موجود مسبقا']);

            }
          
            $tag = new MyModel();       
            $saved = $tag->add_tag($name ,$status);
            return response()->json(['status' => true , 'data' => 'تمت العملية بنجاح']);
            
    }

    public function update(Request $request){

        
        $id = $request->get('tags_id');
        $name = $request->get('name');
        if(isset($request['status'])){
            $status = 1;
        }else{
            $status = 0;
        }

            $rules = [
                'name' => 'required',
                              
            ];
    
            $messages = [
                'name.required' => 'اسم الوسم مطلوب',

            ];
    
            $validator = \Validator::make([
                'name' => $name,            
            ],
                $rules
                ,
                $messages
            );

        if ($validator->fails()) {
            return response()->json(['status' => false , 'data_validator' => $validator->messages() ]);
        }

       
        if($id){
            
            $tag=MyModel::where('name',$name)->first();

           

            $tag =MyModel::find($id);      
            $saved = $tag->update_tag($name ,$status);
            return response()->json(['status' => true , 'data' => 'تمت العملية بنجاح']);

            }
         
            return response()->json(['status' => false , 'data' => 'عذرا حدث خطأ أثناء العميلة']);

    }

    public function edit(Request $request){

        $id  = $request->get('id');
        $tag =  new MyModel();
        $item =  $tag->gettags($id);
        if($item){
            return response()->json(['status' => true , 'data' => $item]);
        }
        return response()->json(['status' => false , 'data' => 'عذرا حدث خطأ أثناء العميلة']);
    }

    public function delete(Request $request){

        $id  = $request->get('id');
        $tag =  MyModel::find($id);
        if($tag){
            $deleted = $tag->delete();
            if($deleted){
                return response()->json(['status' => true , 'data' => 'تمت الحذف بنجاح']);
            }
            return response()->json(['status' => false , 'data' => 'عذرا حدث خطأ أثناء العميلة']);
        }
        return response()->json(['status' => false , 'data' => 'عذرا حدث خطأ أثناء العميلة']);
    }



}
