<?php

namespace App\Http\Controllers\Site;

use App\Models\User;
use App\Models\static_page;
use App\Models\Posts;
use App\Models\Tag;
use App\Models\PostsHome;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Models\Messages;
use App\Models\Albums;
use App\Models\Setting;
use Carbon\Carbon;
use App\Mail\ContactUs;
use App\Mail\SendCod;
use App\Models\AbandonedBasket;
use App\Models\Aboutus;
use App\Models\AlbumsImages;
use App\Models\Business;
use App\Models\Client;
use App\Models\HowWork;
use App\Models\OurClients;
use App\Models\Participation;
use App\Models\Plan;
use App\Models\RealEstate;
use App\Models\Service;
use App\Models\Slider;
use App\Models\StaticPage;
use App\Models\System_Constants;
use App\Models\Tmp;
use App\Models\Trainers;
use Facade\FlareClient\Http\Response;
use Illuminate\Support\Facades\Storage;

class LoginController extends BaseController
{
    public function __construct()
    {
        parent::__construct();
    }


    public function change_password($lang = "ar", Request $request)
    {
        // return 123;
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $email = $request->get('email');
        $cod = $request->get('code');
        $return = $request->get('redirct');
        $pass = $request->get('pass');
        if (!$email) {
            return response()->json(['status' => false, 'data' => trans('lang.please_enter_your_email')]);
        }
        if (!$cod) {
            return response()->json(['status' => false, 'data' => trans('lang.verification_code_required')]);
        }
        if (!$pass) {
            return response()->json(['status' => false, 'data' => trans('lang.password_required')]);
        }
        $rules = [
            'email'            =>    'required|email',
            'pass'            =>    'required',

        ];
        $messages = [
            'email.email' => trans('lang.email_email'),
            'pass.email' => trans('lang.password_required'),

        ];
        $validator = \Validator::make(
            [
                'email'        =>    $email,
                'pass'        =>    $pass,

            ],
            $rules,
            $messages
        );

        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => $validator->errors(), 'data' => $validator->errors()->first()]);
        }

        $clients = Client::where('email', $email)->first();
        if ($clients) {
            $cood_send = $clients->coodpassword;
            if ($cood_send == $cod) {
                $clients->password  = \Hash::make($pass);
                $clients->save();

                return response()->json(['status' => true, 'data' => trans('lang.password_changed')]);
            } else {
                return response()->json(['status' => false, 'data' => trans('lang.check_verification_code')]);
            }
        } else {
            return response()->json(['status' => false, 'data' => trans('lang.data_error')]);
        }
    }


    public function login(Request $request)
    {

        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $mobile = $request->get('mobile');
        $password = $request->get('password');
        $type = $request->get('type');
        $code = $request->get('code');


        // return 1234;
        // if (!$email) {
        //     return response()->json(['status' => false, 'data' => trans('lang.please_enter_your_email')]);
        // }
        // if (!$password) {
        //     return response()->json(['status' => false, 'data' => trans('lang.password_required')]);
        // }

        $rules = [
            'mobile'            =>    'required',
            'password'            =>    'required',
            'type'            =>    'required',

        ];
        $messages = [
            'mobile.required' => trans('app.email_required'),
            'password.required' => trans('app.password_required'),
            'type.required' => 'يرجى اختيار النوع طالب أو مدرب',

        ];
        $validator = \Validator::make(
            [
                'mobile'        =>    $mobile,
                'password'        =>    $password,
                'type'        =>    $type,

            ],
            $rules,
            $messages
        );

        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => $validator->errors(), 'data' => $validator->errors()->first()]);
        }

        $field = 'mobile';
        $remember_token = '';

        if ($type == 1) {
            $clients = Client::where('mobile', $mobile)->first();
            if ($clients) {
                if ($clients->status == 1) {
                    // return 123;
                    if ($clients->first_login == 0) {
                        if ($code != null) {
                            if ($clients->code == $code) {
                                $cl[$field] = $clients->mobile;
                                $cl['password'] = $password;
                                if (\Auth::guard('clients')->attempt($cl, $remember_token)) {
                                    $clients->first_login = 1;
                                    $clients->save();
                                    return response()->json(['status' => true, 'type' => $type, 'data' => trans('app.Login_successful')]);
                                } else {
                                    return response()->json(['status' => false, 'data' => trans('app.Error_entered_data')]);
                                }
                            } else {
                                return response()->json(['status' => false, 'data' => 'يرجى التاكد من كود التحقق']);
                            }
                        } else {

                            $cl[$field] = $clients->mobile;
                            $cl['password'] = $password;
                            if (\Auth::guard('clients')->attempt($cl, $remember_token)) {

                                $coodsend = rand(1000, 9999);
                                $clients->code = $coodsend;
                                $clients->save();
                                $msg = '';
                                $msg .= " كود التحقق : ";
                                $msg .= $coodsend;
                                \App\Http\Helpers\Helpers::SendSms($msg, $clients->mobile);
                                \Auth::guard('clients')->logout();
                                return response()->json(['status' => false, 'type' => 2, 'data' => 'تم ارسال كود تحقق على رقم الجوال ']);

                            } else {
                                return response()->json(['status' => false, 'data' => trans('app.Error_entered_data')]);
                            }
                        }
                    } else {
                        $cl[$field] = $clients->mobile;
                        $cl['password'] = $password;
                        if (\Auth::guard('clients')->attempt($cl, $remember_token)) {
                            return response()->json(['status' => true, 'type' => $type, 'data' => trans('app.Login_successful')]);
                        } else {
                            return response()->json(['status' => false, 'data' => trans('app.Error_entered_data')]);
                        }
                    }
                } else {

                    return response()->json(['status' => false, 'data' => trans('app.account_disabled')]);
                }
            } else {
                return response()->json(['status' => false, 'data' => 'رقم الجوال غير متوفر']);
            }
        } elseif ($type == 2) {
            $clients = Trainers::where('mobile', $mobile)->first();
            if ($clients) {
                if ($clients->status == 1) {
                    if ($clients->first_login == 0) {
                        if ($code != null) {
                            if ($clients->code == $code) {
                                $cl[$field] = $clients->mobile;
                                $cl['password'] = $password;
                                if (\Auth::guard('trainers')->attempt($cl, $remember_token)) {
                                    $clients->first_login = 1;
                                    $clients->save();
                                    return response()->json(['status' => true, 'type' => $type, 'data' => trans('app.Login_successful')]);
                                } else {
                                    return response()->json(['status' => false, 'data' => trans('app.Error_entered_data')]);
                                }
                            } else {
                                return response()->json(['status' => false, 'data' => 'يرجى التاكد من كود التحقق']);
                            }
                        } else {

                            $cl[$field] = $clients->mobile;
                            $cl['password'] = $password;
                            if (\Auth::guard('trainers')->attempt($cl, $remember_token)) {

                                $coodsend = rand(1000, 9999);
                                $clients->code = $coodsend;
                                $clients->save();
                                $msg = '';
                                $msg .= " كود التحقق : ";
                                $msg .= $coodsend;
                                \App\Http\Helpers\Helpers::SendSms($msg, $clients->mobile);
                                \Auth::guard('trainers')->logout();
                                return response()->json(['status' => false, 'type' => 2, 'data' => 'تم ارسال كود تحقق على رقم الجوال ']);
                            } else {
                                return response()->json(['status' => false, 'data' => trans('app.Error_entered_data')]);
                            }
                        }
                    } else {
                        $cl[$field] = $clients->mobile;
                        $cl['password'] = $password;
                        if (\Auth::guard('trainers')->attempt($cl, $remember_token)) {
                            return response()->json(['status' => true, 'type' => $type, 'data' => trans('app.Login_successful')]);
                        } else {
                            return response()->json(['status' => false, 'data' => trans('app.Error_entered_data')]);
                        }
                    }
                } else {

                    return response()->json(['status' => false, 'data' => trans('app.account_disabled')]);
                }
            } else {
                return response()->json(['status' => false, 'data' => 'رقم الجوال غير متوفر']);
            }
        }
    }



    public function register($lang = "ar", Request $request)
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $name = $request->get('name');

        $email = $request->get('email');
        $password = $request->get('password');
        $mobile = $request->get('mobile');



        $password_confirmation = $request->get('password_confirmation');
        $gender = $request->get('gender');
        $dob = $request->get('dob');


        $governorate = $request->get('governorate');
        $city = $request->get('city');
        $title = $request->get('title');


        $Degree = $request->get('Degree');
        $Specialization = $request->get('Specialization');

        $form_data = 0;
        // if (!$email) {
        //     return response()->json(['status' => false, 'data' => trans('lang.please_enter_your_email')]);
        // }
        // if (!$password) {
        //     return response()->json(['status' => false, 'data' => trans('lang.password_required')]);
        // }



        $rules = [
            'name'                  =>    'required',
            'email'                 =>    'required|email',
            'mobile'              =>    'required',

            'password'              =>    'required',
            'password_confirmation' =>    'required',
            'gender'                =>    'required',
            'dob'                   =>    'required',
            'governorate'           =>    'required',
            'city'                  =>    'required',
            'title'                 =>    'required',
            'Degree'                =>    'required',
            'Specialization'        =>    'required',



        ];
        $messages = [
            'name.required'                     => trans('app.name_required'),
            'email.email'                       => trans('lang.email_email'),
            'email.required'                    => trans('app.email_required'),
            'mobile.required'                   => trans('app.mobile_required'),
            'password.required'                 => trans('app.password_required'),
            'password_confirmation.required'    => trans('app.password_confirmation_required'),
            'gender.required'                   => trans('app.gender_required'),
            'dob.required'                      => trans('app.dob_required'),
            'governorate.required'              => trans('app.governorate_required'),
            'city.required'                     => trans('app.city_required'),
            'title.required'                    => trans('app.title_required'),
            'Degree.required'                   => trans('app.Degree_required'),
            'Specialization.required'           => trans('app.Specialization_required'),


        ];
        $validator = \Validator::make(
            [
                'name'                  =>    $name,
                'email'                 =>    $email,
                'mobile'                =>    $mobile,
                'password'              =>    $password,
                'password_confirmation' =>    $password_confirmation,
                'gender'                =>    $gender,
                'dob'                   =>    $dob,
                'governorate'           =>    $governorate,
                'city'                  =>    $city,
                'title'                 =>    $title,
                'Degree'                =>    $Degree,
                'Specialization'        =>    $Specialization,


            ],
            $rules,
            $messages
        );

        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => $validator->errors(), 'data' => $validator->errors()->first()]);
        }


        $field = 'email';
        $remember_token = '';

        $clients = Client::where('email', $email)->first();
        if ($clients) {
            return response()->json(['status' => false, 'data' => trans('app.email_address_already')]);
        }

        $clients1 = Client::where('mobile', $mobile)->first();
        if ($clients1) {
            return response()->json(['status' => false, 'data' => trans('app.mobile_already')]);
        }

        if ($password != $password_confirmation) {
            return response()->json(['status' => false, 'data' => trans('lang.password_not_match')]);
        }


        $client = new Client();
        $client->name = $name;
        $client->mobile  = $mobile;
        $client->email = $email;
        $client->password  = \Hash::make($password);
        $client->img = 'profile.png';


        $client->gender = $gender;
        $client->dob = $dob;
        $client->governorate = $governorate;
        $client->city = $city;
        $client->title = $title;
        $client->Degree = $Degree;
        $client->Specialization = $Specialization;

        $client->hide = 0;
        $client->status = 1;
        $saved = $client->save();

        $cl[$field] = $client->email;
        $cl['password'] = $password;
        if (\Auth::guard('clients')->attempt($cl, $remember_token)) {
            return response()->json(['status' => true, 'data' => trans('app.Registration_completed')]);
        }
    }
}


//
