<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Model;

use Illuminate\Support\Facades\Auth;

use Illuminate\Database\Eloquent\SoftDeletes;





class Posts extends Model

{

  use SoftDeletes;

  protected $table = 'posts';

  protected $fillable = [
    'title', 'summary', 'details', 'main_image', 'date', 'date_published', 'posts_id', 'file',

    'description_image', 'lang', 'status',  'user_id', 'category', 'views_no', 'eshari', 'writers', 'socil_images', 'socil_images_title', 'summarysocil_images'
  ];

  protected $appends = ['url', 'details_url'];

  public function getPosts($title, $category, $from, $to, $page, $user_id)
  {

    $data['news'] = $this->leftJoin('users as u', function ($join) {

      $join->on('u.id', '=', 'posts.user_id')->whereNull('u.deleted_at');
    })->leftJoin('system_constants as sy', function ($join) {

      $join->on('sy.value', '=', 'posts.category')->where('sy.type', 'post_category')->whereNull('sy.deleted_at');
    })->leftJoin('system_constants as sys', function ($join) {

      $join->on('sys.value', '=', 'posts.file')->where('sys.type', 'post_file')->whereNull('sys.deleted_at');
    })->leftJoin('system_constants as syst', function ($join) {
      $join->on('syst.value', '=', 'posts.lang')->where('syst.type', 'lang')->whereNull('syst.deleted_at');
    });


    if ($title) {
      $title = str_replace(' ', '%', $title);
      $data['news'] = $data['news']->where('posts.title', 'like', '%' .  $title . '%');
    }

    if ($category) {
      $data['news'] = $data['news']->where('posts.category', $category);
    }

    if ($from) {
      $data['news'] = $data['news']->where('posts.date', '>=', $from);
    }

    if ($to) {
      $data['news'] = $data['news']->where('posts.date', '<=', $to);
    }
    if ($user_id != '') {
      $data['news'] = $data['news']->where('posts.user_id', $user_id);
    }

    return $data['news'] = $data['news']->where('posts_id', '!=', 0)->orderBy('posts.id', 'desc')->select([
      'posts.id', 'posts.title', 'posts.main_image', 'posts.date', 'posts.status', 'u.fullname', 'sy.name_ar as category_name', 'sys.name_ar as file_name', 'syst.value2 as lang', 'views_no'
    ])->paginate(15);
  }


  public function getPostsSite($category = '', $take = '')
  {
    $lang = \App::getLocale();
    if ($lang == 'ar') {
      $lang_id = 1;
    } else if ($lang == 'en') {
      $lang_id = 2;
    } else if ($lang == 'fr') {
      $lang_id = 3;
    } else if ($lang == 'sp') {
      $lang_id = 4;
    }
    $data['news'] = $this->leftJoin('system_constants as sy', function ($join) {
      $join->on('sy.value', '=', 'posts.category')->where('sy.type', 'post_category')->whereNull('sy.deleted_at');
    })->leftJoin('system_constants as sys', function ($join) {
      $join->on('sys.value', '=', 'posts.writers')->where('sys.type', 'writers')->whereNull('sys.deleted_at');
    })->where('posts.status', 1)->where('posts.lang', $lang_id)->where('posts_id', '!=', 0)
      ->select('posts.id as id', 'posts.category', 'sys.name_' . $lang . ' as writers',  'posts.title', 'posts.main_image', 'sy.name_' . $lang . ' as category_name', 'posts.date', 'posts.summary', 'posts.created_at', 'posts.eshari');
    if ($category != '') {
      $data['news'] =  $data['news']->where('category', $category);
    }


    return $data['news'] = $data['news']->orderBy('posts.id', 'desc')->take($take)->get();
  }

  public function add($title)
  {

    $this->title = $title;

    $this->user_id = \Auth::user()->id;

    $this->save();

    return $this;
  }



  public function getpost($id)
  {

    return $this->with('images')->with('tags')->where('id', $id)->first();
  }



  public function update_title($obj, $title)
  {

    $obj->title = $title;

    $obj->save();

    return $obj;
  }



  public function add_post(
    $obj,
    $decs_photo,
    $category,
    $file,
    $date,
    $lang,
    $status,
    $pic,
    $title,
    $summary,
    $details,
    $date_published,
    $max,
    $eshari,
    $writers,
    $socil_images,
    $socil_images_title,
    $summarysocil_images
  ) {

    $obj->title = $title;

    $obj->summary = $summary;

    $obj->details = $details;

    if ($pic) {

      $obj->main_image = $pic;
    }


    $obj->date = $date;

    $obj->description_image = $decs_photo;

    $obj->category = $category;

    $obj->file = $file;

    $obj->lang = $lang;

    $obj->writers = $writers;


    $obj->date_published = $date_published;

    $obj->status = $status;

    $obj->posts_id = $max;

    $obj->eshari = $eshari;

    $obj->socil_images = $socil_images;

    $obj->socil_images_title = $socil_images_title;

    $obj->summarysocil_images = $summarysocil_images;

    $obj->save();

    return $obj;
  }



  public function images()
  {

    return $this->hasMany(PostsImage::class, 'posts_id');
  }



  public function tags()
  {

    return $this->belongsToMany(Tag::class, 'news_tag', 'news_id', 'tag_id');
  }



  public function add_newstag($id, $tag_id)
  {

    $this->post_id = $id;

    $this->tag_id = $tag_id;

    $this->save();

    return $this;
  }



  public function add_tagg($search_tag, $status)
  {

    $this->name = $search_tag;

    $this->status = $status;

    $this->user_id = \Auth::user()->id;

    $this->save();

    return $this;
  }





  public function getImageAttribute($img)
  {
    return asset('uploads/' . $img);
  }



  public function getUrlAttribute()

  {

    return \URL::to('/') . '/' . \App::getLocale() . '/posts/' . $this->id;
  }


  public function getdetailsUrlAttribute()
  {
    return \URL::to('/') . '/api/post-view/' . $this->id;
  }

  //

}
