<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\SoftDeletes;


class PostsHome extends Model
{
    use SoftDeletes;
    protected $table = 'posts_home';
    protected $fillable = ['title','summary','details','main_image','date','date_published','posts_id','file',
                            'description_image','NewsType','lang','status','SlideNews','user_id','category','eshari','writers'];

    public function getPosts(){
        $data['news'] = $this->leftJoin('users as u', function($join) {
            $join->on('u.id', '=', 'posts_home.user_id')->whereNull('u.deleted_at');
          })->leftJoin('system_constants as s', function($join) {
            $join->on('s.value', '=', 'posts_home.NewsType')->where('s.type','post_type')->whereNull('s.deleted_at');
          })->leftJoin('system_constants as sy', function($join) {
            $join->on('sy.value', '=', 'posts_home.category')->where('sy.type','post_category')->whereNull('sy.deleted_at');
          })->leftJoin('system_constants as sys', function($join) {
            $join->on('sys.value', '=', 'posts_home.file')->where('sys.type','post_file')->whereNull('sys.deleted_at');
          });

         return $data['news'] = $data['news']->where('posts_id','!=',0)->select(['posts_home.id','posts_home.title','posts_home.main_image','posts_home.date','posts_home.status','u.fullname','s.name_ar as newstype','sy.name_ar as category_name'
                                                ,'sys.name_ar as file_name'])->paginate(15);
    }

    public function add($title){
        $this->title = $title;
        $this->user_id = \Auth::user()->id;
        $this->save();
        return $this;
    }

    public function getpost($id){
        return $this->where('posts_id',$id)->first();
    }

    public function update_title($obj,$title){
        $obj->title = $title;
        $obj->save();
        return $obj;
    }

    public function update_post($obj,$decs_photo,$category,$file,$date,$newstype,
                                $lang,$status,$pic,$title,$summary,$details,$slidenews,$date_published,$max,$eshari,$writers,$socil_images,$socil_images_title,$summarysocil_images){
        $obj->title = $title;
        $obj->summary = $summary;
        $obj->details = $details;
        if($pic){
            $obj->main_image = $pic;
        }
        $obj->NewsType = $newstype;
        $obj->date = $date;
        $obj->description_image = $decs_photo;
        $obj->category = $category;
        $obj->file = $file;
        $obj->lang = $lang;
        $obj->SlideNews = $slidenews;
        $obj->date_published = $date_published;
        $obj->status = $status;
        $obj->posts_id = $max;
        $obj->writers = $writers;
        $obj->eshari = $eshari;

        $obj->socil_images = $socil_images;
        $obj->socil_images_title = $socil_images_title;
        $obj->summarysocil_images = $summarysocil_images;
        return $obj->save();
    }

    public function add_post($decs_photo,$category,$file,$date,$newstype,
        $lang,$status,$pic,$title,$summary,$details,$slidenews,$date_published,$max,$eshari,$writers,$socil_images,$socil_images_title,$summarysocil_images){
        $this->title = $title;
        $this->summary = $summary;
        $this->details = $details;
        if($pic){
        $this->main_image = $pic;
        }
        $this->NewsType = $newstype;
        $this->date = $date;
        $this->description_image = $decs_photo;
        $this->category = $category;
        $this->file = $file;
        $this->lang = $lang;
        $this->SlideNews = $slidenews;
        $this->date_published = $date_published;
        $this->status = $status;
        $this->posts_id = $max;
        $this->writers = $writers;
        $this->eshari = $eshari;

        $this->socil_images = $socil_images;
        $this->socil_images_title = $socil_images_title;
        $this->summarysocil_images = $summarysocil_images;

        return $this->save();
    }

    public function getPostsSite($category ='',$take=''){

        // $lang = \App::getLocale();
        // if($lang == 'ar'){
        //     $lang_id = 1;
        // }else if($lang == 'en'){
        //     $lang_id = 2;
        // }else if($lang == 'fr'){
        //     $lang_id = 3;
        // }else if($lang == 'sp'){
        //     $lang_id = 4;
        // }
        $data['news'] = $this->leftJoin('system_constants as sy', function($join) {
                            $join->on('sy.value', '=', 'posts_home.category')->where('sy.type','post_category')->whereNull('sy.deleted_at');
                        })->leftJoin('system_constants as sys', function($join) {
                            $join->on('sys.value', '=', 'posts_home.writers')->where('sys.type','writers')->whereNull('sys.deleted_at');
                        })->leftJoin('system_constants as syst', function($join) {
                            $join->on('syst.value', '=', 'posts_home.NewsType')->where('syst.type','post_type')->whereNull('syst.deleted_at');
                        })->where('posts_home.status',1)->where('posts_id','!=',0)
                        ->select('posts_home.category','sys.name_ar as writers','posts_home.posts_id as id','posts_home.title','syst.name_ar as newstype','posts_home.main_image','sy.name_ar as category_name','posts_home.date','posts_home.summary','posts_home.created_at','posts_home.eshari');
                        if($category != ''){
                            $data['news'] =  $data['news']->where('category',$category);
                        }
        return $data['news'] = $data['news']->orderBy('posts_home.id','desc')->take($take)->get();
    }

}   