<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class System_Constants extends Model
{
    use SoftDeletes;
    protected $table = 'system_constants';
    protected $fillable = ['name_ar', 'user_id', 'name_en', 'value', 'value2', 'value3', 'type', 'order', 'photo', 'status', 'user_id'];

    public function user_type()
    {
        return $this->where('type', 'user_type')->where('status', 1)->get(['value as id', 'name_ar as name', 'photo']);
    }

    public function constants($constact)
    {
        $lang = \App::getLocale();
        return $this->where('type', $constact)->where('status', 1)->get(['value as id', "name_$lang as name", 'name_en']);
    }

    public function sub_menu()
    {
        $lang = \App::getLocale();
        return $this->hasMany(System_Constants::class, 'value3', 'value')->select('value as id', "name_$lang as name", "type", "photo as image", 'value3', 'value2');
    }

    public function children()
    {
        $lang = \App::getLocale();
        return $this->hasMany(System_Constants::class, 'type', 'value2')->select('value as id', "name_$lang as name", "type", "photo as image");
    }

    public function getSystem($name, $type)
    {
        $system = $this->OrderBy('system_constants.id', 'desc')->where('system_constants.admin', 0);
        if ($name != '') {
            $system = $system->Where('system_constants.name_ar', 'like', '%' .  $name . '%');
        }
        if ($type != '') {
            $system = $system->Where('system_constants.type', $type);
        }
        $system = $system->leftJoin('system_constants as sys', function ($join) {
            $join->on('system_constants.type', '=', 'sys.value2')->where('sys.type', 'system_constants')->whereNull('sys.deleted_at');
        });
        return $system = $system->where('system_constants.type', '!=', 'system_constants')->where('system_constants.type', '!=', 'type')->select(['system_constants.id', 'system_constants.value as id_system_constants', 'system_constants.name_ar', 'system_constants.status', 'system_constants.type', 'sys.name_ar as type_name'])->paginate(20);
    }

    public function addconstant($name, $type, $status, $name_en, $governorate)
    {
        $this->name_ar = $name;
        $this->name_en = $name_en;
        $this->type = $type;
        $this->status = $status;
        $value = $this->where('type', $type)->max('value');
        $this->value = $value + 1;
        $this->user_id = \Auth::user()->id;
        // $this->value3 = $governorate;

        $this->save();
        return $this;
    }

    public function getconstant($id)
    {
        return $this->find($id);
    }

    public function updateconstant($obj, $name, $type, $name_en, $governorate)
    {
        $obj->name_ar = $name;
        $obj->name_en = $name_en;
        if ($type == 'city') {
            $obj->value3 = $governorate;
        }
        return $obj->save();
    }

    public function UpdateStatus($obj)
    {
        if ($obj->status == 0) {
            $obj->status = 1;
        } else {
            $obj->status = 0;
        }
        return  $obj->save();
    }

    public function deleteConstant($obj)
    {
        return $obj->delete();
    }

    public function getBranch($id)
    {
        return $this->where('type', 'branch')->where('value2', $id)->get(['value as id', 'name_ar as name']);
    }

    public function getImageAttribute($img)
    {
        if ($img) {
            return asset('uploads/' . $img);
        } else {
            return asset('uploads/logo.png');
        }
    }
}
