<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UploadsCenter extends Model
{
    use SoftDeletes;
    protected $table = 'uploads_center';
    protected $fillable = ['title', 'image', 'type', 'category', 'user_id'];

    public function addUpload($title, $type, $file, $category)
    {
        $this->title = $title;
        $this->type = $type;
        $this->image = $file;
        $this->category = $category;
        $this->user_id = \Auth::user()->id;
        $this->save();
        return $this;
    }

    public function getFile($type)
    {
        $files = $this->where('type', $type);
        return $files = $files->orderBy('id', 'desc')->first();
    }

    public function search($title, $category, $type)
    {
        $files = $this->where('type', $type);
        if ($title != '') {
            $files = $files->where('title', 'like', '%' .  $title . '%');
        }
        if ($category != '') {
            $files = $files->where('category', '=', $category);
        }
        return $files = $files->orderBy('id', 'desc')->paginate(10);
    }
}
