@extends('site.layout.layout')
@section('url'){{URL::to('/')}}/cours/{{$data['courses']->id}} @stop
@section('title'){{$data['courses']->title}} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['courses']->details,3)}} @stop

@section('css')
<style>


li.ttm-author img {
    width: 55px;
    height: 55px;
    float: right;
    margin-right: unset;
    margin-left: 15px;

}

ul.ttm-coursedetails-box li:not(:last-child):after {
    right: unset;
    left: -15px;

}

#rating i.far,#rating i.fas{
    display: inline-block;
    font: normal normal normal 14px / 1 FontAwesome;
    font-size: inherit;
    text-rendering: auto;
    -webkit-font-smoothing: antialiased;
    width: 20px;
    font-size: 20px;

}
#course-reviews i.far,#course-reviews i.fas{
    display: inline-block;
    font: normal normal normal 14px / 1 FontAwesome;
    font-size: inherit;
    text-rendering: auto;
    -webkit-font-smoothing: antialiased;
    width: 15px;
    font-size: 15px;

}

ul.ttm-coursedetails-box li:first-child {
width: 35% !important;
}

.course-reviews-list li .review-author img {
    margin-right: unset;
    margin-left: 20px;

}
.course-reviews-list li h4.user-name, .review-stars-rated {
    margin: 0 0 10px 14px;
}

@media only screen and (min-width: 1801px) { .ttm-right-span .ttm-col-wrapper-bg-layer { margin-right: 0px; } }

@media only screen and (max-width: 1600px) and (min-width: 1401px) {
    .ttm-right-span .ttm-col-wrapper-bg-layer {
        margin-right: 0px;
    }
}
.ttm-btn.ttm-btn-style-fill.ttm-btn-color-dark{
   border-color: #ae2f2f;
    background-color: #ec3838;
    padding: 0 75px;
    font-size: 20px;
    line-height: 50px;
}
.single-lp_course .ttm-single-course-box {
    padding-bottom: 0px;
}
</style>
@endsection
@section('content')

<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title">{{$data['courses']->title}}</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                        <span>
                            <a title="Homepage" href="{{URL::to('/')}}">{{ __('app.home') }}</a>
                        </span>
                        <span class="ttm-bread-sep">&nbsp;&gt;&nbsp;</span>
                        @if(isset($data['courses']['universitie']))
                            <span class="current">
                                <a href="{{URL::to('/')}}/university/{{$data['courses']['universitie']->id}}">
                                    {{$data['courses']['universitie']->title_ar}}
                                </a>
                            </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>

<div class="site-main">

    <!-- sidebar -->
    <div class="ttm-row sidebar ttm-sidebar-right ttm-bgcolor-white clearfix" style="background-color: #fff;">
        <div class="container">
            <!-- row -->
            <div class="row">
                <div class="col-xl-9 col-lg-8 content-area">
                    <!-- course -->
                    <article class="course single-lp_course">
                        <!-- course-featured-wrapper -->
                        <div class="course-featured-wrapper mb-20">
                            <div class="course-featured">
                                <img class="img-fluid" src="{{URL::to('/')}}/uploads/{{$data['courses']->image}}" style="height: 500px; width: 100%; object-fit: cover;" alt="">
                            </div>
                        </div>
                        <!-- course-featured-wrapper end -->
                        <!-- ttm-course-single-content -->
                        <div class="ttm-course-single-content">
                            <div class="ttm-single-course-box">
                                <ul class="ttm-coursedetails-box">
                                    @if(isset($data['courses']['trainer']))
                                        <li class="ttm-meta-line ttm-author"> 
                                            <img src="{{URL::to('/')}}/uploads/{{$data['courses']['trainer']->photo}}" style="height: 55px; width: 55px; object-fit: cover;" alt="{{$data['courses']['trainer']->title_ar}}" class="avatar photo">
                                            <strong> المدرب </strong>  
                                            <strong>
                                                <a href="{{URL::to('/')}}/trainer/{{ $data['courses']['trainer']->id }}">
                                                {{\App\Http\Helpers\Helpers::cutText($data['courses']['trainer']->title_ar,40,true)}}
                                                </a>
                                            </strong>
                                        </li>
                                    @endif
                                    <li id="rating" class="ttm-meta-line ttm-enroll-stu"> 
                                            @php 
                                                    $val_rating=0;
                                                    if($data['courses']->stars_no != null){

                                                        $val_rating=intval($data['courses']->stars_no)/intval($data['courses']->rate_no);
                                                    }
                                            @endphp
                                        <div class="review-stars-rated" title="4 out of 5 stars">
                                            {{-- <div class="review-stars empty"></div>
                                            <div class="review-stars filled"></div> --}}
                                            <div class="pull-right userRating client_rating" data-rating="{{$val_rating}}"></div>
                                        </div>
                                        {{-- stars_no --}}
                                        <div class="ttm-stu-enroll">
                                            <strong>{{ $data['courses']->rate_no }} طالبا مقييم </strong>
                                        </div>

                                        

                                    </li>
                                    {{-- <li class="ttm-meta-line ttm-course-dur"> 
                                        <strong> مدة الدورة </strong>8 اسابيع
                                    </li> --}}
                                    <li class="ttm-meta-line ttm-course-price"> 
                                        <strong> السعر</strong> {{ $data['courses']->price }} ر.س
                                    </li>
                                   </ul>
                                    @if (Auth::guard('trainers')->check())
                                    @else
                                        <ul class="ttm-coursedetails-box" style="    background-color: unset;">
                                            <li class="ttm-meta-line ttm-course-button"> 
                                                <div class="lp-course-buttons text-center">
                                                    @if($data['courses']->registered == 1 )
                                                        <strong>   انت مشترك في هذه الدورة  </strong>
                                                    @else 
                                                        <button id="checkout_courses" data-id="{{$data['courses']->id}}"  class="lp-button button button-purchase-course ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-fill ttm-btn-color-dark">
                                                            تسجيل بالدورة  
                                                        </button>
                                                    @endif
                                                    {{-- <button data-id="{{$data['courses']->id}}" id="register_for_the_course" class="lp-button button button-purchase-course ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-fill ttm-btn-color-dark">
                                                    </button> --}}
                                                </div>
                                            </li>
                                        </ul>
                                    @endif
                            </div>
                            <div class="ttm-tabs course-tabs" data-effect="fadeIn">
                                <ul class="tabs clearfix">
                                    <li class="tab active"><a href="#"> تفاصيل الدورة </a></li>
                                    <li class="tab"><a href="#"> المادة التعليمية	 </a></li>
                                    @if(isset($data['courses']['trainer']))
                                    <li class="tab"><a href="#"> المدرب</a></li>
                                    @endif
                                    <li class="tab"><a href="#"> التقيمات </a></li>
                                </ul>
                                <div class="content-tab">
                                    <!-- content-inner -->
                                    <div class="content-inner active">
                                        <h4>{{$data['courses']->title}}</h4>

                                        {!! $data['courses']->details  !!}
                                    </div><!-- content-inner end-->
                                    <!-- content-inner -->
                                    <div class="content-inner">
                                        <h4>{{$data['courses']->title}}</h4>
                                        {{-- <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an un it to make a type specimen book. It has survived not only fivnged.</p> --}}
                                        <ul class="course-items">
                                                @foreach ($data['all_data_courses'] as $item)   
                                                    @if($item->type == 1)
                                                        @php 
                                                        $item_videos=$item
                                                        @endphp
                                                        <li class="course-item course-item-lp_lesson ({{$data['courses']->registered  }}-{{ $item_videos->opin }})">
                                                    
                                                            @if($data['courses']->registered == 1 && $item_videos->opin == 1 )
                                                                <a class="course-item-link video" href="{{URL::to('/')}}/video/{{$item_videos->id}}">
                                                                    {{-- {{$item_videos->url}} --}}
                                                                    <span class="item-name"> {{$item_videos->title }}</span>
                                                                    <div class="course-item-meta">
                                                                        <span class="item-meta duration"> متاح  <i class="fa fa-unlock" style="color: #fff"></i> </span>
                                                                    </div>
                                                                </a>
                                                            @else
                                                                <a class="course-item-link video" href="javaScript:;">
                                                                    <span class="item-name"> {{$item_videos->title }}</span>
                                                                    <div class="course-item-meta">
                                                                        <span class="item-meta duration" style="background-color: red;"> مغلق  <i class="fa fa-lock" style="color: #fff"></i> </span>
                                                                    </div>
                                                                </a>
                                                            @endif
                                                        </li>
                                                    @elseif($item->type == 2)
                                                        @php 
                                                        $item_pdf=$item
                                                        @endphp
                                                        <li class="course-item course-item-lp_lesson">
                                                        
                                                            @if($data['courses']->registered == 1 && $item_pdf->opin == 1 )
                                                                <a class="course-item-link pdf" href="{{URL::to('/')}}/pdf/{{$item_pdf->id}}">
                                                                    {{-- {{$item_pdf->url}} --}}
                                                                    <span class="item-name"> {{ $item_pdf->title }}</span>
                                                                    <div class="course-item-meta">
                                                                        <span class="item-meta duration"> متاح  <i class="fa fa-unlock" style="color: #fff"></i> </span>
                                                                    </div>
                                                                </a>
                                                            @else
                                                                <a class="course-item-link pdf" href="javaScript:;">
                                                                    <span class="item-name"> {{ $item_pdf->title }}</span>
                                                                    <div class="course-item-meta">
                                                                        <span class="item-meta duration" style="background-color: red;"> مغلق  <i class="fa fa-lock" style="color: #fff"></i> </span>
                                                                    </div>
                                                                </a>
                                                            @endif
                                                        </li>
                                                    {{-- @elseif($item->type == 3)
                                                        @php 
                                                        $item_flip=$item
                                                        @endphp
                                                        <li class="course-item course-item-lp_lesson">
                                                        
                                                            @if($data['courses']->registered == 1 && $item_flip->opin == 1 )
                                                                <a class="course-item-link" href="{{$item_flip->url}}">
                                                                    <span class="item-name"> 
                                                                        {{$item_flip->title }}</span>
                                                                    <div class="course-item-meta">
                                                                        <span class="item-meta duration"> متاح  <i class="fa fa-unlock" style="color: #fff"></i> </span>
                                                                    </div>
                                                                </a>
                                                            @else
                                                                <a class="course-item-link" href="javaScript:;">
                                                                    <span class="item-name"> {{$item_flip->title }}</span>
                                                                    <div class="course-item-meta">
                                                                        <span class="item-meta duration" style="background-color: red;"> مغلق  <i class="fa fa-lock" style="color: #fff"></i> </span>
                                                                    </div>
                                                                </a>
                                                            @endif
                                                        </li> --}}
                                                    @endif
                                                    
                                                @endforeach
                                            {{-- @if(isset($data['pdf']) && count($data['pdf']) > 0)

                                                    @foreach ($data['pdf'] as $item_pdf)
                                                    <li class="course-item course-item-lp_lesson">
                                                        
                                                        @if($data['courses']->registered == 1 && $item_pdf->opin == 1 )
                                                            <a class="course-item-link pdf" href="{{$item_pdf->url}}">
                                                                <span class="item-name"> {{ $item_pdf->title }}</span>
                                                                <div class="course-item-meta">
                                                                    <span class="item-meta duration"> متاح  <i class="fa fa-unlock" style="color: #fff"></i> </span>
                                                                </div>
                                                            </a>
                                                        @else
                                                            <a class="course-item-link pdf" href="javaScript:;">
                                                                <span class="item-name"> {{ $item_pdf->title }}</span>
                                                                <div class="course-item-meta">
                                                                    <span class="item-meta duration" style="background-color: red;"> مغلق  <i class="fa fa-lock" style="color: #fff"></i> </span>
                                                                </div>
                                                            </a>
                                                        @endif
                                                    </li>
                                                    @endforeach

                                            @endif

                                            @if(isset($data['flip']) && count($data['flip']) > 0)

                                                    @foreach ($data['flip'] as $item_flip)
                                                    <li class="course-item course-item-lp_lesson">
                                                        
                                                        @if($data['courses']->registered == 1 && $item_flip->opin == 1 )
                                                            <a class="course-item-link" href="{{$item_flip->url}}">
                                                                <span class="item-name"> 
                                                                    {{$item_flip->title }}</span>
                                                                <div class="course-item-meta">
                                                                    <span class="item-meta duration"> متاح  <i class="fa fa-unlock" style="color: #fff"></i> </span>
                                                                </div>
                                                            </a>
                                                        @else
                                                            <a class="course-item-link" href="javaScript:;">
                                                                <span class="item-name"> {{$item_flip->title }}</span>
                                                                <div class="course-item-meta">
                                                                    <span class="item-meta duration" style="background-color: red;"> مغلق  <i class="fa fa-pdf" style="color: #fff"></i> </span>
                                                                </div>
                                                            </a>
                                                        @endif
                                                    </li>
                                                    @endforeach

                                            @endif
                                            @if(isset($data['videos']) && count($data['videos']) > 0)
                                                @foreach ($data['videos'] as $item_videos)
                                                <li class="course-item course-item-lp_lesson">
                                                    
                                                    @if($data['courses']->registered == 1 && $item_videos->opin == 1 )
                                                        <a class="course-item-link video" href="{{$item_videos->url}}">
                                                            <span class="item-name"> {{$item_videos->title }}</span>
                                                            <div class="course-item-meta">
                                                                <span class="item-meta duration"> متاح  <i class="fa fa-unlock" style="color: #fff"></i> </span>
                                                            </div>
                                                        </a>
                                                    @else
                                                        <a class="course-item-link video" href="javaScript:;">
                                                            <span class="item-name"> {{$item_videos->title }}</span>
                                                            <div class="course-item-meta">
                                                                <span class="item-meta duration" style="background-color: red;"> مغلق  <i class="fa fa-lock" style="color: #fff"></i> </span>
                                                            </div>
                                                        </a>
                                                    @endif
                                                </li>
                                                @endforeach
                                            @endif --}}
                            
                                        </ul>
                                    </div><!-- content-inner end-->
                                    <!-- content-inner -->
                                    @if(isset($data['courses']['trainer']))
                                        <div class="content-inner">
                                            <div class="d-flex">
                                                <div class="author-img text-center">
                                                    <img style="height: 150px; width: 150px; object-fit: cover;" src="{{URL::to('/')}}/uploads/{{$data['courses']['trainer']->photo}}" alt=" {{ $data['courses']['trainer']->title_ar }}" class="imag-fluid avatar photo">
                                                    <div class="mt-10">
                                                        <a href="instructor-profile.html">
                                                            <h6>{{ $data['courses']['trainer']->title_ar }}</h6>
                                                        </a>
                                                    </div>
                                                </div>
                                                <div class="author-bio pr-30">
                                                    {{ $data['courses']['trainer']->details_ar }}
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    <!-- content-inner -->
                                    <div class="content-inner">
                                        <div class="course-rates">
                                            {{-- قيد البرمجة --}}
                                           
                                        <div id="course-reviews">
                                            <ul class="course-reviews-list">
                                                @foreach ($data['rating'] as $item)
                                                    <li >
                                                        <div class="review-author">
                                                            <img src="{{URL::to('/')}}/uploads/{{$item->client_img}}" 
                                                            width="96" 
                                                            height="96" 
                                                            alt="{{$item->client_name}}" class="avatar photo">
                                                        </div>
                                                        <div class="review-author-info">
                                                            <div class="rev_head">
                                                                <h4 class="user-name">{{$item->client_name}}</h4>
                                                                <div class="review-stars-rated" title="5 out of 5 stars">
                                                                    <div class="pull-right userRating client_rating" data-rating="{{$item->stars_no}}"></div>
                                                                </div>
                                                            </div>
                                                            <div class="rev_content">
                                                                {{-- <div class="review-title">Best Course </div> --}}
                                                                <div class="review-text">
                                                                    {{$item->notes }}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div><!-- content-inner end-->
                                </div>
                            </div>
                            
                        </div> <!-- ttm-course-single-content end -->
                    </article><!-- course end -->
                </div>
                <div class="col-xl-3 col-lg-4 widget-area sidebar-right ttm-col-bgcolor-yes ttm-bg ttm-right-span ttm-bgcolor-grey mt_60 pt-60 mb_60 pb-60 res-991-mt-0 res-991-pt-0">
                    <div class="ttm-col-wrapper-bg-layer ttm-bg-layer"></div>
                    {{-- <aside class="widget widget-search">
                        <form role="search" method="get" class="search-form" action="#">
                            <label>
                            <span class="screen-reader-text">Search for:</span>
                            <input type="search" class="input-text" placeholder="Search …" value="" name="s">
                            </label>
                            <button class="btn" type="submit" value="Search"> <i class="fa fa-search"></i> </button>
                        </form>
                    </aside> --}}
                    <aside class="widget widget-recent-post with-title">
                        <h3 class="widget-title"> الأكثر تسجيلاً </h3>
                        <ul class="widget-post ttm-recent-post-list">
                            @foreach ($data['other_courses'] as $item)
                                <li>
                                    <a href="{{URL::to('/')}}/cours/{{$item->id}}">
                                        <img class="img-fluid" src="{{URL::to('/')}}/uploads/{{$item->image}}" style="height: 70px; width: 70px; object-fit: cover;"  alt="post-img">
                                    </a>
                                    <span class="post-date"> السعر {{ $item->price  }}  ر.س</span>
                                    <a href="{{URL::to('/')}}/cours/{{$item->id}}">
                                        {{\App\Http\Helpers\Helpers::cutText($item->title,75,true)}}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </aside>
                    <aside class="widget widget-Categories with-title">
                        <h3 class="widget-title"> الجامعات </h3>
                        <ul>
                            
                            @foreach ($data['universities'] as $item)
                                <li>
                                    <a href="{{URL::to('/')}}/university/{{$item->id}}"> {{$item->title_ar}} </a>
                                    {{-- <span>3</span> --}}
                                </li>
                            @endforeach
                        </ul>
                    </aside>
                    <aside class="widget widget-Categories with-title">
                        <h3 class="widget-title"> المدربين  </h3>
                        <ul>
                            
                            @foreach ($data['trainer'] as $item)
                                <li>
                                    <a href="{{URL::to('/')}}/trainer/{{$item->id}}"> {{$item->title_ar}} </a>
                                    {{-- <span>3</span> --}}
                                </li>
                            @endforeach
                        </ul>
                    </aside>
                    {{-- <aside class="widget widget-download">
                        <ul class="download">
                            <li><a href="#"><i class="fa fa-file-pdf-o"></i>Download.pdf</a></li>
                            <li><a href="#"><i class="fa fa-file-word-o"></i>Admission Criteria</a></li>
                            <li><a href="#"><i class="fa fa-files-o"></i>Download.txt</a></li>
                        </ul>
                    </aside> --}}
                    
                   
                   
                </div>
            </div><!-- row end -->
        </div>
    </div>
    <!-- sidebar end -->

</div><!--site-main end-->






@endsection
@section('js')
<script>
  
    $(document).on('click', '#checkout_courses', function (e) {

            e.preventDefault();
            var id = $(this).data('id');
            console.log(id);
            $.ajax({
                url: "{{URL::to('/')}}/checkout",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
                        // window.location.href = "{{URL::to('/')}}/checkout_page/".id;
                        window.location.href = "{{URL::to('/')}}/checkout_page/"+id;

                    }else{
                        if(data['x'] == 1){

                            Swal.fire({
                                title: "",
                                text: data["data"],
                                icon: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#0c3591",
                                confirmButtonText: '{{__('lang.ok')}}',
                                cancelButtonText: '{{__('lang.cancel')}}',
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                            setTimeout(function(){
                                    window.location.href = "{{URL::to('/')}}/login";
                                }, 1000);

                        }else{

                            Swal.fire({
                                title: "",
                                text: data["data"],
                                icon: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#0c3591",
                                confirmButtonText: '{{__('lang.ok')}}',
                                cancelButtonText: '{{__('lang.cancel')}}',
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                        }   

                        
                    }
                },
                complete: function () {
                },
            })
        });

        $(document).ready(function(){
            rating();
        })
        function rating(){
            $.each($('.client_rating'), function (indexInArray, valueOfElement) {
            $(this).rating({
                "value": $(this).data('rating'),
                "readonly":true,
                "half":true
            });
            });
        }

</script>
@endsection