@extends('site.layout.layout')
@section('url'){{Request::fullUrl()}}@stop
@section('title'){{\App\Http\Helpers\Helpers::stringReplace($data['setting']->name,3)}}@stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['setting']->description,3)}}@stop

@section('css')
<style>
.single-blog .blog-img a img {
    
    /*height: 215px;*/
}

</style>

@endsection

@section('content')

<section class="hero hero-slider-wrapper hero-slider-style-2" @if(\App::getLocale() == 'ar') dir="rtl" @else dir="ltr" @endif>
    <div class="hero-slider">
        @php 
            $i=1;
        @endphp
        @foreach ($data['slider'] as $item)
            <div class="slide">
                <img src="{{URL::to('/')}}/uploads/{{$item->photo}}" alt="" class="slider-bg">
                <div class="container">
                    <div class="row">
                        <div class="col col-lg-8 col-sm-9 slide-caption float-right pr-50">
                            <h3 class="text-right" style="color: #fff;"> {{ $data['count_slider'] }} / <span
                                    style="color: #009D57;font-size: 40px;"> {{ $i }} </span> </h3>
                            <br>
                            <h2 class="text-right"> {{$item->title}}</h2>
                            <p class="text-right" @if(\App::getLocale() == 'ar') dir="rtl" @else dir="ltr" @endif style="text-align: justify !important;font-size: 17px !important;"> {{$item->details}}
                            </p>
                            <br>
                            {{-- <div class="btns float-right">
                                <a href="" class="theme-btn" tabindex="0"> عرض المزيد </a>
                            </div> --}}
                        </div>
                    </div>
                </div>
            </div>
            @php 
                $i++;
            @endphp
        @endforeach
    </div>
</section>


<section class="section-padding offer-section"  style="padding-top: 70px; padding-bottom: 60px;">
    <div class="container">
        <div class="row">

            <div class="col col-md-5 float-right">
                <div class="section-title-s3">
                    <h2>  {{$data['aboutus']->title}} </h2>
                </div>
                <div class="offer-text" style="margin-bottom: 20px">
                    <p style="text-align: justify !important;font-size: 17px;">
                        {!!  Str::limit($data['aboutus']->details, 650) !!}
                    {{-- {{ \App\Http\Helpers\Helpers::cutText($data['aboutus']->details,750,true) }} --}}
                    </p>
                    <br>
                    <br>
               
                    <a  href="{{URL::to('/')}}/{{App::getLocale()}}/page/aboutus" class="theme-btn-s7 read-more" > {{ __('app.See_More') }} </a>
                </div>
            </div>
            <div class="col col-md-7" style="margin-top: 30px;">
                <div class="offer-pic">
                    <img src="{{URL::to('/')}}/uploads/{{$data['aboutus']->photo}}" alt="">
                    {{-- <img src="{{URL::to('/')}}/img/546x450/{{$data['aboutus']->photo}}" alt=""> --}}

                </div>
            </div>
        </div> 
    </div> 
</section>

        <section class="section-padding academy_courses">
            <div class="container">
                <div class="row">
                    <div class="col col-md-8 float-right" >
                        <div class="section-title-s4">
                            <h2>  {{$data['academy_courses']->title}}</h2>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col col-xs-12">
                        <div class="row service-s2-top">
                            @foreach ($data['courses'] as $item)
                                <div class="col col-md-6 col-xs-12 service-s2-tab">
                                    <div class="tab-pane " id="tab-1">
                                        <div class="img-holder">
                                            <img src="{{URL::to('/')}}/uploads/{{$item->image}}" alt="">
                                            {{-- <img src="{{URL::to('/')}}/img/546x450/{{$item->image}}" alt=""> --}}
                                        </div>
                                        <div class="details">
                                            {{-- <span id="cart-rating">4.8 <i class="fa fa-star"></i></span> --}}
                                            @if($item->category)
                                                @if (\App::getLocale() == 'ar')
                                                <h4> {{$item->category->name_ar}}</h4>
                                                @else
                                                <h4> {{$item->category->name_en}}</h4>
                                                @endif
                                            @endif
                                            <h3 style="  font-weight: 400;"> {{$item->title}}</h3>
                                            <p style="margin-bottom: 40px; color: #9c9c9c;min-height: 81px;">
                                            {!!\App\Http\Helpers\Helpers::cutText($item->details,200,true)!!}
                                            </p>
                                            <div class="entry-meta">
                                                <ul>
                                                    {{-- <li><i class="fa fa-clock-o"></i> 22 {{ __('app.hour') }} و 30 {{ __('app.minute') }} </li> --}}
                                                    <li><i class="fa fa-download"></i> {{$item->sales}} {{ __('app.sales') }}</li>
                                                </ul>
                                                <ul>
                                                    <li><i class="fa fa-video-camera"></i> {{$item->videos_count}} {{ __('app.video') }} </li>
                                                </ul>
                                                
                                            </div>
                                            <div class="entry-meta">
                                                <a href="javaScript:;" style="color: #009D57;font-weight: 600;font-size: 13px;">
                                                    {{-- <span style="text-decoration: line-through; color: #9c9c9c;">150$</span> --}} {{$item->price}}$
                                                </a>
                                                <a href="{{URL::to('/')}}/{{App::getLocale()}}/cours/{{$item->id}}" class="theme-btn-s7 float-left" style="padding: 3px 7px;font-size: 12px;font-weight: 300;">
                                                    {{ __('app.See_More') }}
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <a href="{{URL::to('/')}}/{{App::getLocale()}}/courses" style="background-color: white;
                    border: 2px solid #fff;  color: #009D57 ;" class="theme-btn-s5">  {{ __('app.See_More') }}  </a>
                </div>
            </div>
        </section>



        <section class="fun-fact parallax" data-bg-image="{{URL::to('/')}}/site/assets/images/cuonter.jpg" @if(\App::getLocale() == 'ar') dir="rtl" @else dir="ltr" @endif>
            <div class="container">
                <div class="row start-count">
                    <div class="col col-sm-12">
                        <h2 style="color: #fff;font-weight: 300; line-height: 45px;">
                            {{$data['statistics_site']->title}}
                        </h2>
                    </div>
                    @foreach ($data['statistics'] as $item)
                        <div class="col col-md-4 col-xs-12 col-sm-12 float-right">
                            <div class="grid">
                                <h3><span class="counter" data-count="{{$item->number}}">00</span><span>+</span></h3>
                                <span class="fact-title"> {{$item->title}} </span>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>




        <section class="section-padding">
            <div class="container">
                <div class="row">
                    <div class="col col-md-8 float-right">
                        <div class="section-title-s4">
                            <h2>{{$data['academy_news']->title}}</h2>
                        </div>
                    </div>
                    <div class="col col-md-4">
                        <div class="all-service-link">
                            <a href="{{URL::to('/')}}/{{App::getLocale()}}/posts" class="theme-btn-s7"> {{ __('app.See_More') }}</a>
                        </div>
                    </div>
                </div>
                <div class="row d-flex">
                    @foreach ($data['post'] as $item)
                        <article class="Articles col-lg-4 col-md-6 mb-30 wow fadeInUp  animated">
                            <div class="post-card-1 border-radius-10 hover-up">
                                <div class="post-thumb thumb-overlay img-hover-slide position-relative"
                                    style="background-image: url({{URL::to('/')}}/uploads/{{$item->main_image}})">
                                    <!-- <a class="img-link"
                                        href="https://www.amal-coalition.ps/ar/posts/14/تحالف-أمل-لمناهضة-العنف-ضد-المرأة-بالتعاون-ملتقى-إعلاميات-الجنوب&nbsp;يعقدان-ورشة-عمل-توعوية-حول-قانون-حماية-الأسرة-من-العنف">
                                    </a> -->
                                </div>
                                <div class="post-content p-30">
                                    <div class="entry-meta meta-0 font-small mb-10">
                                        <a href="{{URL::to('/')}}/{{App::getLocale()}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                            <span class="post-cat text-uppercase">
                                            {{\App\Http\Helpers\Helpers::cutText($item->title,55,true)}}
                                            </span>
                                        </a>
                                    </div>
                                    <div class="post-excerpt  font-small text-muted" style="min-height: 60px;">
                                        <p>
                                            {{\App\Http\Helpers\Helpers::cutText($item->summary,220,true)}}
                                        </p>
                                    </div>
                                    <div class="meta">
                                        <span>
                                            <i class="fa fa-calendar" style="color: #009D57 ;"></i>
                                            @if(\App::getLocale() == 'ar')

                                            {{\App\Http\Helpers\Helpers::getDayName($item->date)}} , {{date('d',strtotime($item->date))}} {{\App\Http\Helpers\Helpers::get_month_name(date('M',strtotime($item->date)))}}  {{date('Y',strtotime($item->date))}} 
                                            @else 
                                            {{\App\Http\Helpers\Helpers::getDayNameEn($item->date)}} , {{date('d',strtotime($item->date))}} {{\App\Http\Helpers\Helpers::get_month_nameEn(date('M',strtotime($item->date)))}}  {{date('Y',strtotime($item->date))}} 

                                            @endif
                                        </span>
                                        <a href="{{URL::to('/')}}/{{App::getLocale()}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}" class="float-left" style="color: #009D57; font-size: 14px;">  {{ __('app.See_More') }}  &nbsp;&nbsp; <i class="fa fa-angle-left"></i>
                                        </a>
                                    </div>

                                </div>
                            </div>
                        </article>
                    @endforeach

                </div>
            </div>
        </section>

        <section class="section-padding partners">
            <h2 class=""> </h2>
            <div class="container">
                <div class="row">
                    <div class="col col-md-12">
                        <div class="section-title-s4 text-center">
                            <h2> {{$data['institutions_site']->title}}</h2>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col col-xs-12">
                        <div class="partners-slider" style="height: 120px;">
                            @foreach ($data['institutions'] as $item)
                                <div class="grid" onclick="location.href='{{$item->url}}';">
                                    <img src="{{URL::to('/')}}/uploads/{{$item->photo}}" alt="{{$item->title}}">
                                    {{-- <img src="{{URL::to('/')}}/img/546x450/{{$item->photo}}" alt="{{$item->title}}"> --}}
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="cta section-padding ">
            <div class="container">
                <div class="row">
                    <div class="col col-xs-12">
                        <h2>
                            {{$data['questions']->title}}
                        </h2>
                        <a href="{{URL::to('/')}}/{{App::getLocale()}}/contact_us" style="border: 2px solid #fff;  color: #fff ;" class="theme-btn-s5">{{ __('app.contact_us') }}</a>
                    </div>
                </div>
            </div>
        </section>



@endsection
@section('js')
<script>
</script>
@stop