@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/{{App::getLocale()}}/portal @stop
@section('title'){{ __('app.portal') }} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace('')}} @stop

@section('css')
<style>

</style>
@endsection
@section('content')
<section class="page-title">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <h2>{{ __('app.create_new_account') }}</h2>
                <ol class="breadcrumb">
                    <li class="">{{ __('app.create_new_account') }}</li>
                    <li class="float-right"><a href="{{URL::to('/')}}/{{App::getLocale()}}">{{ __('app.home') }}</a></li>
                </ol>
            </div>
        </div> 
    </div> 
</section>   

<section class="contact-section section-padding " >
    <div class="container">
        <div class="row " style="justify-content: center">
           
            <div class="col col-lg-6 col-md-7" style="float: unset !important ;    margin: 0 auto;">
                <div class="section-title-white">
                    <h2>{{$data['static']->title}}</h2>
                </div>   
                {!! $data['static']->details !!}
                <div class="contact-form-s1 form">
                    <form method="post" id="form_register" class="wpcf7-form contact-validation-active">
                        {{ csrf_field() }}
                        <div>
                            <label for="name">{{ __('app.name') }}</label>
                            <input type="text" id="name" name="name">
                        </div>
                        <div>
                            <label for="email">{{ __('app.email') }}</label>
                            <input type="email" id="email" name="email">
                        </div>
                        <div>
                            <label for="mobile">{{ __('app.mobile') }}</label>
                            <input type="mobile" id="mobile" name="mobile">
                        </div>
                        <div>
                            <label for="password">{{ __('app.password') }}  </label>
                            <input type="password" id="password" name="password">
                        </div>
                        <div>
                            <label for="password_confirmation">{{ __('app.password_confirmation') }}  </label>
                            <input type="password" id="password_confirmation" name="password_confirmation">
                        </div>
                        <div>
                            <label for="gender">{{__('app.gender')}}  </label>
                            <select name="gender" id="gender">
                                <option value=""> {{ __('app.select') }}</option>
                                <option value="1">{{ __('app.male') }}</option>
                                <option value="2">{{ __('app.female') }}</option>
                            </select>
                        </div>
                        <div>
                            <label for="dob">{{ __('app.dob') }}</label>
                            <input type="date" id="dob" name="dob">
                        </div>
                        <div>
                            <label for="governorate">{{__('app.governorate')}}  </label>
                            <select name="governorate" id="governorate">
                                <option value=""> {{ __('app.select') }} </option>
                                    @foreach ($data['governorate'] as $item)
                                        <option value="{{ $item->id }}"> {{ $item->name }} </option>
                                    @endforeach
                            </select>
                            {{-- <input type="password" id="password_confirmation" name="password_confirmation"> --}}
                        </div>
                        <div>
                            <label for="city">{{__('app.city')}}  </label>
                            <select name="city" id="city">
                                <option value=""> {{ __('app.select') }} </option>
                                    
                            </select>
                            {{-- <input type="password" id="password_confirmation" name="password_confirmation"> --}}
                        </div>
                        <div style="width: 100%;">
                            <label for="title">{{ __('app.title') }}</label>
                            <input type="text" id="title" name="title">
                        </div>
                       
                        <div>
                            <label for="Degree">{{ __('app.Degree') }}</label>
                            <select name="Degree" id="Degree">
                                <option value=""> {{ __('app.select') }} </option>
                                    @foreach ($data['Degree'] as $item)
                                        <option value="{{ $item->id }}"> {{ $item->name }} </option>
                                    @endforeach
                            </select>
                        </div>
                        <div>
                            <label for="Specialization">{{ __('app.Specialization') }}</label>
                            <input type="text" id="Specialization" name="Specialization">
                        </div>
                        <div class="submit-btn-wrap">
                            <input value="{{ __('app.create_new_account') }}" class="theme-btn wpcf7-submit" type="submit">
                        </div>
                        <div class="submit-btn-wrap text-center" style="padding-top: 10px;">
                            <a href="{{URL::to('/')}}/{{App::getLocale()}}/portal" style="color: #009D57;  font-size: 1.2rem;font-weight: 600;">  {{ __('app.login') }}</a>
                        </div>

                        
                    </form>
                </div>                     
            </div>
        </div> <!-- end row -->
    </div> <!-- end container -->
   
</section>
<!-- end contact-section -->

@endsection
@section('js')
<script>

/*************************************************/
    $(document).on('change','#form_register #governorate',function(e){
        var id = $(this).val();
        $('#form_register #loading').show();

        $.ajax({
            url: "{{URL::to('/')}}/{{App::getLocale()}}/get_city",
            type: "get",
            dataType: "JSON",
            data: {
                id: id
            },
            success: function(data){
                $('#form_register #loading').hide();
                if(data['status'] == true){
                    $('#form_register #city').empty().html(data.data);
                }else{
                swal({
                        title: "",
                        text: data["data"],
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "حسنا",
                        cancelButtonText: "الغاء",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                }
            },
            complete: function () {

            }
        });
    });
/*************************************************/
    $(document).on('submit', '#form_register', function (e) {
                e.preventDefault();


                var formData = new FormData(this);
                    $.ajax({
                        url: "{{URL::to('/')}}/{{App::getLocale()}}/register",
                        type: "post",
                        cache:false,
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (data) {
                            $('#loading').hide();
                            if (data["status"] == true) {
                                Swal.fire({
                                    title: "",
                                    text: data.data,
                                    type: "success",
                                    timer: 2000,
                                });

                                setTimeout(function(){
                                    window.location.href = "{{URL::to('/')}}/{{App::getLocale()}}/profile";
                                }, 1000);
                            
                            } else {
                                if(data["data"]){

                                    Swal.fire({
                                    title: "",
                                    html: data.data,
                                    type: "error",
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: '{{__('lang.ok')}}',
                                    cancelButtonText: '{{__('lang.cancel')}}',
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });

                                }else{

                                var errorMessage = "";
                                for (const error in data["data_validator"]) {
                                    if (data["data_validator"].hasOwnProperty(error)) {
                                        errorMessage += '<p>'+data["data_validator"][error]+'<br></p> <br>';
                                    }
                                }
                                Swal.fire({
                                    title: "",
                                    html: errorMessage,
                                    type: "error",
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: '{{__('lang.ok')}}',
                                    cancelButtonText: '{{__('lang.cancel')}}',
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                                }

                            }
                            $('#c27-site-wrapper .loader-bg').css('display', 'none');
                            $('#c27-site-wrapper .loader-bg').css('background-color','#fff');
                            $('#c27-site-wrapper .loader-bg').css('opacity','0');
                        }
                    });

    });

</script>
@endsection