@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/TrainingCourses @stop
@section('title') الدورات التدريبية @stop
@section('image') @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace('الدورات التدريبية ')}} @stop

@section('css')
<style>


</style>
@endsection
@section('content')
<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title"> الدورات التدريبية</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>
<div class="site-main">
    <section class="ttm-row course-section_3 clearfix">
        <div class="container" >
            <div class="row">
                <div class="col-md-4">
                    <label style="width: 100%;">
                        <span class="text-input with-icon-pos_left">
                            <select name="universities" id="universities" class="universities">
                                <option value="">  الجامعة   </option>
                                @foreach ( $data['universities'] as $item)
                                    <option value="{{ $item->id }}"> {{ $item->title_ar }}</option>
                                @endforeach
                            </select>
                        </span>
                    </label>
                </div>
                <div class="col-md-4">
                    <label style="width: 100%;">
                        <span class="text-input with-icon-pos_left">
                            <select name="trainer" id="trainer" class="trainer">
                                <option value="">  اختر الجامعة   </option>
                            </select>
                        </span>
                    </label>
                </div>
            </div>
        </div>
        <div class="container" id="table_training_courses">
            @include('site.sub.table_training_courses')
        </div>
    </section> 
</div>



@endsection
@section('js')
<script>
    /*************************************************/
    $(document).on('change','#trainer',function(e){
        var id = $(this).val();
        var universities = $('#universities').val();
        $('#preloader').css('display', '');
        $('#status').css('display', '');
        // $('#preloader').css('display','none');
        // $('#status').css('display','none');
        $.ajax({
            url: "{{URL::to('/')}}/getDataTrainer",
            type: "get",
            dataType: "JSON",
            data: {
                id: id,
                universities:universities
            },
            success: function(data){
                if(data['status'] == true){
                    $('#table_training_courses').empty().html(data.data);
                }else{
                swal({
                        title: "",
                        text: data["data"],
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "حسنا",
                        cancelButtonText: "الغاء",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                }
            },
            complete: function () {
                $('#preloader').css('display','none');
                $('#status').css('display','none');
            }
        });
    });

    /*************************************************/
    $(document).on('change','#universities',function(e){
        var id = $(this).val();
        $('#preloader').css('display', '');
        $('#status').css('display', '');

        // $('#preloader').css('display','none');
        // $('#status').css('display','none');
        $.ajax({
            url: "{{URL::to('/')}}/getDataUniversities",
            type: "get",
            dataType: "JSON",
            data: {
                id: id
            },
            success: function(data){
                
                if(data['status'] == true){

                    $('#table_training_courses').empty().html(data.data);
                    $('#trainer').empty().html(data.options_trainer);
                    
                }else{
                swal({
                        title: "",
                        text: data["data"],
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "حسنا",
                        cancelButtonText: "الغاء",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                }
            },
            complete: function () {
                $('#preloader').css('display','none');
                $('#status').css('display','none');
            }
        });
    });
</script>
@endsection