<?php



/*

|--------------------------------------------------------------------------

| Web Routes

|--------------------------------------------------------------------------

|

| Here is where you can register web routes for your application. These

| routes are loaded by the RouteServiceProvider within a group which

| contains the "web" middleware group. Now create something great!

|

*/



Route::get('/home', function () {

    return redirect('/admin/dashboard');
});

// LOGIN ROUTE

Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware'  => ['web', 'guest']], function () {

    // LOGIN ROUTE

    Route::get('login', ['as' => 'login', 'uses' => 'LoginAdminController@getIndex']);

    Route::post('adminlogin', ['as' => 'adminlogin', 'uses' => 'LoginAdminController@postIndex']);
});



Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['web', 'auth']], function () {

    // DASHBOARD ROUTE
    Route::get('dashboard', ['as' => 'admin.dashboard.view', 'uses' => 'DashboardController@index']);
    Route::get('profile', ['as' => 'admin.dashboard.profile', 'uses' => 'DashboardController@getProfile']);
    Route::post('password', ['as' => 'admin.dashboard.password', 'uses' => 'DashboardController@postPassword']);


    //SETTING ROUTE
    Route::get('setting', ['as' => 'admin.setting.index', 'uses' => 'SettingController@index'])->middleware('permission:setting');
    Route::post('setting/update', ['as' => 'admin.setting.update', 'uses' => 'SettingController@update'])->middleware('permission:update_setting');


    // Posts ROUTE
    // Route::get('posts', ['as' => 'admin.posts.index', 'uses' => 'PostsController@index'])->middleware('permission:view_posts');
    // Route::get('posts/edit', ['as' => 'admin.posts.edit', 'uses' => 'PostsController@edit'])->middleware('permission:edit_posts');
    // Route::post('posts/add', ['as' => 'admin.posts.add', 'uses' => 'PostsController@add'])->middleware('permission:add_posts');
    // Route::post('posts/add_post', ['as' => 'admin.posts.add', 'uses' => 'PostsController@add_post'])->middleware('permission:edit_posts');
    // Route::post('posts/delete', ['as' => 'admin.posts.delete', 'uses' => 'PostsController@delete'])->middleware('permission:delete_posts');
    // Route::post('posts/add_tag', ['as' => 'admin.posts.add_tag', 'uses' => 'PostsController@add_tag']);
    // Route::post('posts/search', ['as' => 'admin.posts.search', 'uses' => 'PostsController@search']);
    // Route::post('posts/delete', ['as' => 'admin.posts.delete', 'uses' => 'PostsController@delete']);
    // Route::get('posts/tag_select', ['as' => 'admin.posts.tag_select', 'uses' => 'PostsController@tag_select']);
    // Route::post('posts/delete_news_tag', ['as' => 'admin.posts.delete_news_tag', 'uses' => 'PostsController@delete_news_tag']);

    // USERS ROUTE
    Route::get('users', ['as' => 'admin.users.index', 'uses' => 'UserController@index'])->middleware('permission:view_users');
    Route::get('users/edit', ['as' => 'admin.users.edit', 'uses' => 'UserController@edit'])->middleware('permission:add_users');
    Route::get('users/getpermission', ['as' => 'admin.users.getpermission', 'uses' => 'UserController@getpermission'])->middleware('permission:permission_users');
    Route::post('users/add', ['as' => 'admin.users.add', 'uses' => 'UserController@add'])->middleware('permission:add_users');
    Route::post('users/update', ['as' => 'admin.users.update', 'uses' => 'UserController@update'])->middleware('permission:add_users');
    Route::post('users/UpdateStats', ['as' => 'admin.users.UpdateStats', 'uses' => 'UserController@UpdateStats'])->middleware('permission:change_status_users');
    Route::post('users/delete', ['as' => 'admin.users.delete', 'uses' => 'UserController@delete'])->middleware('permission:delete_users');
    Route::post('users/changepassword', ['as' => 'admin.users.changepassword', 'uses' => 'UserController@changepassword'])->middleware('permission:change_password_user');
    Route::post('users/permission', ['as' => 'admin.users.permission', 'uses' => 'UserController@permission'])->middleware('permission:permission_users');
    Route::post('users/userpermission', ['as' => 'admin.users.userpermission', 'uses' => 'UserController@userpermission'])->middleware('permission:permission_users');

    // VIDEO ROUTE
    Route::get('videos', ['as' => 'admin.video.index', 'uses' => 'VideosController@index'])->middleware('permission:view_video');
    Route::get('videos/edit', ['as' => 'admin.video.edit', 'uses' => 'VideosController@edit'])->middleware('permission:edit_video');
    Route::post('videos/add', ['as' => 'admin.video.add', 'uses' => 'VideosController@add'])->middleware('permission:add_video');
    Route::post('videos/update', ['as' => 'admin.video.update', 'uses' => 'VideosController@update'])->middleware('permission:edit_video');
    Route::post('videos/delete', ['as' => 'admin.video.delete', 'uses' => 'VideosController@delete'])->middleware('permission:delete_video');
    Route::post('videos/UpdateStats', ['as' => 'admin.video.UpdateStats', 'uses' => 'VideosController@UpdateStats'])->middleware('permission:update_status_video');
    Route::post('videos/add_humidity', ['as' => 'admin.video.add_humidity', 'uses' => 'VideosController@add_humidity']);

    // ALBUMS ROUTE
    Route::get('albums', ['as' => 'admin.albums.index', 'uses' => 'AlbumsController@index'])->middleware('permission:view_albums');
    Route::get('albums/edit', ['as' => 'admin.albums.edit', 'uses' => 'AlbumsController@edit'])->middleware('permission:edit_album');
    Route::get('albums/getImages', ['as' => 'admin.albums.getImages', 'uses' => 'AlbumsController@getImages'])->middleware('permission:view_images');
    Route::post('albums/postImages', ['as' => 'admin.albums.postImages', 'uses' => 'AlbumsController@postImages'])->middleware('permission:add_images');
    Route::post('albums/deleteImages', ['as' => 'admin.albums.deleteImages', 'uses' => 'AlbumsController@deleteImages'])->middleware('permission:delete_images');
    Route::post('albums/add', ['as' => 'admin.albums.add', 'uses' => 'AlbumsController@add'])->middleware('permission:add_album');
    Route::post('albums/update', ['as' => 'admin.albums.update', 'uses' => 'AlbumsController@update'])->middleware('permission:edit_album');
    Route::post('albums/delete', ['as' => 'admin.albums.delete', 'uses' => 'AlbumsController@delete'])->middleware('permission:delete_images');
    Route::post('albums/UpdateStats', ['as' => 'admin.albums.UpdateStats', 'uses' => 'AlbumsController@UpdateStats'])->middleware('permission:update_status_album');


    // SYSTEM CONSTANT  ROUTE
    Route::get('system_constants', ['as' => 'admin.system_constants.index', 'uses' => 'SystemConstantController@index'])->middleware('permission:view_system_constants');
    Route::get('system_constants/edit', ['as' => 'admin.system_constants.edit', 'uses' => 'SystemConstantController@edit'])->middleware('permission:update_system_constants');
    Route::post('system_constants/add', ['as' => 'admin.system_constants.add', 'uses' => 'SystemConstantController@add'])->middleware('permission:add_system_constants');
    Route::post('system_constants/update', ['as' => 'admin.system_constants.update', 'uses' => 'SystemConstantController@update'])->middleware('permission:update_system_constants');
    Route::post('system_constants/delete', ['as' => 'admin.system_constants.delete', 'uses' => 'SystemConstantController@delete'])->middleware('permission:delete_system_constants');
    Route::post('system_constants/UpdateStats', ['as' => 'admin.system_constants.UpdateStats', 'uses' => 'SystemConstantController@UpdateStats'])->middleware('permission:status_system_constants');

    //CONTACT ROUTE
    Route::get('contact', ['as' => 'admin.contact.index', 'uses' => 'ContactUsController@index'])->middleware('permission:contact');
    Route::get('contact/view', ['as' => 'admin.contact_view.index', 'uses' => 'ContactUsController@view'])->middleware('permission:view_contact');
    Route::post('contact/reply_view', ['as' => 'admin.reply_view.index', 'uses' => 'ContactUsController@reply'])->middleware('permission:reply_contact');

    // UPLOAD CENTER ROUTE
    Route::get('uploads/getCategory', ['as' => 'admin.uploads.getCategory', 'uses' => 'UploadsController@getCategory']);
    Route::post('uploads/addCategory', ['as' => 'admin.uploads.addCategory', 'uses' => 'UploadsController@addCategory']);
    Route::get('uploads/getSelectCategory', ['as' => 'admin.uploads.getSelectCategory', 'uses' => 'UploadsController@getSelectCategory']);
    Route::get('uploads/getFile', ['as' => 'admin.uploads.getFile', 'uses' => 'UploadsController@getFile']);
    Route::get('uploads/search', ['as' => 'admin.uploads.search', 'uses' => 'UploadsController@search']);
    Route::post('uploads/update_category', ['as' => 'admin.uploads.update_category', 'uses' => 'UploadsController@update_category']);
    Route::post('uploads/getLink', ['as' => 'admin.uploads.getLink', 'uses' => 'UploadsController@getLink']);
    Route::post('uploads/upload_file', ['as' => 'admin.uploads.upload_file', 'uses' => 'UploadsController@upload_file']);
    Route::post('uploads/upload_image', ['as' => 'admin.uploads.upload_image', 'uses' => 'UploadsController@upload_image']);
    Route::post('uploads/deleteCategory', ['as' => 'admin.uploads.deleteCategory', 'uses' => 'UploadsController@deleteCategory']);
    Route::post('uploads/deleteUpload', ['as' => 'admin.uploads.deleteUpload', 'uses' => 'UploadsController@deleteUpload']);

    // Tags ROUTE
    Route::get('tags', ['as' => 'admin.tags.index', 'uses' => 'TagController@index'])->middleware('permission:view_tags');
    Route::get('tags/edit', ['as' => 'admin.tags.edit', 'uses' => 'TagController@edit'])->middleware('permission:edit_tags');
    Route::post('tags/update', ['as' => 'admin.tags.update', 'uses' => 'TagController@update'])->middleware('permission:edit_tags');
    Route::post('tags/add_tag', ['as' => 'admin.tags.add', 'uses' => 'TagController@add_tag'])->middleware('permission:add_tags');
    Route::post('tags/delete', ['as' => 'admin.tags.delete', 'uses' => 'TagController@delete'])->middleware('permission:delete_tags');
    Route::post('tags/UpdateStats', ['as' => 'admin.tags.UpdateStats', 'uses' => 'TagController@UpdateStats']);

    // Slider ROUTE
    Route::get('slider', ['as' => 'admin.slider.index', 'uses' => 'SliderController@index'])->middleware('permission:view_sliders');
    Route::get('slider/edit', ['as' => 'admin.slider.edit', 'uses' => 'SliderController@edit'])->middleware('permission:update_sliders');
    Route::post('slider/add', ['as' => 'admin.slider.add', 'uses' => 'SliderController@add'])->middleware('permission:add_sliders');
    Route::post('slider/update', ['as' => 'admin.slider.update', 'uses' => 'SliderController@update'])->middleware('permission:update_sliders');
    Route::post('slider/delete', ['as' => 'admin.slider.delete', 'uses' => 'SliderController@delete'])->middleware('permission:delete_sliders');

    // Statistics ROUTE
    Route::get('statistics', ['as' => 'admin.statistics.index', 'uses' => 'StatisticsController@index'])->middleware('permission:view_statistics');
    Route::get('statistics/edit', ['as' => 'admin.statistics.edit', 'uses' => 'StatisticsController@edit'])->middleware('permission:update_statistics');
    Route::post('statistics/add', ['as' => 'admin.statistics.add', 'uses' => 'StatisticsController@add'])->middleware('permission:add_statistics');
    Route::post('statistics/update', ['as' => 'admin.statistics.update', 'uses' => 'StatisticsController@update'])->middleware('permission:update_statistics');
    Route::post('statistics/delete', ['as' => 'admin.statistics.delete', 'uses' => 'StatisticsController@delete'])->middleware('permission:delete_statistics');

    // Courses ROUTE
    Route::get('courses', ['as' => 'admin.courses.index', 'uses' => 'CourseController@index'])->middleware('permission:view_courses');
    Route::get('courses/edit', ['as' => 'admin.courses.edit', 'uses' => 'CourseController@edit'])->middleware('permission:update_courses');
    Route::get('courses/videos', ['as' => 'admin.courses.videos', 'uses' => 'CourseController@videos'])->middleware('permission:videos_courses');
    Route::post('courses/add', ['as' => 'admin.courses.add', 'uses' => 'CourseController@add'])->middleware('permission:add_courses');
    Route::post('courses/update', ['as' => 'admin.courses.update', 'uses' => 'CourseController@update'])->middleware('permission:update_courses');
    Route::post('courses/delete', ['as' => 'admin.courses.delete', 'uses' => 'CourseController@delete'])->middleware('permission:delete_courses');
    Route::post('courses/videos/add', ['as' => 'admin.courses.videos-add', 'uses' => 'CourseController@addVideo'])->middleware('permission:add_videos_courses');
    Route::post('courses/videos/delete', ['as' => 'admin.courses.videos-delete', 'uses' => 'CourseController@deleteVideo'])->middleware('permission:delete_videos_courses');
    Route::get('courses/showfavorite', ['as' => 'admin.courses.showfavorite', 'uses' => 'CourseController@showfavorite']);
    Route::get('courses/print_xls/{id}', ['as' => 'admin.courses.print_xls', 'uses' => 'CourseController@print_xls']);
    Route::get('courses/getTrainers', ['as' => 'admin.courses.getTrainers', 'uses' => 'CourseController@getTrainers']);
    Route::post('courses/UpdateOpin', ['as' => 'admin.courses.UpdateOpin', 'uses' => 'CourseController@UpdateOpin']);
    Route::post('courses/UpdateRating', ['as' => 'admin.courses.UpdateRating', 'uses' => 'CourseController@UpdateRating']);
    Route::post('courses/UpdateStats', ['as' => 'admin.courses.UpdateStats', 'uses' => 'CourseController@UpdateStats']);


    // Institutions ROUTE
    Route::get('institutions', ['as' => 'admin.institutions.index', 'uses' => 'InstitutionController@index'])->middleware('permission:view_institutions');
    Route::get('institutions/edit', ['as' => 'admin.institutions.edit', 'uses' => 'InstitutionController@edit'])->middleware('permission:update_institutions');
    Route::post('institutions/add', ['as' => 'admin.institutions.add', 'uses' => 'InstitutionController@add'])->middleware('permission:add_institutions');
    Route::post('institutions/update', ['as' => 'admin.institutions.update', 'uses' => 'InstitutionController@update'])->middleware('permission:update_institutions');
    Route::post('institutions/delete', ['as' => 'admin.institutions.delete', 'uses' => 'InstitutionController@delete'])->middleware('permission:delete_institutions');

    // STATIC ROUTE
    Route::get('static_page', ['as' => 'admin.static_page.index', 'uses' => 'StaticPageController@index'])->middleware('permission:view_page');
    Route::get('static_page/edit', ['as' => 'admin.static_page.edit', 'uses' => 'StaticPageController@edit'])->middleware('permission:edit_page');
    Route::post('static_page/add', ['as' => 'admin.static_page.add', 'uses' => 'StaticPageController@add'])->middleware('permission:add_page');
    Route::post('static_page/update', ['as' => 'admin.static_page.update', 'uses' => 'StaticPageController@update'])->middleware('permission:edit_page');
    Route::post('static_page/UpdateStats', ['as' => 'admin.static_page.UpdateStats', 'uses' => 'StaticPageController@UpdateStats'])->middleware('permission:update_status_page');
    Route::post('static_page/delete', ['as' => 'admin.static_page.delete', 'uses' => 'StaticPageController@delete'])->middleware('permission:delete_page');

    // SOCAIL ROUTE
    Route::get('social', ['as' => 'admin.social.index', 'uses' => 'SocialLinksController@index'])->middleware('permission:view_social');
    Route::get('social/edit', ['as' => 'admin.social.edit', 'uses' => 'SocialLinksController@edit'])->middleware('permission:edit_social');
    Route::post('social/update', ['as' => 'admin.social.update', 'uses' => 'SocialLinksController@update'])->middleware('permission:edit_social');
    Route::post('social/add', ['as' => 'admin.social.add', 'uses' => 'SocialLinksController@add'])->middleware('permission:add_social');
    Route::post('social/UpdateStats', ['as' => 'admin.social.UpdateStats', 'uses' => 'SocialLinksController@UpdateStats'])->middleware('permission:update_status_social');
    Route::post('social/delete', ['as' => 'admin.social.delete', 'uses' => 'SocialLinksController@delete'])->middleware('permission:delete_social');

    // Email ROUTE
    Route::get('email', ['as' => 'admin.email.index', 'uses' => 'EmailController@index']);
    Route::get('email/edit', ['as' => 'admin.email.edit', 'uses' => 'EmailController@edit']);
    Route::post('email/add', ['as' => 'admin.email.add', 'uses' => 'EmailController@add']);
    Route::post('email/update', ['as' => 'admin.email.update', 'uses' => 'EmailController@update']);
    Route::post('email/UpdateStats', ['as' => 'admin.email.UpdateStats', 'uses' => 'EmailController@UpdateStats']);
    Route::post('email/delete', ['as' => 'admin.email.delete', 'uses' => 'EmailController@delete']);

    // Notifications ROUTE
    Route::get('notifications', ['as' => 'admin.notifications.index', 'uses' => 'NotificationsController@index']);
    Route::get('notifications/edit', ['as' => 'admin.notifications.edit', 'uses' => 'NotificationsController@edit']);
    Route::post('notifications/add', ['as' => 'admin.notifications.add', 'uses' => 'NotificationsController@add']);
    Route::post('notifications/update', ['as' => 'admin.notifications.update', 'uses' => 'NotificationsController@update']);
    Route::post('notifications/UpdateStats', ['as' => 'admin.notifications.UpdateStats', 'uses' => 'NotificationsController@UpdateStats']);
    Route::post('notifications/delete', ['as' => 'admin.notifications.delete', 'uses' => 'NotificationsController@delete']);

    // notifications_stor ROUTE
    Route::get('notifications_stor', ['as' => 'admin.notifications_stor.index', 'uses' => 'NotificationsStorController@index']);
    Route::post('notifications_stor/send_not', ['as' => 'admin.notifications_stor.send_not', 'uses' => 'NotificationsStorController@send_not']);
    
    
    Route::get('payment', ['as' => 'admin.payment.index', 'uses' => 'PaymentController@index']);


    
    Route::get('clients', ['as' => 'admin.clients.index', 'uses' => 'ClientController@index']);
    Route::get('clients/edit', ['as' => 'admin.clients.edit', 'uses' => 'ClientController@edit']);
    Route::post('clients/add', ['as' => 'admin.clients.add', 'uses' => 'ClientController@add']);
    Route::post('clients/update', ['as' => 'admin.clients.update', 'uses' => 'ClientController@update']);
    Route::post('clients/UpdateStats', ['as' => 'admin.clients.UpdateStats', 'uses' => 'ClientController@UpdateStats']);
    Route::post('clients/delete', ['as' => 'admin.clients.delete', 'uses' => 'ClientController@delete']);
    Route::post('clients/changepassword', ['as' => 'admin.clients.changepassword', 'uses' => 'ClientController@changepassword']);
    Route::get('clients/showfavorite', ['as' => 'admin.clients.showfavorite', 'uses' => 'ClientController@showfavorite']);

    // 
    // universities ROUTE
    Route::get('universities', ['as' => 'admin.universities.index', 'uses' => 'UniversitiesController@index']);
    Route::get('universities/edit', ['as' => 'admin.universities.edit', 'uses' => 'UniversitiesController@edit']);
    Route::post('universities/add', ['as' => 'admin.universities.add', 'uses' => 'UniversitiesController@add']);
    Route::post('universities/update', ['as' => 'admin.universities.update', 'uses' => 'UniversitiesController@update']);
    Route::post('universities/UpdateStats', ['as' => 'admin.universities.UpdateStats', 'uses' => 'UniversitiesController@UpdateStats']);
    Route::post('universities/delete', ['as' => 'admin.universities.delete', 'uses' => 'UniversitiesController@delete']);

    // trainers ROUTE
    Route::get('trainers', ['as' => 'admin.trainers.index', 'uses' => 'TrainersController@index']);
    Route::get('trainers/edit', ['as' => 'admin.trainers.edit', 'uses' => 'TrainersController@edit']);
    Route::post('trainers/add', ['as' => 'admin.trainers.add', 'uses' => 'TrainersController@add']);
    Route::post('trainers/update', ['as' => 'admin.trainers.update', 'uses' => 'TrainersController@update']);
    Route::post('trainers/UpdateStats', ['as' => 'admin.trainers.UpdateStats', 'uses' => 'TrainersController@UpdateStats']);
    Route::post('trainers/delete', ['as' => 'admin.trainers.delete', 'uses' => 'TrainersController@delete']);

    Route::get('/logout', ['as' => 'admin.dashboard.logout', 'uses' => 'LoginAdminController@getLogout']);

    Route::get('/clear', function () {
        Cache::forget('spatie.permission.cache');
        \Illuminate\Support\Facades\Artisan::call('cache:clear');
        \Illuminate\Support\Facades\Artisan::call('view:clear');
        \Illuminate\Support\Facades\Artisan::call('config:cache');
        return 'cleared';
    });
});
Route::get('/', function () {
    return redirect('/' . \Session::get('locale') ? (in_array(Session::get('locale'), ['ar', 'en']) ? \Session::get('locale') : \App::getlocale()) : \App::getlocale());
});
Route::get('/sitemap.xml', ['as' => 'site.sitemap.xml', 'uses' => 'Site\HomeController@sitemap']);
// Route::get('/sitemapen.xml', ['as' => 'site.sitemapen.xml', 'uses' => 'Site\HomeController@sitemapen']);
Route::get('/rss', ['as' => 'site.rss', 'uses' => 'Site\HomeController@rss']);
Route::middleware(['web'])->namespace('Site')->name('site.')->group(function () {

    Route::get('/', ['as' => 'home', 'uses' => 'HomeController@index']);
    Route::get('/Universities', ['as' => 'site.Universities', 'uses' => 'HomeController@Universities']);
    Route::get('/university/{id}', ['as' => 'site.university', 'uses' => 'HomeController@university']);

    Route::get('/registration', ['as' => 'site.registration', 'uses' => 'HomeController@registration'])->middleware('guest:trainers', 'guest:clients');
    Route::post('/add_student', ['as' => 'site.add_student', 'uses' => 'HomeController@add_student']);
    Route::post('/add_trainer', ['as' => 'site.add_trainer', 'uses' => 'HomeController@add_trainer']);



    Route::get('/profile', ['as' => 'site.profile', 'uses' => 'ProfileController@index'])->middleware('Authclients');
    Route::get('/profile_trainers', ['as' => 'site.profile', 'uses' => 'ProfileController@profile_trainers'])->middleware('Authtrainers');


    Route::get('/logout', ['as' => 'site.logout', 'uses' => 'ProfileController@getLogout'])->middleware('Authclients');
    Route::get('/logout_trainers', ['as' => 'site.logout', 'uses' => 'ProfileController@getLogout'])->middleware('Authtrainers');

    Route::get('/login', ['as' => 'site.login', 'uses' => 'HomeController@portal'])->middleware('guest:trainers', 'guest:clients');
    Route::post('/login', ['as' => 'site.login', 'uses' => 'LoginController@login']);
    Route::post('/contact_us', ['as' => 'site.contact_us', 'uses' => 'HomeController@contacts']);
    Route::get('/cours/{id}/{slug?}', ['as' => 'site.cours', 'uses' => 'HomeController@cours']);

    Route::get('/TrainingCourses', ['as' => 'site.TrainingCourses', 'uses' => 'HomeController@TrainingCourses']);
    Route::get('/getDataUniversities', ['as' => 'site.getDataUniversities', 'uses' => 'HomeController@getDataUniversities']);
    Route::get('/getDataTrainer', ['as' => 'site.getDataTrainer', 'uses' => 'HomeController@getDataTrainer']);
    Route::get('/trainer/{id}', ['as' => 'site.trainer', 'uses' => 'HomeController@trainer']);
    Route::get('/register_for_the_course', ['as' => 'site.register_for_the_course', 'uses' => 'ProfileController@register_for_the_course']);
    Route::get('/edit_profile', ['as' => 'site.edit_profile', 'uses' => 'ProfileController@edit_profile'])->middleware('Authclients');
    Route::post('/update_profile', ['as' => 'site.update_profile', 'uses' => 'ProfileController@update_profile'])->middleware('Authclients');
    Route::post('/removeCours', ['as' => 'site.removeCours', 'uses' => 'ProfileController@removeCours'])->middleware('Authclients');
    Route::get('/checkout', ['as' => 'site.cours', 'uses' => 'HomeController@checkout']);
    Route::post('/donation', ['as' => 'site.donation', 'uses' => 'HomeController@donation']);
    Route::get('/complete_payment', ['as' => 'site.complete_payment', 'uses' => 'HomeController@complete_payment']);
    Route::post('/addrating', ['as' => 'site.addrating', 'uses' => 'ProfileController@addrating'])->middleware('Authclients');



    Route::get('/edit_profile_trainers', ['as' => 'site.edit_profile_trainers', 'uses' => 'ProfileController@edit_profile_trainers'])->middleware('Authtrainers');
    Route::post('/update_profile_trainers', ['as' => 'site.update_profile_trainers', 'uses' => 'ProfileController@update_profile_trainers'])->middleware('Authtrainers');
    Route::post('/add_courses', ['as' => 'site.add_courses', 'uses' => 'ProfileController@add_courses'])->middleware('Authtrainers');
    Route::get('/edit_courses', ['as' => 'site.edit_courses', 'uses' => 'ProfileController@edit_courses'])->middleware('Authtrainers');
    Route::post('/update_courses', ['as' => 'site.update_courses', 'uses' => 'ProfileController@update_courses'])->middleware('Authtrainers');
    Route::get('/showRegisteredCours', ['as' => 'site.showRegisteredCours', 'uses' => 'ProfileController@showRegisteredCours'])->middleware('Authtrainers');
    Route::get('/print_xls/{id}', ['as' => 'site.print_xls', 'uses' => 'ProfileController@print_xls']);


    Route::get('/videos', ['as' => 'site.videos', 'uses' => 'ProfileController@videos'])->middleware('Authtrainers');
    Route::post('/videos/add', ['as' => 'site.videos-add', 'uses' => 'ProfileController@addVideo'])->middleware('Authtrainers');
    Route::post('/videos/delete', ['as' => 'site.videos-delete', 'uses' => 'ProfileController@deleteVideo'])->middleware('Authtrainers');

    Route::get('/video/{id}', ['as' => 'site.video', 'uses' => 'HomeController@video']);
    Route::get('/pdf/{id}', ['as' => 'site.pdf', 'uses' => 'HomeController@pdf']);


    Route::get('/checkout_page/{id}', ['as' => 'site.checkout_page', 'uses' => 'HomeController@checkout_page']);

    // Route::get('/courses', ['as' => 'site.courses', 'uses' => 'HomeController@courses']);
    // Route::get('/posts/{id?}/{slug?}', ['as' => 'site.posts', 'uses' => 'HomeController@posts']);
    // Route::get('/tags/{id}/{slug?}', ['as' => 'site.tags', 'uses' => 'HomeController@tags']);
    // Route::get('/partners', ['as' => 'site.partners', 'uses' => 'HomeController@partners']);
    // Route::post('/search', ['as' => 'site.search', 'uses' => 'HomeController@search']);
    // Route::get('/contact_us', ['as' => 'site.contact', 'uses' => 'HomeController@contact_view']);

    // Route::get('/registr', ['as' => 'site.view_registr', 'uses' => 'HomeController@view_registr']);
    // Route::post('/register', ['as' => 'site.register', 'uses' => 'LoginController@register']);
    // Route::get('/language', ['as' => 'site.lang', 'uses' => 'HomeController@lang']);
    Route::get('/page/{url}', ['as' => 'site.static', 'uses' => 'HomeController@static']);
});
Route::get('/img/{size}/{img}', ['as' => 'site.img.index', 'uses' => 'Site\ImgController@index']);
